/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.execute.sql.execute;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.core.execute.engine.ShardingExecuteEngine;
import org.apache.shardingsphere.core.execute.engine.ShardingExecuteGroup;
import org.apache.shardingsphere.core.execute.sql.StatementExecuteUnit;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteCallback;
import org.apache.shardingsphere.core.execute.sql.execute.threadlocal.ExecutorExceptionHandler;

public final class SQLExecuteTemplate {
    private final ShardingExecuteEngine executeEngine;
    private final boolean serial;

    public <T> List<T> executeGroup(Collection<ShardingExecuteGroup<? extends StatementExecuteUnit>> sqlExecuteGroups, SQLExecuteCallback<T> callback) throws SQLException {
        return this.executeGroup(sqlExecuteGroups, null, callback);
    }

    public <T> List<T> executeGroup(Collection<ShardingExecuteGroup<? extends StatementExecuteUnit>> sqlExecuteGroups, SQLExecuteCallback<T> firstCallback, SQLExecuteCallback<T> callback) throws SQLException {
        try {
            return this.executeEngine.groupExecute(sqlExecuteGroups, firstCallback, callback, this.serial);
        }
        catch (SQLException ex) {
            ExecutorExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @ConstructorProperties(value={"executeEngine", "serial"})
    public SQLExecuteTemplate(ShardingExecuteEngine executeEngine, boolean serial) {
        this.executeEngine = executeEngine;
        this.serial = serial;
    }
}

