/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.execute.sql.execute;

import java.beans.ConstructorProperties;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.core.constant.ConnectionMode;
import org.apache.shardingsphere.core.execute.engine.ShardingGroupExecuteCallback;
import org.apache.shardingsphere.core.execute.hook.SPISQLExecutionHook;
import org.apache.shardingsphere.core.execute.sql.StatementExecuteUnit;
import org.apache.shardingsphere.core.execute.sql.execute.threadlocal.ExecutorExceptionHandler;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.spi.database.DataSourceMetaData;
import org.apache.shardingsphere.spi.database.DatabaseType;

public abstract class SQLExecuteCallback<T>
implements ShardingGroupExecuteCallback<StatementExecuteUnit, T> {
    private static final Map<String, DataSourceMetaData> CACHED_DATASOURCE_METADATA = new ConcurrentHashMap<String, DataSourceMetaData>();
    private final DatabaseType databaseType;
    private final boolean isExceptionThrown;

    @Override
    public final Collection<T> execute(Collection<StatementExecuteUnit> statementExecuteUnits, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) throws SQLException {
        LinkedList<T> result = new LinkedList<T>();
        for (StatementExecuteUnit each : statementExecuteUnits) {
            result.add(this.execute0(each, isTrunkThread, shardingExecuteDataMap));
        }
        return result;
    }

    private T execute0(StatementExecuteUnit statementExecuteUnit, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) throws SQLException {
        ExecutorExceptionHandler.setExceptionThrown(this.isExceptionThrown);
        DataSourceMetaData dataSourceMetaData = this.getDataSourceMetaData(statementExecuteUnit.getStatement().getConnection().getMetaData());
        SPISQLExecutionHook sqlExecutionHook = new SPISQLExecutionHook();
        try {
            RouteUnit routeUnit = statementExecuteUnit.getRouteUnit();
            sqlExecutionHook.start(routeUnit.getDataSourceName(), routeUnit.getSqlUnit().getSql(), routeUnit.getSqlUnit().getParameters(), dataSourceMetaData, isTrunkThread, shardingExecuteDataMap);
            T result = this.executeSQL(routeUnit.getSqlUnit().getSql(), statementExecuteUnit.getStatement(), statementExecuteUnit.getConnectionMode());
            sqlExecutionHook.finishSuccess();
            return result;
        }
        catch (SQLException ex) {
            sqlExecutionHook.finishFailure(ex);
            ExecutorExceptionHandler.handleException(ex);
            return null;
        }
    }

    private DataSourceMetaData getDataSourceMetaData(DatabaseMetaData metaData) throws SQLException {
        String url = metaData.getURL();
        if (CACHED_DATASOURCE_METADATA.containsKey(url)) {
            return CACHED_DATASOURCE_METADATA.get(url);
        }
        DataSourceMetaData result = this.databaseType.getDataSourceMetaData(url, metaData.getUserName());
        CACHED_DATASOURCE_METADATA.put(url, result);
        return result;
    }

    protected abstract T executeSQL(String var1, Statement var2, ConnectionMode var3) throws SQLException;

    @ConstructorProperties(value={"databaseType", "isExceptionThrown"})
    public SQLExecuteCallback(DatabaseType databaseType, boolean isExceptionThrown) {
        this.databaseType = databaseType;
        this.isExceptionThrown = isExceptionThrown;
    }
}

