/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.execute.metadata;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.core.execute.engine.ShardingExecuteEngine;
import org.apache.shardingsphere.core.execute.engine.ShardingExecuteGroup;
import org.apache.shardingsphere.core.execute.engine.ShardingGroupExecuteCallback;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataConnectionManager;
import org.apache.shardingsphere.core.metadata.column.ColumnMetaData;
import org.apache.shardingsphere.core.metadata.column.EncryptColumnMetaData;
import org.apache.shardingsphere.core.metadata.column.ShardingGeneratedKeyColumnMetaData;
import org.apache.shardingsphere.core.metadata.datasource.DataSourceMetas;
import org.apache.shardingsphere.core.metadata.table.TableMetaData;
import org.apache.shardingsphere.core.rule.DataNode;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.spi.database.DataSourceMetaData;

public final class TableMetaDataLoader {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String INDEX_NAME = "INDEX_NAME";
    private final DataSourceMetas dataSourceMetas;
    private final ShardingExecuteEngine executeEngine;
    private final TableMetaDataConnectionManager connectionManager;
    private final int maxConnectionsSizePerQuery;
    private final boolean isCheckingMetaData;

    public TableMetaData load(String logicTableName, ShardingRule shardingRule) throws SQLException {
        List<TableMetaData> actualTableMetaDataList = this.load(this.getDataNodeGroups(shardingRule.getTableRule(logicTableName)), shardingRule, logicTableName);
        this.checkUniformed(logicTableName, actualTableMetaDataList);
        return actualTableMetaDataList.iterator().next();
    }

    private List<TableMetaData> load(Map<String, List<DataNode>> dataNodeGroups, final ShardingRule shardingRule, final String logicTableName) throws SQLException {
        final String generateKeyColumnName = (String)shardingRule.findGenerateKeyColumnName(logicTableName).orNull();
        return this.executeEngine.groupExecute(this.getDataNodeExecuteGroups(dataNodeGroups), new ShardingGroupExecuteCallback<DataNode, TableMetaData>(){

            @Override
            public Collection<TableMetaData> execute(Collection<DataNode> dataNodes, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) throws SQLException {
                String masterDataSourceName = shardingRule.getShardingDataSourceNames().getRawMasterDataSourceName(dataNodes.iterator().next().getDataSourceName());
                DataSourceMetaData dataSourceMetaData = TableMetaDataLoader.this.dataSourceMetas.getDataSourceMetaData(masterDataSourceName);
                return TableMetaDataLoader.this.load(masterDataSourceName, dataSourceMetaData, logicTableName, dataNodes, generateKeyColumnName, shardingRule.getEncryptRule());
            }
        });
    }

    private Collection<TableMetaData> load(String dataSourceName, DataSourceMetaData dataSourceMetaData, String logicTableName, Collection<DataNode> dataNodes, String generateKeyColumnName, EncryptRule encryptRule) throws SQLException {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        try (Connection connection = this.connectionManager.getConnection(dataSourceName);){
            for (DataNode each : dataNodes) {
                result.add(this.createTableMetaData(connection, dataSourceMetaData, logicTableName, each.getTableName(), generateKeyColumnName, encryptRule));
            }
        }
        return result;
    }

    private Map<String, List<DataNode>> getDataNodeGroups(TableRule tableRule) {
        return this.isCheckingMetaData ? tableRule.getDataNodeGroups() : this.getFirstDataNodeWithGroups(tableRule);
    }

    private Map<String, List<DataNode>> getFirstDataNodeWithGroups(TableRule tableRule) {
        DataNode firstDataNode = (DataNode)tableRule.getActualDataNodes().iterator().next();
        return Collections.singletonMap(firstDataNode.getDataSourceName(), Collections.singletonList(firstDataNode));
    }

    private Collection<ShardingExecuteGroup<DataNode>> getDataNodeExecuteGroups(Map<String, List<DataNode>> dataNodeGroups) {
        LinkedList<ShardingExecuteGroup<DataNode>> result = new LinkedList<ShardingExecuteGroup<DataNode>>();
        for (Map.Entry<String, List<DataNode>> entry : dataNodeGroups.entrySet()) {
            result.addAll(this.getDataNodeExecuteGroups(entry.getValue()));
        }
        return result;
    }

    private Collection<ShardingExecuteGroup<DataNode>> getDataNodeExecuteGroups(List<DataNode> dataNodes) {
        LinkedList<ShardingExecuteGroup<DataNode>> result = new LinkedList<ShardingExecuteGroup<DataNode>>();
        for (List each : Lists.partition(dataNodes, (int)Math.max(dataNodes.size() / this.maxConnectionsSizePerQuery, 1))) {
            result.add(new ShardingExecuteGroup(each));
        }
        return result;
    }

    private TableMetaData createTableMetaData(Connection connection, DataSourceMetaData dataSourceMetaData, String logicTableName, String actualTableName, String generateKeyColumnName, EncryptRule encryptRule) throws SQLException {
        String catalog = dataSourceMetaData.getCatalog();
        String schema = dataSourceMetaData.getSchema();
        if (this.isTableExist(connection, catalog, actualTableName)) {
            return new TableMetaData(this.getColumnMetaDataList(connection, catalog, logicTableName, actualTableName, generateKeyColumnName, encryptRule), this.getLogicIndexes(connection, catalog, schema, actualTableName));
        }
        return new TableMetaData(Collections.emptyList(), Collections.emptySet());
    }

    private boolean isTableExist(Connection connection, String catalog, String actualTableName) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(catalog, null, actualTableName, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private Collection<ColumnMetaData> getColumnMetaDataList(Connection connection, String catalog, String logicTableName, String actualTableName, String generateKeyColumnName, EncryptRule encryptRule) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = this.getPrimaryKeys(connection, catalog, actualTableName);
        Collection derivedColumns = encryptRule.getAssistedQueryAndPlainColumns(logicTableName);
        try (ResultSet resultSet = connection.getMetaData().getColumns(catalog, null, actualTableName, "%");){
            while (resultSet.next()) {
                boolean isPrimaryKey;
                String columnType;
                String columnName = resultSet.getString(COLUMN_NAME);
                Optional<ColumnMetaData> columnMetaData = this.getColumnMetaData(logicTableName, columnName, columnType = resultSet.getString(TYPE_NAME), isPrimaryKey = primaryKeys.contains(columnName), generateKeyColumnName, encryptRule, derivedColumns);
                if (!columnMetaData.isPresent()) continue;
                result.add((ColumnMetaData)columnMetaData.get());
            }
        }
        return result;
    }

    private Collection<String> getPrimaryKeys(Connection connection, String catalog, String actualTableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(catalog, null, actualTableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString(COLUMN_NAME));
            }
        }
        return result;
    }

    private Optional<ColumnMetaData> getColumnMetaData(String logicTableName, String columnName, String columnType, boolean isPrimaryKey, String generateKeyColumnName, EncryptRule encryptRule, Collection<String> derivedColumns) {
        if (derivedColumns.contains(columnName)) {
            return Optional.absent();
        }
        if (encryptRule.isCipherColumn(logicTableName, columnName)) {
            String logicColumnName = encryptRule.getLogicColumnOfCipher(logicTableName, columnName);
            String plainColumnName = (String)encryptRule.findPlainColumn(logicTableName, logicColumnName).orNull();
            String assistedQueryColumnName = (String)encryptRule.findAssistedQueryColumn(logicTableName, logicColumnName).orNull();
            return Optional.of((Object)new EncryptColumnMetaData(logicColumnName, columnType, isPrimaryKey, columnName, plainColumnName, assistedQueryColumnName));
        }
        if (columnName.equalsIgnoreCase(generateKeyColumnName)) {
            return Optional.of((Object)new ShardingGeneratedKeyColumnMetaData(columnName, columnType, isPrimaryKey));
        }
        return Optional.of((Object)new ColumnMetaData(columnName, columnType, isPrimaryKey));
    }

    private Collection<String> getLogicIndexes(Connection connection, String catalog, String schema, String actualTableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(catalog, schema, actualTableName, false, false);){
            while (resultSet.next()) {
                Optional<String> logicIndex = this.getLogicIndex(resultSet.getString(INDEX_NAME), actualTableName);
                if (!logicIndex.isPresent()) continue;
                result.add((String)logicIndex.get());
            }
        }
        return result;
    }

    private Optional<String> getLogicIndex(String actualIndexName, String actualTableName) {
        if (null == actualIndexName) {
            return Optional.absent();
        }
        String indexNameSuffix = "_" + actualTableName;
        return actualIndexName.contains(indexNameSuffix) ? Optional.of((Object)actualIndexName.replace(indexNameSuffix, "")) : Optional.absent();
    }

    private void checkUniformed(String logicTableName, List<TableMetaData> actualTableMetaDataList) {
        if (!this.isCheckingMetaData) {
            return;
        }
        TableMetaData sample = actualTableMetaDataList.iterator().next();
        for (TableMetaData each : actualTableMetaDataList) {
            if (sample.equals((Object)each)) continue;
            throw new ShardingException("Cannot get uniformed table structure for `%s`. The different meta data of actual tables are as follows:\n%s\n%s.", new Object[]{logicTableName, sample, each});
        }
    }

    @ConstructorProperties(value={"dataSourceMetas", "executeEngine", "connectionManager", "maxConnectionsSizePerQuery", "isCheckingMetaData"})
    public TableMetaDataLoader(DataSourceMetas dataSourceMetas, ShardingExecuteEngine executeEngine, TableMetaDataConnectionManager connectionManager, int maxConnectionsSizePerQuery, boolean isCheckingMetaData) {
        this.dataSourceMetas = dataSourceMetas;
        this.executeEngine = executeEngine;
        this.connectionManager = connectionManager;
        this.maxConnectionsSizePerQuery = maxConnectionsSizePerQuery;
        this.isCheckingMetaData = isCheckingMetaData;
    }
}

