/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.execute.metadata;

import com.google.common.base.Optional;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.shardingsphere.core.execute.engine.ShardingExecuteEngine;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataConnectionManager;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataLoader;
import org.apache.shardingsphere.core.metadata.datasource.DataSourceMetas;
import org.apache.shardingsphere.core.metadata.table.TableMetaData;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.spi.database.DataSourceMetaData;

public final class TableMetaDataInitializer {
    private final DataSourceMetas dataSourceMetas;
    private final TableMetaDataConnectionManager connectionManager;
    private final TableMetaDataLoader tableMetaDataLoader;

    public TableMetaDataInitializer(DataSourceMetas dataSourceMetas, ShardingExecuteEngine executeEngine, TableMetaDataConnectionManager connectionManager, int maxConnectionsSizePerQuery, boolean isCheckingMetaData) {
        this.dataSourceMetas = dataSourceMetas;
        this.connectionManager = connectionManager;
        this.tableMetaDataLoader = new TableMetaDataLoader(dataSourceMetas, executeEngine, connectionManager, maxConnectionsSizePerQuery, isCheckingMetaData);
    }

    public TableMetaData load(String logicTableName, ShardingRule shardingRule) throws SQLException {
        return this.tableMetaDataLoader.load(logicTableName, shardingRule);
    }

    public Map<String, TableMetaData> load(ShardingRule shardingRule) throws SQLException {
        HashMap<String, TableMetaData> result = new HashMap<String, TableMetaData>();
        result.putAll(this.loadShardingTables(shardingRule));
        result.putAll(this.loadDefaultTables(shardingRule));
        return result;
    }

    private Map<String, TableMetaData> loadShardingTables(ShardingRule shardingRule) throws SQLException {
        HashMap<String, TableMetaData> result = new HashMap<String, TableMetaData>(shardingRule.getTableRules().size(), 1.0f);
        for (TableRule each : shardingRule.getTableRules()) {
            result.put(each.getLogicTable(), this.tableMetaDataLoader.load(each.getLogicTable(), shardingRule));
        }
        return result;
    }

    private Map<String, TableMetaData> loadDefaultTables(ShardingRule shardingRule) throws SQLException {
        HashMap<String, TableMetaData> result = new HashMap<String, TableMetaData>(shardingRule.getTableRules().size(), 1.0f);
        Optional actualDefaultDataSourceName = shardingRule.findActualDefaultDataSourceName();
        if (actualDefaultDataSourceName.isPresent()) {
            for (String each : this.getAllTableNames((String)actualDefaultDataSourceName.get())) {
                result.put(each, this.tableMetaDataLoader.load(each, shardingRule));
            }
        }
        return result;
    }

    private Collection<String> getAllTableNames(String dataSourceName) throws SQLException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        DataSourceMetaData dataSourceMetaData = this.dataSourceMetas.getDataSourceMetaData(dataSourceName);
        String catalog = null == dataSourceMetaData ? null : dataSourceMetaData.getCatalog();
        String schemaName = null == dataSourceMetaData ? null : dataSourceMetaData.getSchema();
        try (Connection connection = this.connectionManager.getConnection(dataSourceName);
             ResultSet resultSet = connection.getMetaData().getTables(catalog, schemaName, null, new String[]{"TABLE"});){
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                if (tableName.contains("$") || tableName.contains("/")) continue;
                result.add(tableName);
            }
        }
        return result;
    }
}

