/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.execute.engine;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.core.execute.engine.ShardingThreadFactoryBuilder;

public final class ShardingExecutorService {
    private static final String DEFAULT_NAME_FORMAT = "%d";
    private static final ExecutorService SHUTDOWN_EXECUTOR = Executors.newSingleThreadExecutor(ShardingThreadFactoryBuilder.build("Executor-Engine-Closer"));
    private ListeningExecutorService executorService;

    public ShardingExecutorService(int executorSize) {
        this(executorSize, DEFAULT_NAME_FORMAT);
    }

    public ShardingExecutorService(int executorSize, String nameFormat) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)this.getExecutorService(executorSize, nameFormat));
        MoreExecutors.addDelayedShutdownHook((ExecutorService)this.executorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    private ExecutorService getExecutorService(int executorSize, String nameFormat) {
        ThreadFactory shardingThreadFactory = ShardingThreadFactoryBuilder.build(nameFormat);
        return 0 == executorSize ? Executors.newCachedThreadPool(shardingThreadFactory) : Executors.newFixedThreadPool(executorSize, shardingThreadFactory);
    }

    public void close() {
        SHUTDOWN_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ShardingExecutorService.this.executorService.shutdown();
                    while (!ShardingExecutorService.this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        ShardingExecutorService.this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    public ListeningExecutorService getExecutorService() {
        return this.executorService;
    }
}

