/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.execute.engine;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.core.execute.engine.ShardingExecuteDataMap;
import org.apache.shardingsphere.core.execute.engine.ShardingExecuteGroup;
import org.apache.shardingsphere.core.execute.engine.ShardingExecutorService;
import org.apache.shardingsphere.core.execute.engine.ShardingGroupExecuteCallback;

public final class ShardingExecuteEngine
implements AutoCloseable {
    private final ShardingExecutorService shardingExecutorService;
    private ListeningExecutorService executorService;

    public ShardingExecuteEngine(int executorSize) {
        this.shardingExecutorService = new ShardingExecutorService(executorSize);
        this.executorService = this.shardingExecutorService.getExecutorService();
    }

    public <I, O> List<O> groupExecute(Collection<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> callback) throws SQLException {
        return this.groupExecute(inputGroups, null, callback, false);
    }

    public <I, O> List<O> groupExecute(Collection<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> firstCallback, ShardingGroupExecuteCallback<I, O> callback, boolean serial) throws SQLException {
        if (inputGroups.isEmpty()) {
            return Collections.emptyList();
        }
        return serial ? this.serialExecute(inputGroups, firstCallback, callback) : this.parallelExecute(inputGroups, firstCallback, callback);
    }

    private <I, O> List<O> serialExecute(Collection<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> firstCallback, ShardingGroupExecuteCallback<I, O> callback) throws SQLException {
        Iterator<ShardingExecuteGroup<I>> inputGroupsIterator = inputGroups.iterator();
        ShardingExecuteGroup<I> firstInputs = inputGroupsIterator.next();
        LinkedList<O> result = new LinkedList<O>(this.syncGroupExecute(firstInputs, null == firstCallback ? callback : firstCallback));
        for (ShardingExecuteGroup each : Lists.newArrayList(inputGroupsIterator)) {
            result.addAll(this.syncGroupExecute(each, callback));
        }
        return result;
    }

    private <I, O> List<O> parallelExecute(Collection<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> firstCallback, ShardingGroupExecuteCallback<I, O> callback) throws SQLException {
        Iterator<ShardingExecuteGroup<I>> inputGroupsIterator = inputGroups.iterator();
        ShardingExecuteGroup<I> firstInputs = inputGroupsIterator.next();
        Collection<ListenableFuture<Collection<O>>> restResultFutures = this.asyncGroupExecute(Lists.newArrayList(inputGroupsIterator), callback);
        return this.getGroupResults(this.syncGroupExecute(firstInputs, null == firstCallback ? callback : firstCallback), restResultFutures);
    }

    private <I, O> Collection<ListenableFuture<Collection<O>>> asyncGroupExecute(List<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> callback) {
        LinkedList<ListenableFuture<Collection<O>>> result = new LinkedList<ListenableFuture<Collection<O>>>();
        for (ShardingExecuteGroup<I> each : inputGroups) {
            result.add(this.asyncGroupExecute(each, callback));
        }
        return result;
    }

    private <I, O> ListenableFuture<Collection<O>> asyncGroupExecute(final ShardingExecuteGroup<I> inputGroup, final ShardingGroupExecuteCallback<I, O> callback) {
        final Map<String, Object> dataMap = ShardingExecuteDataMap.getDataMap();
        return this.executorService.submit(new Callable<Collection<O>>(){

            @Override
            public Collection<O> call() throws SQLException {
                return callback.execute(inputGroup.getInputs(), false, dataMap);
            }
        });
    }

    private <I, O> Collection<O> syncGroupExecute(ShardingExecuteGroup<I> executeGroup, ShardingGroupExecuteCallback<I, O> callback) throws SQLException {
        return callback.execute(executeGroup.getInputs(), true, ShardingExecuteDataMap.getDataMap());
    }

    private <O> List<O> getGroupResults(Collection<O> firstResults, Collection<ListenableFuture<Collection<O>>> restFutures) throws SQLException {
        LinkedList<O> result = new LinkedList<O>(firstResults);
        for (ListenableFuture<Collection<O>> each : restFutures) {
            try {
                result.addAll((Collection)each.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                return this.throwException(ex);
            }
        }
        return result;
    }

    private <O> List<O> throwException(Exception exception) throws SQLException {
        if (exception.getCause() instanceof SQLException) {
            throw (SQLException)exception.getCause();
        }
        throw new ShardingException(exception);
    }

    @Override
    public void close() {
        this.shardingExecutorService.close();
    }
}

