/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.masterslave.route.engine.impl;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.shardingsphere.api.hint.HintManager;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.masterslave.route.engine.impl.MasterVisitedManager;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;

public final class MasterSlaveDataSourceRouter {
    private final MasterSlaveRule masterSlaveRule;

    public String route(SQLStatement sqlStatement) {
        if (this.isMasterRoute(sqlStatement)) {
            MasterVisitedManager.setMasterVisited();
            return this.masterSlaveRule.getMasterDataSourceName();
        }
        return this.masterSlaveRule.getLoadBalanceAlgorithm().getDataSource(this.masterSlaveRule.getName(), this.masterSlaveRule.getMasterDataSourceName(), new ArrayList(this.masterSlaveRule.getSlaveDataSourceNames()));
    }

    private boolean isMasterRoute(SQLStatement sqlStatement) {
        return this.containsLockSegment(sqlStatement) || !(sqlStatement instanceof SelectStatement) || MasterVisitedManager.isMasterVisited() || HintManager.isMasterRouteOnly();
    }

    private boolean containsLockSegment(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && ((SelectStatement)sqlStatement).getLock().isPresent();
    }

    @Generated
    public MasterSlaveDataSourceRouter(MasterSlaveRule masterSlaveRule) {
        this.masterSlaveRule = masterSlaveRule;
    }
}

