/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.metadata;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.encrypt.metadata.EncryptColumnMetaData;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.sql.parser.binder.metadata.column.ColumnMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.table.TableMetaData;
import org.apache.shardingsphere.underlying.common.metadata.decorator.TableMetaDataDecorator;

public final class EncryptTableMetaDataDecorator
implements TableMetaDataDecorator<EncryptRule> {
    public TableMetaData decorate(TableMetaData tableMetaData, String tableName, EncryptRule encryptRule) {
        return new TableMetaData(this.getEncryptColumnMetaDataList(tableName, tableMetaData.getColumns().values(), encryptRule), tableMetaData.getIndexes().values());
    }

    private Collection<ColumnMetaData> getEncryptColumnMetaDataList(String tableName, Collection<ColumnMetaData> originalColumnMetaDataList, EncryptRule encryptRule) {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> derivedColumns = encryptRule.getAssistedQueryAndPlainColumns(tableName);
        for (ColumnMetaData each : originalColumnMetaDataList) {
            if (derivedColumns.contains(each.getName())) continue;
            result.add(this.getEncryptColumnMetaData(tableName, each, encryptRule));
        }
        return result;
    }

    private ColumnMetaData getEncryptColumnMetaData(String tableName, ColumnMetaData originalColumnMetaData, EncryptRule encryptRule) {
        if (!encryptRule.isCipherColumn(tableName, originalColumnMetaData.getName())) {
            return originalColumnMetaData;
        }
        String logicColumnName = encryptRule.getLogicColumnOfCipher(tableName, originalColumnMetaData.getName());
        String plainColumnName = encryptRule.findPlainColumn(tableName, logicColumnName).orElse(null);
        String assistedQueryColumnName = encryptRule.findAssistedQueryColumn(tableName, logicColumnName).orElse(null);
        return new EncryptColumnMetaData(logicColumnName, originalColumnMetaData.getDataType(), originalColumnMetaData.getDataTypeName(), originalColumnMetaData.isPrimaryKey(), originalColumnMetaData.getName(), plainColumnName, assistedQueryColumnName);
    }
}

