/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.sink;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.sink.SinkCommonOptions;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.connector.TableSink;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSinkFactoryContext;
import org.apache.seatunnel.connectors.seatunnel.redis.config.RedisConfig;
import org.apache.seatunnel.connectors.seatunnel.redis.sink.RedisSink;

@AutoService(value={Factory.class})
public class RedisSinkFactory
implements TableSinkFactory {
    public String factoryIdentifier() {
        return "Redis";
    }

    public TableSink createSink(TableSinkFactoryContext context) {
        CatalogTable catalogTable = context.getCatalogTable();
        return () -> new RedisSink(context.getOptions(), catalogTable);
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{RedisConfig.HOST, RedisConfig.PORT, RedisConfig.KEY, RedisConfig.DATA_TYPE}).optional(new Option[]{RedisConfig.MODE, RedisConfig.AUTH, RedisConfig.USER, RedisConfig.KEY_PATTERN, RedisConfig.FORMAT, RedisConfig.EXPIRE, RedisConfig.SUPPORT_CUSTOM_KEY, RedisConfig.VALUE_FIELD, RedisConfig.HASH_KEY_FIELD, RedisConfig.HASH_VALUE_FIELD, SinkCommonOptions.MULTI_TABLE_SINK_REPLICA}).conditional(RedisConfig.MODE, (Object)RedisConfig.RedisMode.CLUSTER, new Option[]{RedisConfig.NODES}).build();
    }
}

