/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.redis.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.seatunnel.common.utils.JsonUtils;
import redis.clients.jedis.Jedis;

public enum RedisDataType {
    KEY{

        @Override
        public void set(Jedis jedis, String key, String value, long expire) {
            jedis.set(key, value);
            RedisDataType.expire(jedis, key, expire);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            return Collections.singletonList(jedis.get(key));
        }

        @Override
        public void del(Jedis jedis, String key, String value) {
            jedis.del(key);
        }
    }
    ,
    STRING{

        @Override
        public void set(Jedis jedis, String key, String value, long expire) {
            jedis.set(key, value);
            RedisDataType.expire(jedis, key, expire);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            return Collections.singletonList(jedis.get(key));
        }

        @Override
        public void del(Jedis jedis, String key, String value) {
            jedis.del(key);
        }
    }
    ,
    HASH{

        @Override
        public void set(Jedis jedis, String key, String value, long expire) {
            Map fieldsMap = JsonUtils.toMap((String)value);
            jedis.hset(key, fieldsMap);
            RedisDataType.expire(jedis, key, expire);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            Map<String, String> kvMap = jedis.hgetAll(key);
            return Collections.singletonList(JsonUtils.toJsonString(kvMap));
        }

        @Override
        public void del(Jedis jedis, String key, String value) {
            Map fieldsMap = JsonUtils.toMap((String)value);
            fieldsMap.forEach((k, v) -> jedis.hdel(key, (String)k));
        }
    }
    ,
    LIST{

        @Override
        public void set(Jedis jedis, String key, String value, long expire) {
            jedis.lpush(key, value);
            RedisDataType.expire(jedis, key, expire);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            return jedis.lrange(key, 0L, -1L);
        }

        @Override
        public void del(Jedis jedis, String key, String value) {
            jedis.lrem(key, 1L, value);
        }
    }
    ,
    SET{

        @Override
        public void set(Jedis jedis, String key, String value, long expire) {
            jedis.sadd(key, value);
            RedisDataType.expire(jedis, key, expire);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            Set<String> members = jedis.smembers(key);
            return new ArrayList<String>(members);
        }

        @Override
        public void del(Jedis jedis, String key, String value) {
            jedis.srem(key, value);
        }
    }
    ,
    ZSET{

        @Override
        public void set(Jedis jedis, String key, String value, long expire) {
            jedis.zadd(key, 1.0, value);
            RedisDataType.expire(jedis, key, expire);
        }

        @Override
        public List<String> get(Jedis jedis, String key) {
            return jedis.zrange(key, 0L, -1L);
        }

        @Override
        public void del(Jedis jedis, String key, String value) {
            jedis.zrem(key, value);
        }
    };


    public List<String> get(Jedis jedis, String key) {
        return Collections.emptyList();
    }

    private static void expire(Jedis jedis, String key, long expire) {
        if (expire > 0L) {
            jedis.expire(key, expire);
        }
    }

    public void set(Jedis jedis, String key, String value, long expire) {
    }

    public void del(Jedis jedis, String key, String value) {
    }
}

