/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Table;
import org.apache.omid.transaction.AbstractTransaction;
import org.apache.omid.transaction.AbstractTransactionManager;
import org.apache.omid.transaction.HBaseCellId;
import org.apache.omid.transaction.TTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTransaction
extends AbstractTransaction<HBaseCellId> {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTransaction.class);
    static final int MAX_DELETE_BATCH_SIZE = 1000;

    public HBaseTransaction(long transactionId, long epoch, Set<HBaseCellId> writeSet, Set<HBaseCellId> conflictFreeWriteSet, AbstractTransactionManager tm, boolean isLowLatency) {
        super(transactionId, epoch, writeSet, conflictFreeWriteSet, tm, isLowLatency);
    }

    public HBaseTransaction(long transactionId, long epoch, Set<HBaseCellId> writeSet, Set<HBaseCellId> conflictFreeWriteSet, AbstractTransactionManager tm, long readTimestamp, long writeTimestamp, boolean isLowLatency) {
        super(transactionId, epoch, writeSet, conflictFreeWriteSet, tm, readTimestamp, writeTimestamp, isLowLatency);
    }

    public HBaseTransaction(long transactionId, long readTimestamp, AbstractTransaction.VisibilityLevel visibilityLevel, long epoch, Set<HBaseCellId> writeSet, Set<HBaseCellId> conflictFreeWriteSet, AbstractTransactionManager tm, boolean isLowLatency) {
        super(transactionId, readTimestamp, visibilityLevel, epoch, writeSet, conflictFreeWriteSet, tm, isLowLatency);
    }

    private void flushMutations(Table table, List<Mutation> mutations) throws IOException, InterruptedException {
        table.batch(mutations, new Object[mutations.size()]);
    }

    private void deleteCell(HBaseCellId cell, Map<Table, List<Mutation>> mutations) throws IOException, InterruptedException {
        Delete delete = new Delete(cell.getRow());
        delete.addColumn(cell.getFamily(), cell.getQualifier(), cell.getTimestamp());
        Table table = cell.getTable().getHTable();
        List<Mutation> tableMutations = mutations.get(table);
        if (tableMutations == null) {
            ArrayList<Delete> newList = new ArrayList<Delete>();
            newList.add(delete);
            mutations.put(table, newList);
        } else {
            tableMutations.add((Mutation)delete);
            if (tableMutations.size() > 1000) {
                this.flushMutations(table, tableMutations);
                mutations.remove(table);
            }
        }
    }

    public void cleanup() {
        HashMap<Table, List<Mutation>> mutations = new HashMap<Table, List<Mutation>>();
        try {
            for (HBaseCellId hBaseCellId : this.getWriteSet()) {
                this.deleteCell(hBaseCellId, mutations);
            }
            for (HBaseCellId hBaseCellId : this.getConflictFreeWriteSet()) {
                this.deleteCell(hBaseCellId, mutations);
            }
            for (Map.Entry entry : mutations.entrySet()) {
                this.flushMutations((Table)entry.getKey(), (List)entry.getValue());
            }
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("Failed cleanup for Tx {}. This issue has been ignored", (Object)this.getTransactionId(), (Object)e);
        }
    }

    public void flushTables() throws IOException {
        for (TTable writtenTable : this.getWrittenTables()) {
            writtenTable.flushCommits();
        }
    }

    private Set<TTable> getWrittenTables() {
        HashSet writeSet = (HashSet)this.getWriteSet();
        HashSet<TTable> tables = new HashSet<TTable>();
        for (HBaseCellId cell : writeSet) {
            tables.add(cell.getTable());
        }
        writeSet = (HashSet)this.getConflictFreeWriteSet();
        for (HBaseCellId cell : writeSet) {
            tables.add(cell.getTable());
        }
        return tables;
    }
}

