/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.transaction;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.omid.YAMLUtils;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.tools.hbase.SecureHBaseConfig;
import org.apache.omid.tso.client.OmidClientConfiguration;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;

public class HBaseOmidClientConfiguration
extends SecureHBaseConfig {
    private static final String DEFAULT_CONFIG_FILE_NAME = "default-hbase-omid-client-config.yml";
    private static final String CONFIG_FILE_NAME = "hbase-omid-client-config.yml";
    private Configuration hbaseConfiguration = HBaseConfiguration.create();
    private String commitTableName;
    @Inject
    private OmidClientConfiguration omidClientConfiguration;
    private MetricsRegistry metrics;

    public static HBaseOmidClientConfiguration loadFromString(String yamlContent) {
        return new HBaseOmidClientConfiguration(new YAMLUtils().loadStringAsMap(yamlContent));
    }

    public HBaseOmidClientConfiguration() {
        this(CONFIG_FILE_NAME);
    }

    public <K, V> HBaseOmidClientConfiguration(Map<String, ? extends Object> properties) {
        try {
            BeanUtils.populate((Object)((Object)this), properties);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    HBaseOmidClientConfiguration(String configFileName) {
        new YAMLUtils().loadSettings(configFileName, DEFAULT_CONFIG_FILE_NAME, (Object)this);
    }

    public Configuration getHBaseConfiguration() {
        return this.hbaseConfiguration;
    }

    public void setHBaseConfiguration(Configuration hbaseConfiguration) {
        this.hbaseConfiguration = hbaseConfiguration;
    }

    public OmidClientConfiguration.PostCommitMode getPostCommitMode() {
        return this.omidClientConfiguration.getPostCommitMode();
    }

    public void setPostCommitMode(OmidClientConfiguration.PostCommitMode postCommitMode) {
        this.omidClientConfiguration.setPostCommitMode(postCommitMode);
    }

    public OmidClientConfiguration.ConflictDetectionLevel getConflictAnalysisLevel() {
        return this.omidClientConfiguration.getConflictAnalysisLevel();
    }

    public void setConflictAnalysisLevel(OmidClientConfiguration.ConflictDetectionLevel conflictAnalysisLevel) {
        this.omidClientConfiguration.setConflictAnalysisLevel(conflictAnalysisLevel);
    }

    public String getCommitTableName() {
        return this.commitTableName;
    }

    @Inject(optional=true)
    @Named(value="omid.client.hbase.commitTableName")
    public void setCommitTableName(String commitTableName) {
        this.commitTableName = commitTableName;
    }

    public OmidClientConfiguration getOmidClientConfiguration() {
        return this.omidClientConfiguration;
    }

    public void setOmidClientConfiguration(OmidClientConfiguration omidClientConfiguration) {
        this.omidClientConfiguration = omidClientConfiguration;
    }

    public MetricsRegistry getMetrics() {
        return this.metrics;
    }

    @Inject(optional=true)
    @Named(value="omid.client.hbase.metrics")
    public void setMetrics(MetricsRegistry metrics) {
        this.metrics = metrics;
    }

    public OmidClientConfiguration.ConnType getConnectionType() {
        return this.omidClientConfiguration.getConnectionType();
    }

    public void setReconnectionDelayInSecs(int reconnectionDelayInSecs) {
        this.omidClientConfiguration.setReconnectionDelayInSecs(reconnectionDelayInSecs);
    }

    public void setExecutorThreads(int executorThreads) {
        this.omidClientConfiguration.setExecutorThreads(executorThreads);
    }

    public int getRequestTimeoutInMs() {
        return this.omidClientConfiguration.getRequestTimeoutInMs();
    }

    public void setConnectionString(String connectionString) {
        this.omidClientConfiguration.setConnectionString(connectionString);
    }

    public void setRequestTimeoutInMs(int requestTimeoutInMs) {
        this.omidClientConfiguration.setRequestTimeoutInMs(requestTimeoutInMs);
    }

    public void setZkConnectionTimeoutInSecs(int zkConnectionTimeoutInSecs) {
        this.omidClientConfiguration.setZkConnectionTimeoutInSecs(zkConnectionTimeoutInSecs);
    }

    public void setConnectionType(OmidClientConfiguration.ConnType connectionType) {
        this.omidClientConfiguration.setConnectionType(connectionType);
    }

    public void setRequestMaxRetries(int requestMaxRetries) {
        this.omidClientConfiguration.setRequestMaxRetries(requestMaxRetries);
    }

    public int getZkConnectionTimeoutInSecs() {
        return this.omidClientConfiguration.getZkConnectionTimeoutInSecs();
    }

    public void setRetryDelayInMs(int retryDelayInMs) {
        this.omidClientConfiguration.setRetryDelayInMs(retryDelayInMs);
    }

    public int getExecutorThreads() {
        return this.omidClientConfiguration.getExecutorThreads();
    }

    public int getRetryDelayInMs() {
        return this.omidClientConfiguration.getRetryDelayInMs();
    }

    public String getConnectionString() {
        return this.omidClientConfiguration.getConnectionString();
    }

    public int getRequestMaxRetries() {
        return this.omidClientConfiguration.getRequestMaxRetries();
    }

    public int getReconnectionDelayInSecs() {
        return this.omidClientConfiguration.getReconnectionDelayInSecs();
    }
}

