/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.fixedwidth;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import org.apache.metamodel.fixedwidth.InconsistentValueWidthException;

final class FixedWidthReader
implements Closeable {
    private final BufferedReader _reader;
    private final int _fixedValueWidth;
    private final int[] _valueWidths;
    private final boolean _failOnInconsistentLineWidth;
    private final int expectedLineLength;
    private final boolean constantWidth;
    private volatile int _rowNumber;

    public FixedWidthReader(Reader reader, int fixedValueWidth, boolean failOnInconsistentLineWidth) {
        this(new BufferedReader(reader), fixedValueWidth, failOnInconsistentLineWidth);
    }

    public FixedWidthReader(BufferedReader reader, int fixedValueWidth, boolean failOnInconsistentLineWidth) {
        this._reader = reader;
        this._fixedValueWidth = fixedValueWidth;
        this._failOnInconsistentLineWidth = failOnInconsistentLineWidth;
        this._rowNumber = 0;
        this._valueWidths = null;
        this.constantWidth = true;
        this.expectedLineLength = -1;
    }

    public FixedWidthReader(Reader reader, int[] valueWidths, boolean failOnInconsistentLineWidth) {
        this(new BufferedReader(reader), valueWidths, failOnInconsistentLineWidth);
    }

    public FixedWidthReader(BufferedReader reader, int[] valueWidths, boolean failOnInconsistentLineWidth) {
        this._reader = reader;
        this._fixedValueWidth = -1;
        this._valueWidths = valueWidths;
        this._failOnInconsistentLineWidth = failOnInconsistentLineWidth;
        this._rowNumber = 0;
        this.constantWidth = false;
        int expectedLineLength = 0;
        if (this._fixedValueWidth == -1) {
            for (int i = 0; i < this._valueWidths.length; ++i) {
                expectedLineLength += this._valueWidths[i];
            }
        }
        this.expectedLineLength = expectedLineLength;
    }

    public String[] readLine() throws IllegalStateException {
        try {
            ArrayList<String> values = new ArrayList<String>();
            String line = this._reader.readLine();
            if (line == null) {
                return null;
            }
            StringBuilder nextValue = new StringBuilder();
            int valueIndex = 0;
            StringCharacterIterator it = new StringCharacterIterator(line);
            char c = it.first();
            while (c != '\uffff') {
                int valueWidth;
                nextValue.append(c);
                if (this.constantWidth) {
                    valueWidth = this._fixedValueWidth;
                } else {
                    if (valueIndex >= this._valueWidths.length) {
                        if (!this._failOnInconsistentLineWidth) break;
                        String[] result = values.toArray(new String[values.size()]);
                        throw new InconsistentValueWidthException(result, line, this._rowNumber + 1);
                    }
                    valueWidth = this._valueWidths[valueIndex];
                }
                if (nextValue.length() == valueWidth) {
                    values.add(nextValue.toString().trim());
                    nextValue = new StringBuilder();
                    ++valueIndex;
                }
                c = it.next();
            }
            if (nextValue.length() > 0) {
                values.add(nextValue.toString().trim());
            }
            String[] result = values.toArray(new String[values.size()]);
            if (!this._failOnInconsistentLineWidth && !this.constantWidth && result.length != this._valueWidths.length) {
                String[] correctedResult = new String[this._valueWidths.length];
                for (int i = 0; i < result.length && i < this._valueWidths.length; ++i) {
                    correctedResult[i] = result[i];
                }
                result = correctedResult;
            }
            if (this._failOnInconsistentLineWidth) {
                ++this._rowNumber;
                if (this.constantWidth) {
                    if (line.length() % this._fixedValueWidth != 0) {
                        throw new InconsistentValueWidthException(result, line, this._rowNumber);
                    }
                } else {
                    if (result.length != values.size()) {
                        throw new InconsistentValueWidthException(result, line, this._rowNumber);
                    }
                    if (line.length() != this.expectedLineLength) {
                        throw new InconsistentValueWidthException(result, line, this._rowNumber);
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }
}

