/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.excel.ExcelConfiguration;
import org.apache.metamodel.excel.ExcelDataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.schema.naming.CustomColumnNamingStrategy;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.SimpleTableDef;

public class ExcelDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "excel";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        CustomColumnNamingStrategy columnNamingStrategy;
        Resource resource = resourceFactoryRegistry.createResource(properties.getResourceProperties());
        int columnNameLineNumber = this.getInt(properties.getColumnNameLineNumber(), 1);
        Boolean skipEmptyLines = this.getBoolean(properties.isSkipEmptyLines(), true);
        Boolean skipEmptyColumns = this.getBoolean(properties.isSkipEmptyColumns(), false);
        if (properties.getTableDefs() == null) {
            columnNamingStrategy = null;
        } else {
            SimpleTableDef firstTable = properties.getTableDefs()[0];
            String[] columnNames = firstTable.getColumnNames();
            columnNamingStrategy = new CustomColumnNamingStrategy(columnNames);
        }
        ExcelConfiguration configuration = new ExcelConfiguration(columnNameLineNumber, (ColumnNamingStrategy)columnNamingStrategy, skipEmptyLines, skipEmptyColumns);
        return new ExcelDataContext(resource, configuration);
    }
}

