/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.excel;

import java.io.Serializable;
import java.util.List;
import org.apache.metamodel.schema.naming.ColumnNamingStrategies;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.BaseObject;

public final class ExcelConfiguration
extends BaseObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NO_COLUMN_NAME_LINE = 0;
    public static final int DEFAULT_COLUMN_NAME_LINE = 1;
    private final int columnNameLineNumber;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final boolean skipEmptyLines;
    private final boolean skipEmptyColumns;

    public ExcelConfiguration() {
        this(1, true, false);
    }

    public ExcelConfiguration(int columnNameLineNumber, boolean skipEmptyLines, boolean skipEmptyColumns) {
        this(columnNameLineNumber, null, skipEmptyLines, skipEmptyColumns);
    }

    public ExcelConfiguration(int columnNameLineNumber, ColumnNamingStrategy columnNamingStrategy, boolean skipEmptyLines, boolean skipEmptyColumns) {
        this.columnNameLineNumber = columnNameLineNumber;
        this.skipEmptyLines = skipEmptyLines;
        this.skipEmptyColumns = skipEmptyColumns;
        this.columnNamingStrategy = columnNamingStrategy;
    }

    public ColumnNamingStrategy getColumnNamingStrategy() {
        if (this.columnNamingStrategy == null) {
            return ColumnNamingStrategies.defaultStrategy();
        }
        return this.columnNamingStrategy;
    }

    public int getColumnNameLineNumber() {
        return this.columnNameLineNumber;
    }

    public boolean isSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public boolean isSkipEmptyColumns() {
        return this.skipEmptyColumns;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.columnNameLineNumber);
        identifiers.add(this.skipEmptyLines);
        identifiers.add(this.skipEmptyColumns);
    }

    public String toString() {
        return "ExcelConfiguration[columnNameLineNumber=" + this.columnNameLineNumber + ", skipEmptyLines=" + this.skipEmptyLines + ", skipEmptyColumns=" + this.skipEmptyColumns + "]";
    }
}

