/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.common;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.elasticsearch.common.base.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchUtils {
    public static final String FIELD_ID = "_id";
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchUtils.class);

    private static QueryBuilder getFilteredQuery(String prefix, String fieldName) {
        try {
            try {
                Method method = QueryBuilders.class.getDeclaredMethod(prefix + "Query", String.class);
                method.setAccessible(true);
                return QueryBuilders.boolQuery().must((QueryBuilder)method.invoke(null, fieldName));
            }
            catch (NoSuchMethodException e) {
                Class<?> clazz = ElasticSearchUtils.class.getClassLoader().loadClass("org.elasticsearch.index.query.FilterBuilders");
                Method filterBuilderMethod = clazz.getDeclaredMethod(prefix + "Filter", String.class);
                filterBuilderMethod.setAccessible(true);
                Method queryBuildersFilteredQueryMethod = QueryBuilders.class.getDeclaredMethod("filteredQuery", QueryBuilder.class, FilterBuilder.class);
                return (QueryBuilder)queryBuildersFilteredQueryMethod.invoke(null, null, filterBuilderMethod.invoke(null, fieldName));
            }
        }
        catch (Exception e) {
            logger.error("Failed to resolve/invoke filtering method", (Throwable)e);
            throw new IllegalStateException("Failed to resolve filtering method", e);
        }
    }

    public static QueryBuilder getMissingQuery(String fieldName) {
        return ElasticSearchUtils.getFilteredQuery("missing", fieldName);
    }

    public static QueryBuilder getExistsQuery(String fieldName) {
        return ElasticSearchUtils.getFilteredQuery("exists", fieldName);
    }

    public static List<Object> getSourceProperties(MutableTable table) {
        if (table.getColumnByName(FIELD_ID) == null) {
            MutableColumn idColumn = new MutableColumn(FIELD_ID, ColumnType.STRING).setTable((Table)table).setPrimaryKey(true);
            table.addColumn(0, (Column)idColumn);
        }
        ArrayList<Object> sourceProperties = new ArrayList<Object>();
        for (Column column : table.getColumns()) {
            String columnName = column.getName();
            if (FIELD_ID.equals(columnName)) continue;
            sourceProperties.add(columnName);
            String type = ElasticSearchUtils.getType(column);
            if (type == null) {
                sourceProperties.add("store=true");
                continue;
            }
            sourceProperties.add("type=" + type + ",store=true");
        }
        return sourceProperties;
    }

    private static String getType(Column column) {
        String nativeType = column.getNativeType();
        if (!Strings.isNullOrEmpty((String)nativeType)) {
            return nativeType;
        }
        ColumnType type = column.getType();
        if (type == null) {
            throw new IllegalStateException("No column type specified for '" + column.getName() + "' - cannot build ElasticSearch mapping without type.");
        }
        if (type.isLiteral()) {
            return "string";
        }
        if (type == ColumnType.FLOAT) {
            return "float";
        }
        if (type == ColumnType.DOUBLE || type == ColumnType.NUMERIC || type == ColumnType.NUMBER) {
            return "double";
        }
        if (type == ColumnType.SMALLINT) {
            return "short";
        }
        if (type == ColumnType.TINYINT) {
            return "byte";
        }
        if (type == ColumnType.INTEGER) {
            return "integer";
        }
        if (type == ColumnType.DATE || type == ColumnType.TIMESTAMP) {
            return "date";
        }
        if (type == ColumnType.BINARY || type == ColumnType.VARBINARY) {
            return "binary";
        }
        if (type == ColumnType.BOOLEAN || type == ColumnType.BIT) {
            return "boolean";
        }
        if (type == ColumnType.MAP) {
            return "object";
        }
        throw new UnsupportedOperationException("Unsupported column type '" + type.getName() + "' of column '" + column.getName() + "' - cannot translate to an ElasticSearch type.");
    }

    public static QueryBuilder createQueryBuilderForSimpleWhere(List<FilterItem> whereItems, LogicalOperator logicalOperator) {
        if (whereItems.isEmpty()) {
            return QueryBuilders.matchAllQuery();
        }
        ArrayList<QueryBuilder> children = new ArrayList<QueryBuilder>(whereItems.size());
        for (FilterItem item : whereItems) {
            Object itemQueryBuilder;
            if (item.isCompoundFilter()) {
                List<FilterItem> childItems = Arrays.asList(item.getChildItems());
                itemQueryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere(childItems, item.getLogicalOperator());
                if (itemQueryBuilder == null) {
                    return null;
                }
            } else {
                Column column = item.getSelectItem().getColumn();
                if (column == null) {
                    return null;
                }
                String fieldName = column.getName();
                Object operand = item.getOperand();
                OperatorType operator = item.getOperator();
                if (OperatorType.EQUALS_TO.equals(operator)) {
                    itemQueryBuilder = operand == null ? ElasticSearchUtils.getMissingQuery(fieldName) : QueryBuilders.termQuery((String)fieldName, (Object)operand);
                } else if (OperatorType.DIFFERENT_FROM.equals(operator)) {
                    itemQueryBuilder = operand == null ? ElasticSearchUtils.getExistsQuery(fieldName) : QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)fieldName, (Object)operand));
                } else if (OperatorType.IN.equals(operator)) {
                    List operands = CollectionUtils.toList((Object)operand);
                    itemQueryBuilder = QueryBuilders.termsQuery((String)fieldName, (Collection)operands);
                } else {
                    return null;
                }
            }
            children.add((QueryBuilder)itemQueryBuilder);
        }
        if (children.size() == 1) {
            return (QueryBuilder)children.get(0);
        }
        BoolQueryBuilder result = QueryBuilders.boolQuery();
        for (QueryBuilder child : children) {
            switch (logicalOperator) {
                case AND: {
                    result.must(child);
                }
                case OR: {
                    result.should(child);
                }
            }
        }
        return result;
    }

    public static ColumnType getColumnTypeFromElasticSearchType(String metaDataFieldType) {
        ColumnType columnType = metaDataFieldType.startsWith("date") ? ColumnType.DATE : (metaDataFieldType.equals("long") ? ColumnType.BIGINT : (metaDataFieldType.equals("string") ? ColumnType.STRING : (metaDataFieldType.equals("float") ? ColumnType.FLOAT : (metaDataFieldType.equals("boolean") ? ColumnType.BOOLEAN : (metaDataFieldType.equals("double") ? ColumnType.DOUBLE : ColumnType.STRING)))));
        return columnType;
    }
}

