/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.util.Iterator;
import java.util.Map;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.util.CollectionUtils;
import org.ektorp.DbAccessException;

final class CouchDbUtils {
    private static final ObjectReader OBJECT_READER = new ObjectMapper().readerFor(Map.class);

    CouchDbUtils() {
    }

    public static boolean safeHasNext(Iterator<?> rowIterator) {
        try {
            return rowIterator.hasNext();
        }
        catch (DbAccessException e) {
            return false;
        }
    }

    public static Row jsonNodeToMetaModelRow(JsonNode node, DataSetHeader header) {
        Map<String, ?> map = CouchDbUtils.jsonNodeToMap(node);
        int size = header.size();
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            Object value;
            String key = header.getSelectItem(i).getColumn().getName();
            values[i] = value = CollectionUtils.find(map, (String)key);
        }
        DefaultRow finalRow = new DefaultRow(header, values);
        return finalRow;
    }

    public static Map<String, ?> jsonNodeToMap(JsonNode valueNode) {
        if (valueNode == null) {
            return null;
        }
        try {
            return (Map)OBJECT_READER.readValue(valueNode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object jsonNodeToList(JsonNode valueNode) {
        if (valueNode == null) {
            return null;
        }
        try {
            return OBJECT_READER.readValue(valueNode);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

