/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.couchdb.CouchDbDataSet;
import org.apache.metamodel.couchdb.CouchDbDatabaseDocumentSource;
import org.apache.metamodel.couchdb.CouchDbInferentialSchemaBuilder;
import org.apache.metamodel.couchdb.CouchDbSamplingDocumentSource;
import org.apache.metamodel.couchdb.CouchDbSimpleTableDefSchemaBuilder;
import org.apache.metamodel.couchdb.CouchDbUpdateCallback;
import org.apache.metamodel.couchdb.CouchDbUtils;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.builder.DocumentSourceProvider;
import org.apache.metamodel.schema.builder.SchemaBuilder;
import org.apache.metamodel.util.SimpleTableDef;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.StreamingViewResult;
import org.ektorp.ViewQuery;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbInstance;

public class CouchDbDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext,
DocumentSourceProvider {
    public static final String SCHEMA_NAME = "CouchDB";
    public static final int DEFAULT_PORT = 5984;
    public static final String FIELD_ID = "_id";
    public static final String FIELD_REV = "_rev";
    private final CouchDbInstance _couchDbInstance;
    private final SchemaBuilder _schemaBuilder;

    public CouchDbDataContext(StdHttpClient.Builder httpClientBuilder, SimpleTableDef ... tableDefs) {
        this(httpClientBuilder.build(), tableDefs);
    }

    public CouchDbDataContext(StdHttpClient.Builder httpClientBuilder) {
        this(httpClientBuilder.build());
    }

    public CouchDbDataContext(HttpClient httpClient, SimpleTableDef ... tableDefs) {
        this((CouchDbInstance)new StdCouchDbInstance(httpClient), tableDefs);
    }

    public CouchDbDataContext(HttpClient httpClient) {
        this((CouchDbInstance)new StdCouchDbInstance(httpClient));
    }

    public CouchDbDataContext(CouchDbInstance couchDbInstance) {
        this._couchDbInstance = couchDbInstance;
        this._schemaBuilder = new CouchDbInferentialSchemaBuilder();
    }

    public CouchDbDataContext(CouchDbInstance couchDbInstance, String ... databaseNames) {
        this._couchDbInstance = couchDbInstance;
        this._schemaBuilder = new CouchDbInferentialSchemaBuilder(databaseNames);
    }

    public CouchDbDataContext(CouchDbInstance couchDbInstance, SimpleTableDef ... tableDefs) {
        this._couchDbInstance = couchDbInstance;
        this._schemaBuilder = new CouchDbSimpleTableDefSchemaBuilder(tableDefs);
    }

    public CouchDbInstance getCouchDbInstance() {
        return this._couchDbInstance;
    }

    protected Schema getMainSchema() throws MetaModelException {
        this._schemaBuilder.offerSources((DocumentSourceProvider)this);
        return this._schemaBuilder.build();
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this._schemaBuilder.getSchemaName();
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int firstRow, int maxRows) {
        String databaseName = table.getName();
        CouchDbConnector connector = this._couchDbInstance.createConnector(databaseName, false);
        ViewQuery query = new ViewQuery().allDocs().includeDocs(true);
        if (maxRows > 0) {
            query = query.limit(maxRows);
        }
        if (firstRow > 1) {
            int skip = firstRow - 1;
            query = query.skip(skip);
        }
        StreamingViewResult streamingView = connector.queryForStreamingView(query);
        SelectItem[] selectItems = MetaModelHelper.createSelectItems((Column[])columns);
        return new CouchDbDataSet(selectItems, streamingView);
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        return this.materializeMainSchemaTable(table, columns, 1, maxRows);
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        String keyString;
        if (keyValue == null) {
            return null;
        }
        String databaseName = table.getName();
        CouchDbConnector connector = this._couchDbInstance.createConnector(databaseName, false);
        JsonNode node = (JsonNode)connector.find(JsonNode.class, keyString = keyValue.toString());
        if (node == null) {
            return null;
        }
        return CouchDbUtils.jsonNodeToMetaModelRow(node, (DataSetHeader)new SimpleDataSetHeader(selectItems));
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (whereItems.isEmpty()) {
            String databaseName = table.getName();
            CouchDbConnector connector = this._couchDbInstance.createConnector(databaseName, false);
            long docCount = connector.getDbInfo().getDocCount();
            return docCount;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript script) {
        try (CouchDbUpdateCallback callback = new CouchDbUpdateCallback(this);){
            script.run((UpdateCallback)callback);
        }
    }

    public DocumentSource getMixedDocumentSourceForSampling() {
        return new CouchDbSamplingDocumentSource(this._couchDbInstance);
    }

    public DocumentSource getDocumentSourceForTable(String sourceCollectionName) {
        return new CouchDbDatabaseDocumentSource(this._couchDbInstance, sourceCollectionName, -1);
    }
}

