/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.unedit;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.unedit.AbstractUnEditCommand;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.unedit.PerforceUnEditConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceUnEditCommand
extends AbstractUnEditCommand
implements PerforceCommand {
    protected ScmResult executeUnEditCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        PerforceUnEditConsumer consumer;
        Commandline cl;
        block4: {
            cl = PerforceUnEditCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files);
            consumer = new PerforceUnEditConsumer();
            try {
                CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
                int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)err);
                if (exitCode != 0) {
                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                    StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block4;
                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
            }
        }
        if (consumer.isSuccess()) {
            return new UnEditScmResult(cl.toString(), consumer.getEdits());
        }
        return new UnEditScmResult(cl.toString(), "Unable to revert", consumer.getOutput(), consumer.isSuccess());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("revert");
        List fs = files.getFileList();
        for (File file : fs) {
            command.createArg().setValue(file.getName());
        }
        return command;
    }
}

