/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui;

import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.ArchetypeFactory;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default")
@Singleton
public class DefaultArchetypeFactory
implements ArchetypeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArchetypeFactory.class);

    @Override
    public ArchetypeDefinition createArchetypeDefinition(Properties properties) {
        ArchetypeDefinition definition = new ArchetypeDefinition();
        definition.setGroupId(properties.getProperty("archetype.groupId"));
        definition.setArtifactId(properties.getProperty("archetype.artifactId"));
        definition.setVersion(properties.getProperty("archetype.version"));
        definition.setRepository(properties.getProperty("archetype.repository"));
        definition.setUrl(properties.getProperty("archetype.url"));
        definition.setDescription(properties.getProperty("archetype.description"));
        return definition;
    }

    private void addOldRequiredProperty(ArchetypeConfiguration configuration, Properties properties, String key, String defaultValue, boolean initPropertyWithDefault) {
        LOGGER.debug("Adding requiredProperty " + key);
        configuration.addRequiredProperty(key);
        String property = properties.getProperty(key);
        if (property != null) {
            configuration.setProperty(key, property);
            configuration.setDefaultProperty(key, property);
        } else if (defaultValue != null) {
            if (initPropertyWithDefault) {
                configuration.setProperty(key, defaultValue);
            }
            configuration.setDefaultProperty(key, defaultValue);
        }
        LOGGER.debug("Setting property " + key + "=" + configuration.getProperty(key));
    }

    @Override
    public ArchetypeConfiguration createArchetypeConfiguration(ArchetypeDescriptor archetypeDescriptor, Properties properties) {
        LOGGER.debug("Creating ArchetypeConfiguration from legacy descriptor and Properties");
        ArchetypeConfiguration configuration = this.createArchetypeConfiguration(properties);
        configuration.setName(archetypeDescriptor.getId());
        this.addOldRequiredProperty(configuration, properties, "groupId", null, false);
        this.addOldRequiredProperty(configuration, properties, "artifactId", null, false);
        this.addOldRequiredProperty(configuration, properties, "version", "1.0-SNAPSHOT", false);
        this.addOldRequiredProperty(configuration, properties, "package", configuration.getProperty("groupId"), true);
        return configuration;
    }

    private void addRequiredProperty(ArchetypeConfiguration configuration, Properties properties, String key, String defaultValue, boolean initPropertyWithDefault) {
        if (!configuration.isConfigured(key) && configuration.getDefaultValue(key) == null) {
            this.addOldRequiredProperty(configuration, properties, key, defaultValue, initPropertyWithDefault);
        }
    }

    @Override
    public ArchetypeConfiguration createArchetypeConfiguration(org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor, Properties properties) {
        LOGGER.debug("Creating ArchetypeConfiguration from fileset descriptor and Properties");
        ArchetypeConfiguration configuration = this.createArchetypeConfiguration(properties);
        configuration.setName(archetypeDescriptor.getName());
        for (RequiredProperty requiredProperty : archetypeDescriptor.getRequiredProperties()) {
            String key = requiredProperty.getKey();
            LOGGER.debug("Adding requiredProperty " + key);
            configuration.addRequiredProperty(key);
            String defaultValue = requiredProperty.getDefaultValue();
            String validationRegex = requiredProperty.getValidationRegex();
            if (properties.getProperty(key) != null) {
                String value = properties.getProperty(key);
                configuration.setProperty(key, value);
                LOGGER.debug("Setting property " + key + "=" + value);
            } else if (defaultValue != null && !this.containsInnerProperty(defaultValue)) {
                configuration.setProperty(key, defaultValue);
                LOGGER.debug("Setting property " + key + "=" + defaultValue);
            }
            if (defaultValue != null) {
                configuration.setDefaultProperty(key, defaultValue);
                LOGGER.debug("Setting defaultProperty " + key + "=" + defaultValue);
            }
            if (validationRegex == null) continue;
            configuration.setPropertyValidationRegex(key, validationRegex);
            LOGGER.debug("Setting validation regular expression " + key + "=" + defaultValue);
        }
        this.addRequiredProperty(configuration, properties, "groupId", null, false);
        this.addRequiredProperty(configuration, properties, "artifactId", null, false);
        this.addRequiredProperty(configuration, properties, "version", "1.0-SNAPSHOT", false);
        this.addRequiredProperty(configuration, properties, "package", configuration.getProperty("groupId"), true);
        String postGenerationGoals = properties.getProperty("archetype.goals");
        if (postGenerationGoals != null) {
            configuration.setProperty("archetype.goals", postGenerationGoals);
        }
        return configuration;
    }

    private void addRequiredProperty(ArchetypeConfiguration configuration, Properties properties, String key, String defaultValue) {
        LOGGER.debug("Adding requiredProperty " + key);
        configuration.addRequiredProperty(key);
        if (defaultValue != null) {
            configuration.setDefaultProperty(key, defaultValue);
        }
        if (properties.getProperty(key) != null) {
            configuration.setProperty(key, properties.getProperty(key));
            LOGGER.debug("Setting property " + key + "=" + configuration.getProperty("groupId"));
        }
    }

    private void setProperty(ArchetypeConfiguration configuration, Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property != null) {
            configuration.setProperty(key, property);
        }
    }

    @Override
    public ArchetypeConfiguration createArchetypeConfiguration(MavenProject project, ArchetypeDefinition archetypeDefinition, Properties properties) {
        LOGGER.debug("Creating ArchetypeConfiguration from ArchetypeDefinition, MavenProject and Properties");
        ArchetypeConfiguration configuration = this.createArchetypeConfiguration(properties);
        for (String string : properties.keySet()) {
            if (string.contains(".")) continue;
            LOGGER.debug("Adding requiredProperty " + string);
            configuration.addRequiredProperty(string);
            configuration.setProperty(string, properties.getProperty(string));
            LOGGER.debug("Setting property " + string + "=" + configuration.getProperty(string));
        }
        this.addRequiredProperty(configuration, properties, "groupId", project.getGroupId());
        this.addRequiredProperty(configuration, properties, "artifactId", project.getArtifactId());
        this.addRequiredProperty(configuration, properties, "version", project.getVersion());
        this.addRequiredProperty(configuration, properties, "package", null);
        this.setProperty(configuration, properties, "archetype.groupId");
        this.setProperty(configuration, properties, "archetype.artifactId");
        this.setProperty(configuration, properties, "archetype.version");
        this.setProperty(configuration, properties, "archetype.url");
        this.setProperty(configuration, properties, "archetype.description");
        return configuration;
    }

    private ArchetypeConfiguration createArchetypeConfiguration(Properties properties) {
        ArchetypeConfiguration configuration = new ArchetypeConfiguration();
        configuration.setGroupId(properties.getProperty("archetype.groupId"));
        configuration.setArtifactId(properties.getProperty("archetype.artifactId"));
        configuration.setVersion(properties.getProperty("archetype.version"));
        configuration.setUrl(properties.getProperty("archetype.url"));
        configuration.setDescription(properties.getProperty("archetype.description"));
        return configuration;
    }

    @Override
    public void updateArchetypeConfiguration(ArchetypeConfiguration archetypeConfiguration, ArchetypeDefinition archetypeDefinition) {
        archetypeConfiguration.setGroupId(archetypeDefinition.getGroupId());
        archetypeConfiguration.setArtifactId(archetypeDefinition.getArtifactId());
        archetypeConfiguration.setVersion(archetypeDefinition.getVersion());
    }

    private boolean containsInnerProperty(String defaultValue) {
        if (defaultValue == null) {
            return false;
        }
        int start = defaultValue.indexOf("${");
        return start >= 0 && defaultValue.indexOf("}", start) >= 0;
    }
}

