/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class JarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File archetypeDirectory;
    @Parameter(defaultValue="${project.build.finalName}", alias="jarName", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="true")
    private boolean useDefaultExcludes;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    private Map<String, Archiver> archivers;
    private ArchetypeArtifactManager archetypeArtifactManager;

    @Inject
    public JarMojo(Map<String, Archiver> archivers, ArchetypeArtifactManager archetypeArtifactManager) {
        this.archivers = archivers;
        this.archetypeArtifactManager = archetypeArtifactManager;
    }

    public void execute() throws MojoExecutionException {
        File jarFile = new File(this.outputDirectory, this.finalName + ".jar");
        this.getLog().info((CharSequence)("Building archetype jar: " + jarFile));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setCreatedBy("Maven Archetype Plugin", "org.apache.maven.plugins", "maven-archetype-plugin");
        archiver.setOutputFile(jarFile);
        archiver.setArchiver((JarArchiver)this.archivers.get("jar"));
        archiver.configureReproducibleBuild(this.outputTimestamp);
        try {
            DefaultFileSet fs = (DefaultFileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)this.archetypeDirectory).prefixed("")).includeExclude(null, null)).includeEmptyDirs(true);
            fs.setUsingDefaultExcludes(this.useDefaultExcludes);
            archiver.getArchiver().addFileSet((FileSet)fs);
            archiver.createArchive(this.session, this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling archetype jar " + jarFile, e);
        }
        this.checkArchetypeFile(jarFile);
        this.project.getArtifact().setFile(jarFile);
    }

    private void checkArchetypeFile(File jarFile) throws MojoExecutionException {
        block4: {
            try {
                if (this.archetypeArtifactManager.isFileSetArchetype(jarFile)) {
                    this.checkFileSetArchetypeFile(jarFile);
                    break block4;
                }
                if (this.archetypeArtifactManager.isOldArchetype(jarFile)) {
                    this.getLog().warn((CharSequence)"Building an Old (1.x) Archetype: consider migrating it to current 2.x Archetype.");
                    break block4;
                }
                throw new MojoExecutionException("The current project does not build an archetype");
            }
            catch (UnknownArchetype ua) {
                throw new MojoExecutionException(ua.getMessage(), (Exception)((Object)ua));
            }
        }
    }

    private void checkFileSetArchetypeFile(File jarFile) throws UnknownArchetype {
        ArchetypeDescriptor archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(jarFile);
        for (RequiredProperty rp : archetypeDescriptor.getRequiredProperties()) {
            if (!rp.getKey().contains(".")) continue;
            this.getLog().warn((CharSequence)("Invalid required property name '" + rp.getKey() + "': dot character makes is unusable in Velocity template"));
        }
    }
}

