/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import javax.inject.Inject;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.repositorycrawler.RepositoryCrawler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="crawl", requiresProject=false)
public class CrawlRepositoryMojo
extends AbstractMojo {
    @Parameter(property="catalog")
    private File catalogFile;
    private RepositoryCrawler crawler;
    @Parameter(property="repository", defaultValue="${settings.localRepository}")
    private File repository;

    @Inject
    public CrawlRepositoryMojo(RepositoryCrawler crawler) {
        this.crawler = crawler;
    }

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("repository " + this.repository + ", catalogFile " + this.catalogFile));
        if (this.repository == null) {
            throw new MojoExecutionException("The repository is not defined. Use -Drepository=/path/to/repository");
        }
        ArchetypeCatalog catalog = this.crawler.crawl(this.repository);
        if (this.catalogFile == null) {
            this.catalogFile = new File(this.repository, "archetype-catalog.xml");
        }
        this.crawler.writeCatalog(catalog, this.catalogFile);
    }
}

