/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.helpers.Loader;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.status.StatusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderContextSelector
implements ContextSelector {
    private static final AtomicReference<LoggerContext> context = new AtomicReference();
    private static PrivateSecurityManager securityManager;
    private static Method getCallerClass;
    private static final StatusLogger logger;
    private static final ConcurrentMap<String, AtomicReference<WeakReference<LoggerContext>>> contextMap;

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        LoggerContext lc;
        boolean next;
        Class clazz;
        if (currentContext) {
            LoggerContext ctx = ContextAnchor.THREAD_CONTEXT.get();
            if (ctx != null) {
                return ctx;
            }
            return this.getDefault();
        }
        if (loader != null) {
            return this.locateContext(loader, null);
        }
        if (getCallerClass != null) {
            try {
                Object[] params;
                clazz = Class.class;
                next = false;
                int index = 2;
                while (clazz != null && (clazz = (Class)getCallerClass.invoke(null, params = new Object[]{index})) != null) {
                    if (clazz.getName().equals(fqcn)) {
                        next = true;
                    } else if (next) break;
                    ++index;
                }
                if (clazz != null) {
                    return this.locateContext(clazz.getClassLoader(), null);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (securityManager != null && (clazz = securityManager.getCaller(fqcn)) != null) {
            return this.locateContext(clazz.getClassLoader(), null);
        }
        Throwable t = new Throwable();
        next = false;
        String name = null;
        for (StackTraceElement element : t.getStackTrace()) {
            if (element.getClassName().equals(fqcn)) {
                next = true;
                continue;
            }
            if (!next) continue;
            name = element.getClassName();
            break;
        }
        if (name != null) {
            try {
                return this.locateContext(Loader.loadClass(name).getClassLoader(), null);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if ((lc = ContextAnchor.THREAD_CONTEXT.get()) != null) {
            return lc;
        }
        return this.getDefault();
    }

    public void removeContext(LoggerContext context) {
        for (Map.Entry entry : contextMap.entrySet()) {
            LoggerContext ctx = (LoggerContext)((WeakReference)((AtomicReference)entry.getValue()).get()).get();
            if (ctx != context) continue;
            contextMap.remove(entry.getKey());
        }
    }

    @Override
    public List<LoggerContext> getLoggerContexts() {
        ArrayList<LoggerContext> list = new ArrayList<LoggerContext>();
        Collection coll = contextMap.values();
        for (AtomicReference ref : coll) {
            LoggerContext ctx = (LoggerContext)((WeakReference)ref.get()).get();
            if (ctx == null) continue;
            list.add(ctx);
        }
        return Collections.unmodifiableList(list);
    }

    private LoggerContext locateContext(ClassLoader loader, String configLocation) {
        String name = loader.toString();
        AtomicReference ref = (AtomicReference)contextMap.get(name);
        if (ref == null) {
            LoggerContext ctx = new LoggerContext(name, null, configLocation);
            AtomicReference<WeakReference<LoggerContext>> r = new AtomicReference<WeakReference<LoggerContext>>();
            r.set(new WeakReference<LoggerContext>(ctx));
            contextMap.putIfAbsent(loader.toString(), r);
            ctx = (LoggerContext)((WeakReference)((AtomicReference)contextMap.get(name)).get()).get();
            return ctx;
        }
        WeakReference r = (WeakReference)ref.get();
        LoggerContext ctx = (LoggerContext)r.get();
        if (ctx != null) {
            return ctx;
        }
        ctx = new LoggerContext(name, null, configLocation);
        ref.compareAndSet(r, new WeakReference<LoggerContext>(ctx));
        return ctx;
    }

    private static void setupCallerCheck() {
        try {
            Method[] methods;
            ClassLoader loader = Loader.getClassLoader();
            Class<?> clazz = loader.loadClass("sun.reflect.Reflection");
            for (Method method : methods = clazz.getMethods()) {
                int modifier = method.getModifiers();
                if (!method.getName().equals("getCallerClass") || !Modifier.isStatic(modifier)) continue;
                getCallerClass = method;
                break;
            }
        }
        catch (ClassNotFoundException cnfe) {
            logger.debug("sun.reflect.Reflection is not installed");
        }
        try {
            securityManager = new PrivateSecurityManager();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.debug("Unable to install security manager", (Throwable)ex);
        }
    }

    private LoggerContext getDefault() {
        LoggerContext ctx = context.get();
        if (ctx != null) {
            return ctx;
        }
        context.compareAndSet(null, new LoggerContext("Default"));
        return context.get();
    }

    static {
        logger = StatusLogger.getLogger();
        contextMap = new ConcurrentHashMap<String, AtomicReference<WeakReference<LoggerContext>>>();
        ClassLoaderContextSelector.setupCallerCheck();
    }

    private static class PrivateSecurityManager
    extends SecurityManager {
        private PrivateSecurityManager() {
        }

        public Class getCaller(String fqcn) {
            Class<?>[] classes = this.getClassContext();
            boolean next = false;
            for (Class<?> clazz : classes) {
                if (clazz.getName().equals(fqcn)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                return clazz;
            }
            return null;
        }
    }
}

