/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.EnumMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="LevelPatternConverter", type="Converter")
@ConverterKeys(value={"p", "level"})
public final class LevelPatternConverter
extends LogEventPatternConverter {
    private static final LevelPatternConverter INSTANCE = new LevelPatternConverter(null);
    private final EnumMap<Level, String> levelMap;

    private LevelPatternConverter(EnumMap<Level, String> map) {
        super("Level", "level");
        this.levelMap = map;
    }

    public static LevelPatternConverter newInstance(String[] options) {
        String[] definitions;
        if (options == null || options.length == 0) {
            return INSTANCE;
        }
        EnumMap<Level, String> levelMap = new EnumMap<Level, String>(Level.class);
        for (String string : definitions = options[0].split(",")) {
            String[] pair = string.split("=");
            if (pair == null || pair.length != 2) {
                LOGGER.error("Invalid option {}", new Object[]{string});
                continue;
            }
            Level level = Level.toLevel((String)pair[0].trim(), null);
            if (level == null) {
                LOGGER.error("Invalid Level {}", new Object[]{pair[0].trim()});
            }
            levelMap.put(level, pair[1].trim());
        }
        if (levelMap.size() == 0) {
            return INSTANCE;
        }
        for (String string : Level.values()) {
            if (levelMap.containsKey(string)) continue;
            levelMap.put((Level)string, string.toString());
        }
        return new LevelPatternConverter(levelMap);
    }

    @Override
    public void format(LogEvent event, StringBuilder output) {
        output.append(this.levelMap == null ? event.getLevel().toString() : this.levelMap.get(event.getLevel()));
    }

    @Override
    public String getStyleClass(Object e) {
        if (e instanceof LogEvent) {
            Level level = ((LogEvent)e).getLevel();
            switch (level) {
                case TRACE: {
                    return "level trace";
                }
                case DEBUG: {
                    return "level debug";
                }
                case INFO: {
                    return "level info";
                }
                case WARN: {
                    return "level warn";
                }
                case ERROR: {
                    return "level error";
                }
                case FATAL: {
                    return "level fatal";
                }
            }
            return "level " + ((LogEvent)e).getLevel().toString();
        }
        return "level";
    }
}

