/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.AbstractJMSManager;

public class JMSTopicManager
extends AbstractJMSManager {
    private static final JMSTopicManagerFactory factory = new JMSTopicManagerFactory();
    private final TopicConnection topicConnection;
    private final TopicSession topicSession;
    private final TopicPublisher topicPublisher;

    public JMSTopicManager(String name, TopicConnection conn, TopicSession sess, TopicPublisher pub) {
        super(name);
        this.topicConnection = conn;
        this.topicSession = sess;
        this.topicPublisher = pub;
    }

    public static JMSTopicManager getJMSTopicManager(String factoryName, String providerURL, String urlPkgPrefixes, String securityPrincipalName, String securityCredentials, String factoryBindingName, String topicBindingName, String userName, String password) {
        if (factoryBindingName == null) {
            LOGGER.error("No factory name provided for JMSTopicManager");
            return null;
        }
        if (topicBindingName == null) {
            LOGGER.error("No topic name provided for JMSTopicManager");
            return null;
        }
        String name = "JMSTopic:" + factoryBindingName + '.' + topicBindingName;
        return JMSTopicManager.getManager(name, factory, new FactoryData(factoryName, providerURL, urlPkgPrefixes, securityPrincipalName, securityCredentials, factoryBindingName, topicBindingName, userName, password));
    }

    public void send(Serializable object) throws Exception {
        super.send(object, (Session)this.topicSession, (MessageProducer)this.topicPublisher);
    }

    public void releaseSub() {
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (JMSException ex) {
            LOGGER.error("Error closing " + this.getName(), (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JMSTopicManagerFactory
    implements ManagerFactory<JMSTopicManager, FactoryData> {
        private JMSTopicManagerFactory() {
        }

        @Override
        public JMSTopicManager createManager(String name, FactoryData data) {
            try {
                Context ctx = AbstractJMSManager.createContext(data.factoryName, data.providerURL, data.urlPkgPrefixes, data.securityPrincipalName, data.securityCredentials);
                TopicConnectionFactory factory = (TopicConnectionFactory)AbstractJMSManager.lookup(ctx, data.factoryBindingName);
                TopicConnection conn = data.userName != null ? factory.createTopicConnection(data.userName, data.password) : factory.createTopicConnection();
                TopicSession sess = conn.createTopicSession(false, 1);
                Topic topic = (Topic)AbstractJMSManager.lookup(ctx, data.topicBindingName);
                TopicPublisher pub = sess.createPublisher(topic);
                conn.start();
                return new JMSTopicManager(name, conn, sess, pub);
            }
            catch (NamingException ex) {
                LOGGER.error("Bad Name " + data.topicBindingName, (Throwable)ex);
            }
            catch (JMSException jmsex) {
                LOGGER.error("Unable to create publisher ", (Throwable)jmsex);
            }
            return null;
        }
    }

    private static class FactoryData {
        private String factoryName;
        private String providerURL;
        private String urlPkgPrefixes;
        private String securityPrincipalName;
        private String securityCredentials;
        private String factoryBindingName;
        private String topicBindingName;
        private String userName;
        private String password;

        public FactoryData(String factoryName, String providerURL, String urlPkgPrefixes, String securityPrincipalName, String securityCredentials, String factoryBindingName, String topicBindingName, String userName, String password) {
            this.factoryName = factoryName;
            this.providerURL = providerURL;
            this.urlPkgPrefixes = urlPkgPrefixes;
            this.securityPrincipalName = securityPrincipalName;
            this.securityCredentials = securityCredentials;
            this.factoryBindingName = factoryBindingName;
            this.topicBindingName = topicBindingName;
            this.userName = userName;
            this.password = password;
        }
    }
}

