/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.AbstractJMSManager;

public class JMSQueueManager
extends AbstractJMSManager {
    private static final JMSQueueManagerFactory factory = new JMSQueueManagerFactory();
    private final QueueConnection queueConnection;
    private final QueueSession queueSession;
    private final QueueSender queueSender;

    protected JMSQueueManager(String name, QueueConnection conn, QueueSession sess, QueueSender sender) {
        super(name);
        this.queueConnection = conn;
        this.queueSession = sess;
        this.queueSender = sender;
    }

    public static JMSQueueManager getJMSQueueManager(String factoryName, String providerURL, String urlPkgPrefixes, String securityPrincipalName, String securityCredentials, String factoryBindingName, String queueBindingName, String userName, String password) {
        if (factoryBindingName == null) {
            LOGGER.error("No factory name provided for JMSQueueManager");
            return null;
        }
        if (queueBindingName == null) {
            LOGGER.error("No topic name provided for JMSQueueManager");
            return null;
        }
        String name = "JMSQueue:" + factoryBindingName + '.' + queueBindingName;
        return JMSQueueManager.getManager(name, factory, new FactoryData(factoryName, providerURL, urlPkgPrefixes, securityPrincipalName, securityCredentials, factoryBindingName, queueBindingName, userName, password));
    }

    public void send(Serializable object) throws Exception {
        super.send(object, (Session)this.queueSession, (MessageProducer)this.queueSender);
    }

    public void releaseSub() {
        try {
            if (this.queueSession != null) {
                this.queueSession.close();
            }
            if (this.queueConnection != null) {
                this.queueConnection.close();
            }
        }
        catch (JMSException ex) {
            LOGGER.error("Error closing " + this.getName(), (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JMSQueueManagerFactory
    implements ManagerFactory<JMSQueueManager, FactoryData> {
        private JMSQueueManagerFactory() {
        }

        @Override
        public JMSQueueManager createManager(String name, FactoryData data) {
            try {
                Context ctx = AbstractJMSManager.createContext(data.factoryName, data.providerURL, data.urlPkgPrefixes, data.securityPrincipalName, data.securityCredentials);
                QueueConnectionFactory factory = (QueueConnectionFactory)AbstractJMSManager.lookup(ctx, data.factoryBindingName);
                QueueConnection conn = data.userName != null ? factory.createQueueConnection(data.userName, data.password) : factory.createQueueConnection();
                QueueSession sess = conn.createQueueSession(false, 1);
                Queue queue = (Queue)AbstractJMSManager.lookup(ctx, data.queueBindingName);
                QueueSender sender = sess.createSender(queue);
                conn.start();
                return new JMSQueueManager(name, conn, sess, sender);
            }
            catch (NamingException ex) {
                LOGGER.error("Unable to locate resource", (Throwable)ex);
            }
            catch (JMSException jmsex) {
                LOGGER.error("Unable to establish connection", (Throwable)jmsex);
            }
            return null;
        }
    }

    private static class FactoryData {
        private String factoryName;
        private String providerURL;
        private String urlPkgPrefixes;
        private String securityPrincipalName;
        private String securityCredentials;
        private String factoryBindingName;
        private String queueBindingName;
        private String userName;
        private String password;

        public FactoryData(String factoryName, String providerURL, String urlPkgPrefixes, String securityPrincipalName, String securityCredentials, String factoryBindingName, String queueBindingName, String userName, String password) {
            this.factoryName = factoryName;
            this.providerURL = providerURL;
            this.urlPkgPrefixes = urlPkgPrefixes;
            this.securityPrincipalName = securityPrincipalName;
            this.securityCredentials = securityCredentials;
            this.factoryBindingName = factoryBindingName;
            this.queueBindingName = queueBindingName;
            this.userName = userName;
            this.password = password;
        }
    }
}

