/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Transform;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="XMLLayout", type="Core", elementType="layout", printObject=true)
public class XMLLayout
extends AbstractStringLayout {
    private static final int DEFAULT_SIZE = 256;
    private static final String[] FORMATS = new String[]{"xml"};
    private final boolean locationInfo;
    private final boolean properties;
    private final boolean complete;

    protected XMLLayout(boolean locationInfo, boolean properties, boolean complete, Charset charset) {
        super(charset);
        this.locationInfo = locationInfo;
        this.properties = properties;
        this.complete = complete;
    }

    @Override
    public String toSerializable(LogEvent event) {
        Throwable throwable;
        StringBuilder buf = new StringBuilder(256);
        buf.append("<log4j:event logger=\"");
        String name = event.getLoggerName();
        if (name.length() == 0) {
            name = "root";
        }
        buf.append(Transform.escapeTags(name));
        buf.append("\" timestamp=\"");
        buf.append(event.getMillis());
        buf.append("\" level=\"");
        buf.append(Transform.escapeTags(String.valueOf(event.getLevel())));
        buf.append("\" thread=\"");
        buf.append(Transform.escapeTags(event.getThreadName()));
        buf.append("\">\r\n");
        Message msg = event.getMessage();
        if (msg != null) {
            boolean xmlSupported = false;
            if (msg instanceof MultiformatMessage) {
                String[] formats;
                for (String format : formats = ((MultiformatMessage)msg).getFormats()) {
                    if (!format.equalsIgnoreCase("XML")) continue;
                    xmlSupported = true;
                }
            }
            if (xmlSupported) {
                buf.append("<log4j:message>");
                buf.append(((MultiformatMessage)msg).getFormattedMessage(FORMATS));
                buf.append("</log4j:message>");
            } else {
                buf.append("<log4j:message><![CDATA[");
                Transform.appendEscapingCDATA(buf, event.getMessage().getFormattedMessage());
                buf.append("]]></log4j:message>\r\n");
            }
        }
        if (event.getContextStack().getDepth() > 0) {
            buf.append("<log4j:NDC><![CDATA[");
            Transform.appendEscapingCDATA(buf, event.getContextStack().toString());
            buf.append("]]></log4j:NDC>\r\n");
        }
        if ((throwable = event.getThrown()) != null) {
            List<String> s = this.getThrowableString(throwable);
            buf.append("<log4j:throwable><![CDATA[");
            for (String str : s) {
                Transform.appendEscapingCDATA(buf, str);
                buf.append("\r\n");
            }
            buf.append("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            StackTraceElement element = event.getSource();
            buf.append("<log4j:locationInfo class=\"");
            buf.append(Transform.escapeTags(element.getClassName()));
            buf.append("\" method=\"");
            buf.append(Transform.escapeTags(element.getMethodName()));
            buf.append("\" file=\"");
            buf.append(Transform.escapeTags(element.getFileName()));
            buf.append("\" line=\"");
            buf.append(element.getLineNumber());
            buf.append("\"/>\r\n");
        }
        if (this.properties && event.getContextMap().size() > 0) {
            buf.append("<log4j:properties>\r\n");
            for (Map.Entry<String, String> entry : event.getContextMap().entrySet()) {
                buf.append("<log4j:data name=\"");
                buf.append(Transform.escapeTags(entry.getKey()));
                buf.append("\" value=\"");
                buf.append(Transform.escapeTags(String.valueOf(entry.getValue())));
                buf.append("\"/>\r\n");
            }
            buf.append("</log4j:properties>\r\n");
        }
        buf.append("</log4j:event>\r\n\r\n");
        return buf.toString();
    }

    @Override
    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        sbuf.append("<log4j:eventSet xmlns:log4j=\"http://logging.apache.org/log4j/\">\r\n");
        return sbuf.toString().getBytes(this.getCharset());
    }

    @Override
    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("</log4j:eventSet>\r\n");
        return sbuf.toString().getBytes(this.getCharset());
    }

    List<String> getThrowableString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            throwable.printStackTrace(pw);
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            if (ex instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            lines.add(ex.toString());
        }
        return lines;
    }

    @PluginFactory
    public static XMLLayout createLayout(@PluginAttr(value="locationInfo") String locationInfo, @PluginAttr(value="properties") String properties, @PluginAttr(value="complete") String complete, @PluginAttr(value="charset") String charset) {
        Charset c;
        Charset charset2 = c = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                c = Charset.forName(charset);
            } else {
                LOGGER.error("Charset " + charset + " is not supported for layout, using " + c.displayName());
            }
        }
        boolean info = locationInfo == null ? false : Boolean.valueOf(locationInfo);
        boolean props = properties == null ? false : Boolean.valueOf(properties);
        boolean comp = complete == null ? false : Boolean.valueOf(complete);
        return new XMLLayout(info, props, comp, c);
    }
}

