/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Priority;

@Plugin(name="SyslogLayout", type="Core", elementType="layout", printObject=true)
public class SyslogLayout
extends AbstractStringLayout {
    private final Facility facility;
    private final boolean includeNewLine;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss ", Locale.ENGLISH);
    private final String localHostname = this.getLocalHostname();

    protected SyslogLayout(Facility facility, boolean includeNL, Charset c) {
        super(c);
        this.facility = facility;
        this.includeNewLine = includeNL;
    }

    public String toSerializable(LogEvent event) {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        buf.append(Priority.getPriority(this.facility, event.getLevel()));
        buf.append(">");
        this.addDate(event.getMillis(), buf);
        buf.append(" ");
        buf.append(this.localHostname);
        buf.append(" ");
        buf.append(event.getMessage().getFormattedMessage());
        if (this.includeNewLine) {
            buf.append("\n");
        }
        return buf.toString();
    }

    private String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            LOGGER.error("Could not determine local host name", (Throwable)uhe);
            return "UNKNOWN_LOCALHOST";
        }
    }

    private synchronized void addDate(long timestamp, StringBuilder buf) {
        int index = buf.length() + 4;
        buf.append(this.dateFormat.format(new Date(timestamp)));
        if (buf.charAt(index) == '0') {
            buf.setCharAt(index, ' ');
        }
    }

    @PluginFactory
    public static SyslogLayout createLayout(@PluginAttr(value="facility") String facility, @PluginAttr(value="newLine") String includeNL, @PluginAttr(value="charset") String charset) {
        Charset c;
        Charset charset2 = c = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                c = Charset.forName(charset);
            } else {
                LOGGER.error("Charset " + charset + " is not supported for layout, using " + c.displayName());
            }
        }
        boolean includeNewLine = includeNL == null ? false : Boolean.valueOf(includeNL);
        Facility f = Facility.toFacility(facility, Facility.LOCAL0);
        return new SyslogLayout(f, includeNewLine, c);
    }
}

