/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Priority;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.message.StructuredDataMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Plugin(name="RFC5424Layout", type="Core", elementType="layout", printObject=true)
public final class RFC5424Layout
extends AbstractStringLayout {
    public static final int DEFAULT_ENTERPRISE_NUMBER = 18060;
    public static final String DEFAULT_ID = "Audit";
    private static final String DEFAULT_MDCID = "mdc";
    private static final int TWO_DIGITS = 10;
    private static final int THREE_DIGITS = 100;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MINUTES_PER_HOUR = 60;
    private final Facility facility;
    private final String defaultId;
    private final Integer enterpriseNumber;
    private final boolean includeMDC;
    private final String mdcId;
    private final String localHostName;
    private final String appName;
    private final String messageId;
    private final String configName;
    private final List<String> mdcExcludes;
    private final List<String> mdcIncludes;
    private final List<String> mdcRequired;
    private final ListChecker checker;
    private final ListChecker noopChecker = new NoopChecker();
    private final boolean includeNewLine;
    private long lastTimestamp = -1L;
    private String timestamppStr;

    private RFC5424Layout(Configuration config, Facility facility, String id, int ein, boolean includeMDC, boolean includeNL, String mdcId, String appName, String messageId, String excludes, String includes, String required, Charset charset) {
        super(charset);
        String[] array;
        this.facility = facility;
        this.defaultId = id == null ? DEFAULT_ID : id;
        this.enterpriseNumber = ein;
        this.includeMDC = includeMDC;
        this.includeNewLine = includeNL;
        this.mdcId = mdcId;
        this.appName = appName;
        this.messageId = messageId;
        this.localHostName = this.getLocalHostname();
        ListChecker c = null;
        if (excludes != null) {
            array = excludes.split(",");
            if (array.length > 0) {
                c = new ExcludeChecker();
                this.mdcExcludes = new ArrayList<String>(array.length);
                for (String str : array) {
                    this.mdcExcludes.add(str.trim());
                }
            } else {
                this.mdcExcludes = null;
            }
        } else {
            this.mdcExcludes = null;
        }
        if (includes != null) {
            array = includes.split(",");
            if (array.length > 0) {
                c = new IncludeChecker();
                this.mdcIncludes = new ArrayList<String>(array.length);
                for (String str : array) {
                    this.mdcIncludes.add(str.trim());
                }
            } else {
                this.mdcIncludes = null;
            }
        } else {
            this.mdcIncludes = null;
        }
        if (required != null) {
            array = required.split(",");
            if (array.length > 0) {
                this.mdcRequired = new ArrayList<String>(array.length);
                for (String str : array) {
                    this.mdcRequired.add(str.trim());
                }
            } else {
                this.mdcRequired = null;
            }
        } else {
            this.mdcRequired = null;
        }
        this.checker = c != null ? c : this.noopChecker;
        String name = config == null ? null : config.getName();
        this.configName = name != null && name.length() > 0 ? name : null;
    }

    @Override
    public String toSerializable(LogEvent event) {
        String type;
        Message msg = event.getMessage();
        boolean isStructured = msg instanceof StructuredDataMessage;
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        buf.append(Priority.getPriority(this.facility, event.getLevel()));
        buf.append(">1 ");
        buf.append(this.computeTimeStampString(event.getMillis()));
        buf.append(' ');
        buf.append(this.localHostName);
        buf.append(' ');
        if (this.appName != null) {
            buf.append(this.appName);
        } else if (this.configName != null) {
            buf.append(this.configName);
        } else {
            buf.append("-");
        }
        buf.append(" ");
        buf.append(this.getProcId());
        buf.append(" ");
        String string = type = isStructured ? ((StructuredDataMessage)msg).getType() : null;
        if (type != null) {
            buf.append(type);
        } else if (this.messageId != null) {
            buf.append(this.messageId);
        } else {
            buf.append("-");
        }
        buf.append(" ");
        if (isStructured || this.includeMDC) {
            String text;
            StructuredDataId id = null;
            if (isStructured) {
                StructuredDataMessage data = (StructuredDataMessage)msg;
                Map map = data.getData();
                id = data.getId();
                this.formatStructuredElement(id, map, buf, this.noopChecker);
                text = data.getFormat();
            } else {
                text = msg.getFormattedMessage();
            }
            if (this.includeMDC) {
                if (this.mdcRequired != null) {
                    this.checkRequired(event.getContextMap());
                }
                int ein = id == null || id.getEnterpriseNumber() < 0 ? this.enterpriseNumber.intValue() : id.getEnterpriseNumber();
                StructuredDataId mdcSDID = new StructuredDataId(this.mdcId, ein, null, null);
                this.formatStructuredElement(mdcSDID, event.getContextMap(), buf, this.checker);
            }
            if (text != null && text.length() > 0) {
                buf.append(" ").append(text);
            }
        } else {
            buf.append("- ");
            buf.append(msg.getFormattedMessage());
        }
        if (this.includeNewLine) {
            buf.append("\n");
        }
        return buf.toString();
    }

    protected String getProcId() {
        return "-";
    }

    public String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface nic = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        String hostname;
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || (hostname = address.getHostName()) == null) continue;
                        return hostname;
                    }
                }
            }
            catch (SocketException se) {
                LOGGER.error("Could not determine local host name", (Throwable)uhe);
                return "UNKNOWN_LOCALHOST";
            }
            LOGGER.error("Could not determine local host name", (Throwable)uhe);
            return "UNKNOWN_LOCALHOST";
        }
    }

    protected List<String> getMdcExcludes() {
        return this.mdcExcludes;
    }

    protected List<String> getMdcIncludes() {
        return this.mdcIncludes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeTimeStampString(long now) {
        int tzmin;
        long last;
        RFC5424Layout rFC5424Layout = this;
        synchronized (rFC5424Layout) {
            last = this.lastTimestamp;
            if (now == this.lastTimestamp) {
                return this.timestamppStr;
            }
        }
        StringBuilder buf = new StringBuilder();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(now);
        buf.append(Integer.toString(cal.get(1)));
        buf.append("-");
        this.pad(cal.get(2) + 1, 10, buf);
        buf.append("-");
        this.pad(cal.get(5), 10, buf);
        buf.append("T");
        this.pad(cal.get(11), 10, buf);
        buf.append(":");
        this.pad(cal.get(12), 10, buf);
        buf.append(":");
        this.pad(cal.get(13), 10, buf);
        int millis = cal.get(14);
        if (millis != 0) {
            buf.append('.');
            this.pad(millis, 100, buf);
        }
        if ((tzmin = (cal.get(15) + cal.get(16)) / 60000) == 0) {
            buf.append("Z");
        } else {
            if (tzmin < 0) {
                tzmin = -tzmin;
                buf.append("-");
            } else {
                buf.append("+");
            }
            int tzhour = tzmin / 60;
            this.pad(tzhour, 10, buf);
            buf.append(":");
            this.pad(tzmin -= tzhour * 60, 10, buf);
        }
        RFC5424Layout rFC5424Layout2 = this;
        synchronized (rFC5424Layout2) {
            if (last == this.lastTimestamp) {
                this.lastTimestamp = now;
                this.timestamppStr = buf.toString();
            }
        }
        return buf.toString();
    }

    private void pad(int val, int max, StringBuilder buf) {
        while (max > 1) {
            if (val < max) {
                buf.append("0");
            }
            max /= 10;
        }
        buf.append(Integer.toString(val));
    }

    private void formatStructuredElement(StructuredDataId id, Map<String, String> data, StringBuilder sb, ListChecker checker) {
        if (id == null && this.defaultId == null) {
            return;
        }
        sb.append("[");
        sb.append(this.getId(id));
        this.appendMap(data, sb, checker);
        sb.append("]");
    }

    private String getId(StructuredDataId id) {
        StringBuilder sb = new StringBuilder();
        if (id.getName() == null) {
            sb.append(this.defaultId);
        } else {
            sb.append(id.getName());
        }
        int ein = id.getEnterpriseNumber();
        if (ein < 0) {
            ein = this.enterpriseNumber;
        }
        if (ein >= 0) {
            sb.append("@").append(ein);
        }
        return sb.toString();
    }

    private void checkRequired(Map<String, String> map) {
        for (String key : this.mdcRequired) {
            String value = map.get(key);
            if (value != null) continue;
            throw new LoggingException("Required key " + key + " is missing from the " + this.mdcId);
        }
    }

    private void appendMap(Map<String, String> map, StringBuilder sb, ListChecker checker) {
        TreeMap<String, String> sorted = new TreeMap<String, String>(map);
        for (Map.Entry entry : sorted.entrySet()) {
            if (!checker.check((String)entry.getKey())) continue;
            sb.append(" ");
            sb.append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("facility=").append(this.facility.name());
        sb.append(" appName=").append(this.appName);
        sb.append(" defaultId=").append(this.defaultId);
        sb.append(" enterpriseNumber=").append(this.enterpriseNumber);
        sb.append(" newLine=").append(this.includeNewLine);
        sb.append(" includeMDC=").append(this.includeMDC);
        sb.append(" messageId=").append(this.messageId);
        return sb.toString();
    }

    @PluginFactory
    public static RFC5424Layout createLayout(@PluginAttr(value="facility") String facility, @PluginAttr(value="id") String id, @PluginAttr(value="enterpriseNumber") String ein, @PluginAttr(value="includeMDC") String includeMDC, @PluginAttr(value="mdcId") String mdcId, @PluginAttr(value="newLine") String includeNL, @PluginAttr(value="appName") String appName, @PluginAttr(value="messageId") String msgId, @PluginAttr(value="mdcExcludes") String excludes, @PluginAttr(value="mdcIncludes") String includes, @PluginAttr(value="mdcRequired") String required, @PluginAttr(value="charset") String charset, @PluginConfiguration Configuration config) {
        boolean includeNewLine;
        Charset c;
        Charset charset2 = c = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                c = Charset.forName(charset);
            } else {
                LOGGER.error("Charset " + charset + " is not supported for layout, using " + c.displayName());
            }
        }
        if (includes != null && excludes != null) {
            LOGGER.error("mdcIncludes and mdcExcludes are mutually exclusive. Includes wil be ignored");
            includes = null;
        }
        Facility f = Facility.toFacility(facility, Facility.LOCAL0);
        int enterpriseNumber = ein == null ? 18060 : Integer.parseInt(ein);
        boolean isMdc = includeMDC == null ? true : Boolean.valueOf(includeMDC);
        boolean bl = includeNewLine = includeNL == null ? false : Boolean.valueOf(includeNL);
        if (mdcId == null) {
            mdcId = DEFAULT_MDCID;
        }
        return new RFC5424Layout(config, f, id, enterpriseNumber, isMdc, includeNewLine, mdcId, appName, msgId, excludes, includes, required, c);
    }

    private class NoopChecker
    implements ListChecker {
        private NoopChecker() {
        }

        public boolean check(String key) {
            return true;
        }
    }

    private class ExcludeChecker
    implements ListChecker {
        private ExcludeChecker() {
        }

        public boolean check(String key) {
            return !RFC5424Layout.this.mdcExcludes.contains(key);
        }
    }

    private class IncludeChecker
    implements ListChecker {
        private IncludeChecker() {
        }

        public boolean check(String key) {
            return RFC5424Layout.this.mdcIncludes.contains(key);
        }
    }

    private static interface ListChecker {
        public boolean check(String var1);
    }
}

