/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.OptionConverter;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.RegexReplacement;

@Plugin(name="PatternLayout", type="Core", elementType="layout", printObject=true)
public final class PatternLayout
extends AbstractStringLayout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    public static final String SIMPLE_CONVERSION_PATTERN = "%d [%t] %p %c - %m%n";
    private static final String KEY = "Converter";
    private List<PatternFormatter> formatters;
    private final String conversionPattern;
    private boolean handlesExceptions;
    private final Configuration config;
    private final RegexReplacement replace;

    private PatternLayout(Configuration config, RegexReplacement replace, String pattern, Charset charset) {
        super(charset);
        this.replace = replace;
        this.conversionPattern = pattern;
        this.config = config;
        PatternParser parser = PatternLayout.createPatternParser(config);
        this.formatters = parser.parse(pattern == null ? DEFAULT_CONVERSION_PATTERN : pattern);
        this.handlesExceptions = parser.handlesExceptions();
    }

    public void setConversionPattern(String conversionPattern) {
        String pattern = OptionConverter.convertSpecialChars(conversionPattern);
        if (pattern == null) {
            return;
        }
        PatternParser parser = PatternLayout.createPatternParser(this.config);
        this.formatters = parser.parse(pattern);
        this.handlesExceptions = parser.handlesExceptions();
    }

    public String toSerializable(LogEvent event) {
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : this.formatters) {
            formatter.format(event, buf);
        }
        String str = buf.toString();
        if (this.replace != null) {
            str = this.replace.format(str);
        }
        return str;
    }

    public static PatternParser createPatternParser(Configuration config) {
        if (config == null) {
            return new PatternParser(config, KEY, LogEventPatternConverter.class);
        }
        PatternParser parser = (PatternParser)config.getComponent(KEY);
        if (parser == null) {
            parser = new PatternParser(config, KEY, LogEventPatternConverter.class);
            config.addComponent(KEY, parser);
            parser = (PatternParser)config.getComponent(KEY);
        }
        return parser;
    }

    public String toString() {
        return this.conversionPattern;
    }

    @PluginFactory
    public static PatternLayout createLayout(@PluginAttr(value="pattern") String pattern, @PluginConfiguration Configuration config, @PluginElement(value="replace") RegexReplacement replace, @PluginAttr(value="charset") String charset) {
        Charset c;
        Charset charset2 = c = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                c = Charset.forName(charset);
            } else {
                LOGGER.error("Charset " + charset + " is not supported for layout, using " + c.displayName());
            }
        }
        return new PatternLayout(config, replace, pattern == null ? DEFAULT_CONVERSION_PATTERN : pattern, c);
    }
}

