/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.helpers.Loader;
import org.apache.logging.log4j.core.selector.ClassLoaderContextSelector;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;

public class Log4jContextFactory
implements LoggerContextFactory {
    private static final StatusLogger logger = StatusLogger.getLogger();
    private ContextSelector selector;

    public Log4jContextFactory() {
        String sel = System.getProperty("Log4jContextSelector");
        if (sel != null) {
            try {
                Class<?> clazz = Loader.loadClass(sel);
                if (clazz != null && ContextSelector.class.isAssignableFrom(clazz)) {
                    this.selector = (ContextSelector)clazz.newInstance();
                    return;
                }
            }
            catch (Exception ex) {
                logger.error("Unable to create context " + sel, (Throwable)ex);
            }
        }
        this.selector = new ClassLoaderContextSelector();
    }

    public ContextSelector getSelector() {
        return this.selector;
    }

    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        LoggerContext ctx = this.selector.getContext(fqcn, loader, currentContext);
        if (ctx.getStatus() == LoggerContext.Status.INITIALIZED) {
            ctx.start();
        }
        return ctx;
    }
}

