/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.helpers;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public final class FileUtils {
    private static final String PROTOCOL_FILE = "file";
    private static final String JBOSS_FILE = "vfsfile";
    private static final Logger logger = StatusLogger.getLogger();

    private FileUtils() {
    }

    public static File fileFromURI(URI uri) {
        if (uri == null || uri.getScheme() != null && !PROTOCOL_FILE.equals(uri.getScheme()) && !JBOSS_FILE.equals(uri.getScheme())) {
            return null;
        }
        if (uri.getScheme() == null) {
            try {
                uri = new File(uri.getPath()).toURI();
            }
            catch (Exception ex) {
                logger.warn("Invalid URI " + uri);
                return null;
            }
        }
        try {
            return new File(URLDecoder.decode(uri.toURL().getFile(), "UTF8"));
        }
        catch (MalformedURLException ex) {
            logger.warn("Invalid URL " + uri, (Throwable)ex);
        }
        catch (UnsupportedEncodingException uee) {
            logger.warn("Invalid encoding: UTF8", (Throwable)uee);
        }
        return null;
    }

    public static boolean isFile(URL url) {
        return url != null && (url.getProtocol().equals(PROTOCOL_FILE) || url.getProtocol().equals(JBOSS_FILE));
    }
}

