/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.JSONConfiguration;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.plugins.Plugin;

@Plugin(name="JSONConfigurationFactory", type="ConfigurationFactory")
@Order(value=6)
public class JSONConfigurationFactory
extends ConfigurationFactory {
    public static final String[] SUFFIXES = new String[]{".json", ".jsn"};
    private static String[] dependencies = new String[]{"org.codehaus.jackson.JsonNode", "org.codehaus.jackson.map.ObjectMapper"};
    private File configFile = null;
    private boolean isActive;

    public JSONConfigurationFactory() {
        try {
            for (String item : dependencies) {
                Class.forName(item);
            }
        }
        catch (ClassNotFoundException ex) {
            LOGGER.debug("Missing dependencies for Json support");
            this.isActive = false;
            return;
        }
        this.isActive = true;
    }

    protected boolean isActive() {
        return this.isActive;
    }

    public Configuration getConfiguration(ConfigurationFactory.ConfigurationSource source) {
        if (!this.isActive) {
            return null;
        }
        return new JSONConfiguration(source);
    }

    public String[] getSupportedTypes() {
        return SUFFIXES;
    }
}

