/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.routing;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.appender.routing.Routes;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Routing", type="Core", elementType="appender", printObject=true)
public final class RoutingAppender
extends AbstractAppender {
    private static final String DEFAULT_KEY = "ROUTING_APPENDER_DEFAULT";
    private final Routes routes;
    private final Configuration config;
    private ConcurrentMap<String, AppenderControl> appenders = new ConcurrentHashMap<String, AppenderControl>();
    private final RewritePolicy rewritePolicy;

    private RoutingAppender(String name, Filter filter, boolean handleException, Routes routes, RewritePolicy rewritePolicy, Configuration config) {
        super(name, filter, null, handleException);
        this.routes = routes;
        this.config = config;
        this.rewritePolicy = rewritePolicy;
    }

    public void start() {
        Map<String, Appender> map = this.config.getAppenders();
        for (Route route : this.routes.getRoutes()) {
            if (route.getAppenderRef() == null) continue;
            Appender appender = map.get(route.getAppenderRef());
            if (appender != null) {
                String key;
                String string = key = route.getKey() == null ? DEFAULT_KEY : route.getKey();
                if (this.appenders.containsKey(key)) {
                    if (DEFAULT_KEY.equals(key)) {
                        LOGGER.error("Multiple default routes. Only the first will be used");
                        continue;
                    }
                    LOGGER.error("Duplicate route " + key + " is ignored");
                    continue;
                }
                this.appenders.put(key, new AppenderControl(appender, null, null));
                continue;
            }
            LOGGER.error("Appender " + route.getAppenderRef() + " cannot be located. Route ignored");
        }
        super.start();
    }

    public void stop() {
        super.stop();
        Map<String, Appender> map = this.config.getAppenders();
        for (Map.Entry entry : this.appenders.entrySet()) {
            String name = ((AppenderControl)entry.getValue()).getAppender().getName();
            if (DEFAULT_KEY.equals(entry.getKey()) || map.containsKey(name)) continue;
            ((AppenderControl)entry.getValue()).getAppender().stop();
        }
    }

    public void append(LogEvent event) {
        String key;
        AppenderControl control;
        if (this.rewritePolicy != null) {
            event = this.rewritePolicy.rewrite(event);
        }
        if ((control = this.getControl(key = this.config.getSubst().replace(event, this.routes.getPattern()), event)) != null) {
            control.callAppender(event);
        }
    }

    private synchronized AppenderControl getControl(String key, LogEvent event) {
        AppenderControl control = (AppenderControl)this.appenders.get(key);
        boolean defaultRoute = false;
        if (control != null) {
            return control;
        }
        Route route = null;
        for (Route r : this.routes.getRoutes()) {
            if (r.getAppenderRef() != null || !key.equals(r.getKey())) continue;
            route = r;
            break;
        }
        if (route == null) {
            control = (AppenderControl)this.appenders.get(DEFAULT_KEY);
            if (control != null) {
                return control;
            }
            for (Route r : this.routes.getRoutes()) {
                if (r.getAppenderRef() != null || r.getKey() != null) continue;
                route = r;
                defaultRoute = true;
                break;
            }
        }
        if (route != null) {
            Appender app = this.createAppender(route, event);
            if (app == null) {
                return null;
            }
            control = new AppenderControl(app, null, null);
            this.appenders.put(key, control);
            if (defaultRoute) {
                this.appenders.put(DEFAULT_KEY, control);
            }
        }
        return control;
    }

    private Appender createAppender(Route route, LogEvent event) {
        Node routeNode = route.getNode();
        for (Node node : routeNode.getChildren()) {
            if (!node.getType().getElementName().equals("appender")) continue;
            this.config.createConfiguration(node, event);
            if (node.getObject() instanceof Appender) {
                Appender app = (Appender)node.getObject();
                app.start();
                return (Appender)node.getObject();
            }
            LOGGER.error("Unable to create Appender of type " + node.getName());
            return null;
        }
        LOGGER.error("No Appender was configured for route " + route.getKey());
        return null;
    }

    @PluginFactory
    public static RoutingAppender createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppress, @PluginElement(value="routes") Routes routes, @PluginConfiguration Configuration config, @PluginElement(value="rewritePolicy") RewritePolicy rewritePolicy, @PluginElement(value="filters") Filter filter) {
        boolean handleExceptions;
        boolean bl = handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        if (name == null) {
            LOGGER.error("No name provided for RoutingAppender");
            return null;
        }
        if (routes == null) {
            LOGGER.error("No routes defined for RoutingAppender");
            return null;
        }
        return new RoutingAppender(name, filter, handleExceptions, routes, rewritePolicy, config);
    }
}

