/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.RFC5424Layout;
import org.apache.logging.log4j.core.layout.SyslogLayout;
import org.apache.logging.log4j.core.net.AbstractSocketManager;

@Plugin(name="Syslog", type="Core", elementType="appender", printObject=true)
public class SyslogAppender
extends SocketAppender {
    private static final String BSD = "bsd";
    private static final String RFC5424 = "RFC5424";

    protected SyslogAppender(String name, Layout layout, Filter filter, boolean handleException, boolean immediateFlush, AbstractSocketManager manager) {
        super(name, layout, filter, manager, handleException, immediateFlush);
    }

    @PluginFactory
    public static SyslogAppender createAppender(@PluginAttr(value="host") String host, @PluginAttr(value="port") String portNum, @PluginAttr(value="protocol") String protocol, @PluginAttr(value="reconnectionDelay") String delay, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginAttr(value="suppressExceptions") String suppress, @PluginAttr(value="facility") String facility, @PluginAttr(value="id") String id, @PluginAttr(value="enterpriseNumber") String ein, @PluginAttr(value="includeMDC") String includeMDC, @PluginAttr(value="mdcId") String mdcId, @PluginAttr(value="newLine") String includeNL, @PluginAttr(value="appName") String appName, @PluginAttr(value="messageId") String msgId, @PluginAttr(value="mdcExcludes") String excludes, @PluginAttr(value="mdcIncludes") String includes, @PluginAttr(value="mdcRequired") String required, @PluginAttr(value="format") String format, @PluginElement(value="filters") Filter filter, @PluginConfiguration Configuration config, @PluginAttr(value="charset") String charset) {
        SyslogLayout layout;
        Charset c;
        boolean isFlush = immediateFlush == null ? true : Boolean.valueOf(immediateFlush);
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        int reconnectDelay = delay == null ? 0 : Integer.parseInt(delay);
        int port = portNum == null ? 0 : Integer.parseInt(portNum);
        Charset charset2 = c = Charset.isSupported("UTF-8") ? Charset.forName("UTF-8") : Charset.defaultCharset();
        if (charset != null) {
            if (Charset.isSupported(charset)) {
                c = Charset.forName(charset);
            } else {
                LOGGER.error("Charset " + charset + " is not supported for layout, using " + c.displayName());
            }
        }
        AbstractStringLayout abstractStringLayout = layout = RFC5424.equalsIgnoreCase(format) ? RFC5424Layout.createLayout(facility, id, ein, includeMDC, mdcId, includeNL, appName, msgId, excludes, includes, required, charset, config) : SyslogLayout.createLayout(facility, includeNL, charset);
        if (name == null) {
            LOGGER.error("No name provided for SyslogAppender");
            return null;
        }
        AbstractSocketManager manager = SyslogAppender.createSocketManager(protocol, host, port, reconnectDelay);
        if (manager == null) {
            return null;
        }
        return new SyslogAppender(name, (Layout)layout, filter, handleExceptions, isFlush, manager);
    }
}

