/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.DatagramSocketManager;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.TCPSocketManager;
import org.apache.logging.log4j.util.EnglishEnums;

@Plugin(name="Socket", type="Core", elementType="appender", printObject=true)
public class SocketAppender
extends AbstractOutputStreamAppender {
    protected SocketAppender(String name, Layout layout, Filter filter, AbstractSocketManager manager, boolean handleException, boolean immediateFlush) {
        super(name, layout, filter, handleException, immediateFlush, manager);
    }

    @PluginFactory
    public static SocketAppender createAppender(@PluginAttr(value="host") String host, @PluginAttr(value="port") String portNum, @PluginAttr(value="protocol") String protocol, @PluginAttr(value="reconnectionDelay") String delay, @PluginAttr(value="name") String name, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginAttr(value="suppressExceptions") String suppress, @PluginElement(value="layout") Layout layout, @PluginElement(value="filters") Filter filter) {
        int port;
        boolean isFlush = immediateFlush == null ? true : Boolean.valueOf(immediateFlush);
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        int reconnectDelay = delay == null ? 0 : Integer.parseInt(delay);
        int n = port = portNum == null ? 0 : Integer.parseInt(portNum);
        if (layout == null) {
            layout = SerializedLayout.createLayout();
        }
        if (name == null) {
            LOGGER.error("No name provided for SocketAppender");
            return null;
        }
        AbstractSocketManager manager = SocketAppender.createSocketManager(protocol, host, port, reconnectDelay);
        if (manager == null) {
            return null;
        }
        return new SocketAppender(name, layout, filter, manager, handleExceptions, isFlush);
    }

    protected static AbstractSocketManager createSocketManager(String protocol, String host, int port, int delay) {
        Protocol p = (Protocol)EnglishEnums.valueOf(Protocol.class, (String)protocol);
        switch (p) {
            case TCP: {
                return TCPSocketManager.getSocketManager(host, port, delay);
            }
            case UDP: {
                return DatagramSocketManager.getSocketManager(host, port);
            }
        }
        return null;
    }
}

