/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="RollingFile", type="Core", elementType="appender", printObject=true)
public final class RollingFileAppender
extends AbstractOutputStreamAppender {
    private final String fileName;
    private final String filePattern;
    private final TriggeringPolicy policy;
    private final RolloverStrategy strategy;

    private RollingFileAppender(String name, Layout layout, TriggeringPolicy policy, RolloverStrategy strategy, Filter filter, RollingFileManager manager, String fileName, String filePattern, boolean handleException, boolean immediateFlush) {
        super(name, layout, filter, handleException, immediateFlush, manager);
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.policy = policy;
        this.strategy = strategy;
        policy.initialize(manager);
    }

    public void append(LogEvent event) {
        ((RollingFileManager)this.getManager()).checkRollover(event, this.policy, this.strategy);
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    @PluginFactory
    public static RollingFileAppender createAppender(@PluginAttr(value="fileName") String fileName, @PluginAttr(value="filePattern") String filePattern, @PluginAttr(value="append") String append, @PluginAttr(value="name") String name, @PluginAttr(value="bufferedIO") String bufferedIO, @PluginAttr(value="immediateFlush") String immediateFlush, @PluginElement(value="policy") TriggeringPolicy policy, @PluginElement(value="strategy") RolloverStrategy strategy, @PluginElement(value="layout") Layout layout, @PluginElement(value="filter") Filter filter, @PluginAttr(value="suppressExceptions") String suppress, @PluginConfiguration Configuration config) {
        RollingFileManager manager;
        boolean isFlush;
        boolean isAppend = append == null ? true : Boolean.valueOf(append);
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        boolean isBuffered = bufferedIO == null ? true : Boolean.valueOf(bufferedIO);
        boolean bl = isFlush = immediateFlush == null ? true : Boolean.valueOf(immediateFlush);
        if (name == null) {
            LOGGER.error("No name provided for FileAppender");
            return null;
        }
        if (fileName == null) {
            LOGGER.error("No filename was provided for FileAppender with name " + name);
            return null;
        }
        if (filePattern == null) {
            LOGGER.error("No filename pattern provided for FileAppender with name " + name);
            return null;
        }
        if (policy == null) {
            LOGGER.error("A TriggeringPolicy must be provided");
            return null;
        }
        if (strategy == null) {
            strategy = DefaultRolloverStrategy.createStrategy(null, null, config);
        }
        if ((manager = RollingFileManager.getFileManager(fileName, filePattern, isAppend, isBuffered)) == null) {
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null);
        }
        return new RollingFileAppender(name, layout, policy, strategy, filter, manager, fileName, filePattern, handleExceptions, isFlush);
    }
}

