/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderRuntimeException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.SerializedLayout;
import org.apache.logging.log4j.core.net.JMSTopicManager;

@Plugin(name="JMSTopic", type="Core", elementType="appender", printObject=true)
public final class JMSTopicAppender
extends AbstractAppender {
    private final JMSTopicManager manager;

    private JMSTopicAppender(String name, Filter filter, Layout layout, JMSTopicManager manager, boolean handleExceptions) {
        super(name, filter, layout, handleExceptions);
        this.manager = manager;
    }

    public void append(LogEvent event) {
        try {
            this.manager.send((Serializable)this.getLayout().toSerializable(event));
        }
        catch (Exception ex) {
            throw new AppenderRuntimeException(ex);
        }
    }

    @PluginFactory
    public static JMSTopicAppender createAppender(@PluginAttr(value="factoryName") String factoryName, @PluginAttr(value="providerURL") String providerURL, @PluginAttr(value="urlPkgPrefixes") String urlPkgPrefixes, @PluginAttr(value="securityPrincipalName") String securityPrincipalName, @PluginAttr(value="securityCredentials") String securityCredentials, @PluginAttr(value="factoryBindingName") String factoryBindingName, @PluginAttr(value="topicBindingName") String topicBindingName, @PluginAttr(value="userName") String userName, @PluginAttr(value="password") String password, @PluginElement(value="layout") Layout layout, @PluginElement(value="filters") Filter filter, @PluginAttr(value="suppressExceptions") String suppress) {
        String name = "JMSTopic" + factoryBindingName + '.' + topicBindingName;
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        JMSTopicManager manager = JMSTopicManager.getJMSTopicManager(factoryName, providerURL, urlPkgPrefixes, securityPrincipalName, securityCredentials, factoryBindingName, topicBindingName, userName, password);
        if (manager == null) {
            return null;
        }
        if (layout == null) {
            layout = SerializedLayout.createLayout();
        }
        return new JMSTopicAppender(name, filter, layout, manager, handleExceptions);
    }
}

