/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.AppenderRuntimeException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;

public class FileManager
extends OutputStreamManager {
    private static final FileManagerFactory factory = new FileManagerFactory();
    private final boolean isAppend;
    private final boolean isLocking;

    protected FileManager(String fileName, OutputStream os, boolean append, boolean locking) {
        super(os, fileName);
        this.isAppend = append;
        this.isLocking = locking;
    }

    public static FileManager getFileManager(String fileName, boolean append, boolean locking, boolean bufferedIO) {
        if (locking && bufferedIO) {
            locking = false;
        }
        return (FileManager)FileManager.getManager(fileName, new FactoryData(append, locking, bufferedIO), factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void write(byte[] bytes, int offset, int length) {
        block6: {
            if (this.isLocking) {
                FileChannel channel = ((FileOutputStream)this.getOutputStream()).getChannel();
                try {
                    FileLock lock = channel.lock(0L, Long.MAX_VALUE, false);
                    try {
                        super.write(bytes, offset, length);
                        break block6;
                    }
                    finally {
                        lock.release();
                    }
                }
                catch (IOException ex) {
                    throw new AppenderRuntimeException("Unable to obtain lock on " + this.getName(), ex);
                }
            }
            super.write(bytes, offset, length);
        }
    }

    public String getFileName() {
        return this.getName();
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public boolean isLocking() {
        return this.isLocking;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileManagerFactory
    implements ManagerFactory<FileManager, FactoryData> {
        private FileManagerFactory() {
        }

        @Override
        public FileManager createManager(String name, FactoryData data) {
            File file = new File(name);
            File parent = file.getParentFile();
            if (null != parent && !parent.exists()) {
                parent.mkdirs();
            }
            try {
                OutputStream os = new FileOutputStream(name, data.append);
                if (data.bufferedIO) {
                    os = new BufferedOutputStream(os);
                }
                return new FileManager(name, os, data.append, data.locking);
            }
            catch (FileNotFoundException ex) {
                AbstractManager.LOGGER.error("FileManager (" + name + ") " + ex);
                return null;
            }
        }
    }

    private static class FactoryData {
        private final boolean append;
        private final boolean locking;
        private final boolean bufferedIO;

        public FactoryData(boolean append, boolean locking, boolean bufferedIO) {
            this.append = append;
            this.locking = locking;
            this.bufferedIO = bufferedIO;
        }
    }
}

