/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="Failover", type="Core", elementType="appender", printObject=true)
public final class FailoverAppender
extends AbstractAppender {
    private final String primaryRef;
    private final String[] failovers;
    private final Configuration config;
    private AppenderControl primary;
    private final List<AppenderControl> failoverAppenders = new ArrayList<AppenderControl>();

    private FailoverAppender(String name, Filter filter, String primary, String[] failovers, Configuration config, boolean handleExceptions) {
        super(name, filter, null, handleExceptions);
        this.primaryRef = primary;
        this.failovers = failovers;
        this.config = config;
    }

    public void start() {
        Map<String, Appender> map = this.config.getAppenders();
        int errors = 0;
        if (map.containsKey(this.primaryRef)) {
            this.primary = new AppenderControl(map.get(this.primaryRef), null, null);
        } else {
            LOGGER.error("Unable to locate primary Appender " + this.primaryRef);
            ++errors;
        }
        for (String name : this.failovers) {
            if (map.containsKey(name)) {
                this.failoverAppenders.add(new AppenderControl(map.get(name), null, null));
                continue;
            }
            LOGGER.error("Failover appender " + name + " is not configured");
        }
        if (this.failoverAppenders.size() == 0) {
            LOGGER.error("No failover appenders are available");
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    public void append(LogEvent event) {
        block6: {
            LoggingException re = null;
            if (!this.isStarted()) {
                this.error("FailoverAppender " + this.getName() + " did not start successfully");
                return;
            }
            try {
                this.primary.callAppender(event);
            }
            catch (Exception ex) {
                re = new LoggingException(ex);
                boolean written = false;
                for (AppenderControl control : this.failoverAppenders) {
                    try {
                        control.callAppender(event);
                        written = true;
                        break;
                    }
                    catch (Exception fex) {
                    }
                }
                if (written || this.isExceptionSuppressed()) break block6;
                throw re;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(" primary=").append(this.primary).append(", failover={");
        boolean first = true;
        for (String str : this.failovers) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(str);
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    @PluginFactory
    public static FailoverAppender createAppender(@PluginAttr(value="name") String name, @PluginAttr(value="primary") String primary, @PluginElement(value="failovers") String[] failovers, @PluginConfiguration Configuration config, @PluginElement(value="filters") Filter filter, @PluginAttr(value="suppressExceptions") String suppress) {
        if (name == null) {
            LOGGER.error("A name for the Appender must be specified");
            return null;
        }
        if (primary == null) {
            LOGGER.error("A primary Appender must be specified");
            return null;
        }
        if (failovers == null || failovers.length == 0) {
            LOGGER.error("At least one failover Appender must be specified");
            return null;
        }
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        return new FailoverAppender(name, filter, primary, failovers, config, handleExceptions);
    }
}

