/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.helpers.Loader;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Console", type="Core", elementType="appender", printObject=true)
public final class ConsoleAppender
extends AbstractOutputStreamAppender {
    private static ConsoleManagerFactory factory = new ConsoleManagerFactory();

    private ConsoleAppender(String name, Layout layout, Filter filter, OutputStreamManager manager, boolean handleExceptions) {
        super(name, layout, filter, handleExceptions, true, manager);
    }

    @PluginFactory
    public static ConsoleAppender createAppender(@PluginElement(value="layout") Layout layout, @PluginElement(value="filters") Filter filter, @PluginAttr(value="target") String t, @PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppress) {
        if (name == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout(null, null, null, null);
        }
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        Target target = t == null ? Target.SYSTEM_OUT : Target.valueOf(t);
        return new ConsoleAppender(name, layout, filter, ConsoleAppender.getManager(target), handleExceptions);
    }

    private static OutputStreamManager getManager(Target target) {
        String type = target.name();
        OutputStream os = ConsoleAppender.getOutputStream(target);
        return OutputStreamManager.getManager(target.name(), new FactoryData(os, type), factory);
    }

    private static OutputStream getOutputStream(Target target) {
        PrintStream printStream;
        PrintStream printStream2 = printStream = target == Target.SYSTEM_OUT ? System.out : System.err;
        if (!System.getProperty("os.name").startsWith("Windows")) {
            return printStream;
        }
        try {
            ClassLoader loader = Loader.getClassLoader();
            Class<?> clazz = loader.loadClass("org.fusesource.jansi.WindowsAnsiOutputStream");
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class);
            return (OutputStream)constructor.newInstance(printStream);
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.debug("Jansi is not installed");
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.warn("WindowsAnsiOutputStream is missing the proper constructor");
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to instantiate WindowsAnsiOutputStream");
        }
        return printStream;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private ConsoleManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            return new OutputStreamManager(data.os, data.type);
        }
    }

    private static class FactoryData {
        private OutputStream os;
        private String type;

        public FactoryData(OutputStream os, String type) {
            this.os = os;
            this.type = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        SYSTEM_OUT,
        SYSTEM_ERR;

    }
}

