/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.status.StatusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractManager {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private static final Map<String, AbstractManager> map = new HashMap<String, AbstractManager>();
    private static final Lock lock = new ReentrantLock();
    protected int count;
    private final String name;

    protected AbstractManager(String name) {
        this.name = name;
        LOGGER.debug("Starting {} {}", new Object[]{this.getClass().getSimpleName(), name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <M extends AbstractManager, T> M getManager(String name, ManagerFactory<M, T> factory, T data) {
        lock.lock();
        try {
            AbstractManager manager = map.get(name);
            if (manager == null) {
                manager = (AbstractManager)factory.createManager(name, data);
                if (manager == null) {
                    throw new IllegalStateException("Unable to create a manager");
                }
                map.put(name, manager);
            }
            ++manager.count;
            AbstractManager abstractManager = manager;
            return (M)abstractManager;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasManager(String name) {
        lock.lock();
        try {
            boolean bl = map.containsKey(name);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    protected void releaseSub() {
    }

    protected int getCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        lock.lock();
        try {
            --this.count;
            if (this.count <= 0) {
                map.remove(this.name);
                LOGGER.debug("Shutting down {} {}", new Object[]{this.getClass().getSimpleName(), this.getName()});
                this.releaseSub();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public String getName() {
        return this.name;
    }
}

