/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.File;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.status.StatusLogger;

public class LoggerContext
implements org.apache.logging.log4j.spi.LoggerContext,
ConfigurationListener,
LifeCycle {
    private static final StatusLogger logger = StatusLogger.getLogger();
    private final ConcurrentMap<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private volatile Configuration config = new DefaultConfiguration();
    private Object externalContext;
    private final String name;
    private final URI configLocation;
    private volatile Status status = Status.INITIALIZED;
    private final Lock configLock = new ReentrantLock();

    public LoggerContext(String name) {
        this(name, null, (URI)null);
    }

    public LoggerContext(String name, Object externalContext) {
        this(name, externalContext, (URI)null);
    }

    public LoggerContext(String name, Object externalContext, URI configLocn) {
        this.name = name;
        this.externalContext = externalContext;
        this.configLocation = configLocn;
    }

    public LoggerContext(String name, Object externalContext, String configLocn) {
        this.name = name;
        this.externalContext = externalContext;
        if (configLocn != null) {
            URI uri;
            try {
                uri = new File(configLocn).toURI();
            }
            catch (Exception ex) {
                uri = null;
            }
            this.configLocation = uri;
        } else {
            this.configLocation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.configLock.tryLock()) {
            try {
                if (this.status == Status.INITIALIZED) {
                    this.status = Status.STARTING;
                    this.reconfigure();
                    this.status = Status.STARTED;
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.configLock.lock();
        try {
            this.status = Status.STOPPING;
            this.updateLoggers(new NullConfiguration());
            this.config.stop();
            this.externalContext = null;
            this.status = Status.STOPPED;
        }
        finally {
            this.configLock.unlock();
        }
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isStarted() {
        return this.status == Status.STARTED;
    }

    public void setExternalContext(Object context) {
        this.externalContext = context;
    }

    public Object getExternalContext() {
        return this.externalContext;
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)((Object)this.loggers.get(name));
        if (logger != null) {
            return logger;
        }
        logger = this.newInstance(this, name);
        Logger prev = this.loggers.putIfAbsent(name, logger);
        return prev == null ? logger : prev;
    }

    public boolean hasLogger(String name) {
        return this.loggers.containsKey(name);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void addFilter(Filter filter) {
        this.config.addFilter(filter);
    }

    public void removeFiler(Filter filter) {
        this.config.removeFilter(filter);
    }

    public synchronized Configuration setConfiguration(Configuration config) {
        if (config == null) {
            throw new NullPointerException("No Configuration was provided");
        }
        Configuration prev = this.config;
        config.addListener(this);
        config.start();
        this.config = config;
        this.updateLoggers();
        if (prev != null) {
            prev.removeListener(this);
            prev.stop();
        }
        return prev;
    }

    public synchronized void reconfigure() {
        logger.debug("Reconfiguration started for context " + this.name);
        Configuration instance = ConfigurationFactory.getInstance().getConfiguration(this.name, this.configLocation);
        this.setConfiguration(instance);
        logger.debug("Reconfiguration completed");
    }

    public void updateLoggers() {
        this.updateLoggers(this.config);
    }

    public void updateLoggers(Configuration config) {
        for (Logger logger : this.loggers.values()) {
            logger.updateConfiguration(config);
        }
    }

    public synchronized void onChange(Reconfigurable reconfigurable) {
        logger.debug("Reconfiguration started for context " + this.name);
        Configuration config = reconfigurable.reconfigure();
        if (config != null) {
            this.setConfiguration(config);
            logger.debug("Reconfiguration completed");
        } else {
            logger.debug("Reconfiguration failed");
        }
    }

    private Logger newInstance(LoggerContext ctx, String name) {
        return new Logger(ctx, name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

