/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.strategy.async;

import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.orchestrator.conf.OrchestratorConfiguration$;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.execution.ArrayResultSetTaskResponse;
import org.apache.linkis.orchestrator.execution.AsyncTaskResponse;
import org.apache.linkis.orchestrator.execution.FailedTaskResponse;
import org.apache.linkis.orchestrator.execution.RetryTaskResponse;
import org.apache.linkis.orchestrator.execution.SucceedTaskResponse;
import org.apache.linkis.orchestrator.execution.TaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultFailedTaskResponse;
import org.apache.linkis.orchestrator.execution.impl.DefaultResultSetTaskResponse;
import org.apache.linkis.orchestrator.listener.execution.ExecTaskRunnerCompletedEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.strategy.ExecTaskStatusInfo;
import org.apache.linkis.orchestrator.strategy.ResultSetExecTask;
import org.apache.linkis.orchestrator.strategy.StatusInfoExecTask;
import org.apache.linkis.orchestrator.strategy.async.AsyncExecTask;
import org.apache.linkis.orchestrator.strategy.async.AsyncExecTaskRunner;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001=\u0011q#Q:z]\u000e,\u00050Z2UCN\\'+\u001e8oKJLU\u000e\u001d7\u000b\u0005\r!\u0011!B1ts:\u001c'BA\u0003\u0007\u0003!\u0019HO]1uK\u001eL(BA\u0004\t\u00031y'o\u00195fgR\u0014\u0018\r^8s\u0015\tI!\"\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\u0002\u0004\b\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0014\u0003NLhnY#yK\u000e$\u0016m]6Sk:tWM\u001d\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nQ!\u001e;jYNT!!\t\u0005\u0002\r\r|W.\\8o\u0013\t\u0019cDA\u0004M_\u001e<\u0017N\\4\t\u0011\u0015\u0002!Q1A\u0005B\u0019\nA\u0001^1tWV\tq\u0005\u0005\u0002)[5\t\u0011F\u0003\u0002+W\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002-\r\u0005)\u0001\u000f\\1og&\u0011a&\u000b\u0002\t\u000bb,7\rV1tW\"A\u0001\u0007\u0001B\u0001B\u0003%q%A\u0003uCN\\\u0007\u0005C\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0003iU\u0002\"!\u0007\u0001\t\u000b\u0015\n\u0004\u0019A\u0014\t\u000f]\u0002\u0001\u0019!C\u0005q\u000511\u000f^1ukN,\u0012!\u000f\t\u0003u\u0001k\u0011a\u000f\u0006\u0003yu\na!\u001a8uSRL(BA\u0011?\u0015\ty\u0004\"\u0001\u0006h_Z,'O\\1oG\u0016L!!Q\u001e\u0003'\u0015CXmY;uS>tgj\u001c3f'R\fG/^:\t\u000f\r\u0003\u0001\u0019!C\u0005\t\u0006Q1\u000f^1ukN|F%Z9\u0015\u0005\u0015[\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%\u0001B+oSRDq\u0001\u0014\"\u0002\u0002\u0003\u0007\u0011(A\u0002yIEBaA\u0014\u0001!B\u0013I\u0014aB:uCR,8\u000f\t\u0005\n!\u0002\u0001\r\u00111A\u0005\nE\u000bA\u0002^1tWJ+7\u000f]8og\u0016,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u001a\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005]#&\u0001\u0004+bg.\u0014Vm\u001d9p]N,\u0007\"C-\u0001\u0001\u0004\u0005\r\u0011\"\u0003[\u0003A!\u0018m]6SKN\u0004xN\\:f?\u0012*\u0017\u000f\u0006\u0002F7\"9A\nWA\u0001\u0002\u0004\u0011\u0006BB/\u0001A\u0003&!+A\u0007uCN\\'+Z:q_:\u001cX\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0003)\u0011Xm];miN+Go]\u000b\u0002CB\u0019!mZ5\u000e\u0003\rT!\u0001Z3\u0002\u000f5,H/\u00192mK*\u0011amR\u0001\u000bG>dG.Z2uS>t\u0017B\u00015d\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005)lW\"A6\u000b\u000514\u0011\u0001B2pe\u0016L!A\\6\u0003\u0013I+7/\u001e7u'\u0016$\bB\u00029\u0001A\u0003%\u0011-A\u0006sKN,H\u000e^*fiN\u0004\u0003b\u0002:\u0001\u0001\u0004%Ia]\u0001\u000be\u0016\u001cX\u000f\u001c;TSj,W#\u0001;\u0011\u0005\u0019+\u0018B\u0001<H\u0005\rIe\u000e\u001e\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u00039\u0011Xm];miNK'0Z0%KF$\"!\u0012>\t\u000f1;\u0018\u0011!a\u0001i\"1A\u0010\u0001Q!\nQ\f1B]3tk2$8+\u001b>fA!)a\u0010\u0001C!#\u0006yq-\u001a;UCN\\'+Z:q_:\u001cX\rC\u0004\u0002\u0002\u0001!\t%a\u0001\u0002\u0017%\u001c8i\\7qY\u0016$X\rZ\u000b\u0003\u0003\u000b\u00012ARA\u0004\u0013\r\tIa\u0012\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0001\u0001C!\u0003\u0007\t\u0011\"[:Sk:t\u0017N\\4\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0004\u0005I\u0011n]*vG\u000e,W\r\u001a\u0005\b\u0003+\u0001A\u0011IA\f\u0003\r\u0011XO\u001c\u000b\u0002\u000b\"9\u00111\u0004\u0001\u0005B\u0005u\u0011a\u0004;sC:\u001c\u0018.\u001a8u'R\fG/^:\u0015\u0007\u0015\u000by\u0002\u0003\u00048\u00033\u0001\r!\u000f\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003I\tg\r^3s'R\fG/^:DQ\u0006tw-\u001a3\u0015\u000b\u0015\u000b9#a\u000b\t\u000f\u0005%\u0012\u0011\u0005a\u0001s\u0005QaM]8n'R\fG/^:\t\u000f\u00055\u0012\u0011\u0005a\u0001s\u0005AAo\\*uCR,8\u000fC\u0004\u00022\u0001!\t!a\r\u0002'\t,gm\u001c:f'R\fG/^:DQ\u0006tw-\u001a3\u0015\u000b\u0015\u000b)$a\u000e\t\u000f\u0005%\u0012q\u0006a\u0001s!9\u0011QFA\u0018\u0001\u0004I\u0004bBA\u001e\u0001\u0011E\u0011QH\u0001\u001aSN<\u0016-\u001b;G_J\u0004VM]:jgR,G\rV5nK>,H\u000f\u0006\u0003\u0002\u0006\u0005}\u0002\u0002CA!\u0003s\u0001\r!a\u0011\u00023M$\u0018M\u001d;XC&$hi\u001c:QKJ\u001c\u0018n\u001d;fIRKW.\u001a\t\u0004\r\u0006\u0015\u0013bAA$\u000f\n!Aj\u001c8h\u0011\u001d\tY\u0005\u0001C!\u0003/\t\u0011\"\u001b8uKJ\u0014X\u000f\u001d;\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R\u0005i1/\u001a;SKN,H\u000e^*ju\u0016$2!RA*\u0011\u0019\u0011\u0018Q\na\u0001i\"9\u0011q\u000b\u0001\u0005B\u0005e\u0013\u0001D1eIJ+7/\u001e7u'\u0016$HcA#\u0002\\!9\u0011QLA+\u0001\u0004I\u0017!\u0003:fgVdGoU3u\u0011\u001d\t\t\u0007\u0001C!\u0003G\n!\"\\1sW\u001a\u000b\u0017\u000e\\3e)\u0015)\u0015QMA<\u0011!\t9'a\u0018A\u0002\u0005%\u0014\u0001C3se>\u0014Xj]4\u0011\t\u0005-\u0014\u0011\u000f\b\u0004\r\u00065\u0014bAA8\u000f\u00061\u0001K]3eK\u001aLA!a\u001d\u0002v\t11\u000b\u001e:j]\u001eT1!a\u001cH\u0011!\tI(a\u0018A\u0002\u0005m\u0014!B2bkN,\u0007\u0003BA?\u0003\u001bsA!a \u0002\n:!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u0006:\ta\u0001\u0010:p_Rt\u0014\"\u0001%\n\u0007\u0005-u)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0015\u0011\u0013\u0002\n)\"\u0014xn^1cY\u0016T1!a#H\u0001")
public class AsyncExecTaskRunnerImpl
implements AsyncExecTaskRunner,
Logging {
    private final ExecTask task;
    private ExecutionNodeStatus status;
    private TaskResponse taskResponse;
    private final ArrayBuffer<ResultSet> org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets;
    private int resultSize;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AsyncExecTaskRunnerImpl asyncExecTaskRunnerImpl = this;
        synchronized (asyncExecTaskRunnerImpl) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    @Override
    public ExecTask task() {
        return this.task;
    }

    private ExecutionNodeStatus status() {
        return this.status;
    }

    private void status_$eq(ExecutionNodeStatus x$1) {
        this.status = x$1;
    }

    private TaskResponse taskResponse() {
        return this.taskResponse;
    }

    private void taskResponse_$eq(TaskResponse x$1) {
        this.taskResponse = x$1;
    }

    public ArrayBuffer<ResultSet> org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets() {
        return this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets;
    }

    private int resultSize() {
        return this.resultSize;
    }

    private void resultSize_$eq(int x$1) {
        this.resultSize = x$1;
    }

    @Override
    public TaskResponse getTaskResponse() {
        return this.taskResponse();
    }

    @Override
    public boolean isCompleted() {
        return ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)this.status());
    }

    @Override
    public boolean isRunning() {
        return ExecutionNodeStatus.isRunning((ExecutionNodeStatus)this.status());
    }

    @Override
    public boolean isSucceed() {
        return ExecutionNodeStatus.isScheduled((ExecutionNodeStatus)this.status());
    }

    @Override
    public void run() {
        block6: {
            try {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AsyncExecTaskRunnerImpl $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ExecTaskRunner Submit execTask(", ") to running"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.task().getIDInfo()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                TaskResponse response = this.task().execute();
                this.taskResponse_$eq(response);
                TaskResponse taskResponse = response;
                if (taskResponse instanceof AsyncTaskResponse) {
                    this.transientStatus(ExecutionNodeStatus.Running);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (taskResponse instanceof SucceedTaskResponse) {
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Succeed to execute ExecTask(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task().getIDInfo()})));
                    this.transientStatus(ExecutionNodeStatus.Succeed);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (taskResponse instanceof FailedTaskResponse) {
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to execute ExecTask(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task().getIDInfo()})));
                    this.transientStatus(ExecutionNodeStatus.Failed);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (taskResponse instanceof RetryTaskResponse) {
                    this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ExecTask(", ") need to retry"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task().getIDInfo()})));
                    this.transientStatus(ExecutionNodeStatus.WaitForRetry);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)taskResponse);
            }
            catch (Throwable throwable) {
                this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to execute task ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task().getIDInfo()})), throwable);
                this.taskResponse_$eq(new DefaultFailedTaskResponse(throwable.getMessage(), OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_ERROR_CODE(), throwable));
                this.transientStatus(ExecutionNodeStatus.Failed);
            }
        }
    }

    @Override
    public void transientStatus(ExecutionNodeStatus status) {
        if (status.ordinal() < this.status().ordinal()) {
            ExecutionNodeStatus executionNodeStatus = status;
            ExecutionNodeStatus executionNodeStatus2 = ExecutionNodeStatus.WaitForRetry;
            if (executionNodeStatus == null ? executionNodeStatus2 != null : !executionNodeStatus.equals(executionNodeStatus2)) {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task", " status flip error! Cause: Failed to flip from ", " to ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task().getIDInfo(), this.status(), status})));
                return;
            }
        }
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " change status ", " => ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task().getIDInfo(), this.status(), status})));
        this.beforeStatusChanged(this.status(), status);
        ExecutionNodeStatus oldStatus = this.status();
        this.status_$eq(status);
        this.afterStatusChanged(oldStatus, status);
    }

    public void afterStatusChanged(ExecutionNodeStatus fromStatus, ExecutionNodeStatus toStatus) {
        if (ExecutionNodeStatus.isSucceed((ExecutionNodeStatus)toStatus)) {
            ExecTask execTask = this.task();
            if (execTask instanceof ResultSetExecTask) {
                TaskResponse taskResponse;
                ResultSetExecTask resultSetExecTask = (ResultSetExecTask)execTask;
                if (this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().nonEmpty()) {
                    this.taskResponse_$eq(new DefaultResultSetTaskResponse((ResultSet[])this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().toArray(ClassTag$.MODULE$.apply(ResultSet.class))));
                }
                if ((taskResponse = this.taskResponse()) instanceof ArrayResultSetTaskResponse) {
                    ArrayResultSetTaskResponse arrayResultSetTaskResponse = (ArrayResultSetTaskResponse)taskResponse;
                    resultSetExecTask.addResultSet(arrayResultSetTaskResponse);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        if (ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)toStatus)) {
            ExecTask execTask = this.task();
            if (execTask instanceof StatusInfoExecTask) {
                StatusInfoExecTask statusInfoExecTask = (StatusInfoExecTask)execTask;
                statusInfoExecTask.addExecTaskStatusInfo(new ExecTaskStatusInfo(toStatus, this.taskResponse()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ExecTask execTask2 = this.task();
            if (execTask2 instanceof AsyncExecTask) {
                AsyncExecTask asyncExecTask = (AsyncExecTask)execTask2;
                asyncExecTask.clear(ExecutionNodeStatus.isSucceed((ExecutionNodeStatus)toStatus));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.task().getPhysicalContext().broadcastSyncEvent(new ExecTaskRunnerCompletedEvent(this));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeStatusChanged(ExecutionNodeStatus fromStatus, ExecutionNodeStatus toStatus) {
        BoxedUnit boxedUnit;
        ExecTask execTask = this.task();
        if (!(execTask instanceof AsyncExecTask)) {
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            return;
        }
        if (ExecutionNodeStatus.isSucceed((ExecutionNodeStatus)toStatus) && (this.resultSize() < 0 || this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().size() < this.resultSize())) {
            long startWaitForPersistedTime = System.currentTimeMillis();
            ArrayBuffer<ResultSet> arrayBuffer = this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets();
            synchronized (arrayBuffer) {
                while (!(this.resultSize() >= 0 && this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().size() >= this.resultSize() || this.isWaitForPersistedTimeout(startWaitForPersistedTime))) {
                    this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().wait(1000L);
                }
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl14 : MonitorExitStatement: MONITOREXIT : arrayBuffer
                boxedUnit = boxedUnit2;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public boolean isWaitForPersistedTimeout(long startWaitForPersistedTime) {
        return System.currentTimeMillis() - startWaitForPersistedTime >= ((TimeType)OrchestratorConfiguration$.MODULE$.TASK_MAX_PERSIST_WAIT_TIME().getValue()).toLong();
    }

    @Override
    public void interrupt() {
        this.markFailed("Job be cancelled", null);
        ExecTask execTask = this.task();
        if (execTask instanceof AsyncExecTask) {
            AsyncExecTask asyncExecTask = (AsyncExecTask)execTask;
            asyncExecTask.kill();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.transientStatus(ExecutionNodeStatus.Cancelled);
    }

    @Override
    public void setResultSize(int resultSize) {
        this.info((Function0<String>)new Serializable(this, resultSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncExecTaskRunnerImpl $outer;
            private final int resultSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BaseExecTaskRunner ", " get result size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.task().getIDInfo(), BoxesRunTime.boxToInteger((int)this.resultSize$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resultSize$1 = resultSize$1;
            }
        });
        if (this.resultSize() == -1) {
            this.resultSize_$eq(resultSize);
        }
        this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().notify();
    }

    @Override
    public void addResultSet(ResultSet resultSet) {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncExecTaskRunnerImpl $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BaseExecTaskRunner ", " get result, now size is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.task().getIDInfo(), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().size())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().$plus$eq((Object)resultSet);
        this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets().notify();
    }

    @Override
    public void markFailed(String errorMsg, Throwable cause) {
        this.taskResponse_$eq(new DefaultFailedTaskResponse(errorMsg, OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_ERROR_CODE(), cause));
    }

    public AsyncExecTaskRunnerImpl(ExecTask task) {
        this.task = task;
        Logging.class.$init$((Logging)this);
        this.status = ExecutionNodeStatus.Inited;
        this.org$apache$linkis$orchestrator$strategy$async$AsyncExecTaskRunnerImpl$$resultSets = new ArrayBuffer();
        this.resultSize = -1;
    }
}

