/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.VerifiableProperties;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mx4jLoader$
implements Logging,
ScalaObject {
    public static final Mx4jLoader$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new Mx4jLoader$();
    }

    public boolean maybeLoad() {
        VerifiableProperties props = new VerifiableProperties(System.getProperties());
        Object object = props.getBoolean("kafka_mx4jenable", false) ? BoxesRunTime.boxToBoolean((boolean)false) : BoxedUnit.UNIT;
        String address = props.getString("mx4jaddress", "0.0.0.0");
        int port = props.getInt("mx4jport", 8082);
        Object exceptionResult1 = null;
        try {
            this.debug((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Will try to load MX4j now, if it's in the classpath";
                }
            });
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName processorName = new ObjectName("Server:name=XSLTProcessor");
            Class<?> httpAdaptorClass = Class.forName("mx4j.tools.adaptor.http.HttpAdaptor");
            Object httpAdaptor = httpAdaptorClass.newInstance();
            httpAdaptorClass.getMethod("setHost", String.class).invoke(httpAdaptor, address);
            httpAdaptorClass.getMethod("setPort", Integer.TYPE).invoke(httpAdaptor, BoxesRunTime.boxToInteger((int)port));
            ObjectName httpName = new ObjectName("system:name=http");
            mbs.registerMBean(httpAdaptor, httpName);
            Class<?> xsltProcessorClass = Class.forName("mx4j.tools.adaptor.http.XSLTProcessor");
            Object xsltProcessor = xsltProcessorClass.newInstance();
            httpAdaptorClass.getMethod("setProcessor", Class.forName("mx4j.tools.adaptor.http.ProcessorMBean")).invoke(httpAdaptor, xsltProcessor);
            mbs.registerMBean(xsltProcessor, processorName);
            httpAdaptorClass.getMethod("start", new Class[0]).invoke(httpAdaptor, new Object[0]);
            this.info((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "mx4j successfuly loaded";
                }
            });
            exceptionResult1 = BoxesRunTime.boxToBoolean((boolean)true);
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Could not start register mbean in JMX";
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            });
            exceptionResult1 = BoxedUnit.UNIT;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.info((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Will not load MX4J, mx4j-tools.jar is not in the classpath";
                }
            });
            exceptionResult1 = BoxedUnit.UNIT;
        }
        return false;
    }

    private Mx4jLoader$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

