/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import kafka.tools.ProducerPerformance;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProducerPerformance$
implements Logging,
ScalaObject {
    public static final ProducerPerformance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ProducerPerformance$();
    }

    public void main(String[] args) {
        Logger logger = Logger.getLogger(this.getClass());
        ProducerPerformance.ProducerPerfConfig config$1 = new ProducerPerformance.ProducerPerfConfig(args);
        if (!config$1.isFixedSize()) {
            logger.info((Object)"WARN: Throughput will be slower due to changing message size per request");
        }
        AtomicLong totalBytesSent$1 = new AtomicLong(0L);
        AtomicLong totalMessagesSent$1 = new AtomicLong(0L);
        ExecutorService executor$1 = Executors.newFixedThreadPool(config$1.numThreads());
        CountDownLatch allDone$1 = new CountDownLatch(config$1.numThreads());
        long startMs = System.currentTimeMillis();
        Random rand$1 = new Random();
        if (!config$1.hideHeader()) {
            Predef$.MODULE$.println((Object)"start.time, end.time, compression, message.size, batch.size, total.data.sent.in.MB, MB.sec, total.data.sent.in.nMsg, nMsg.sec");
        }
        Predef$.MODULE$.intWrapper(0).until(config$1.numThreads()).foreach$mVc$sp((Function1)new Serializable(config$1, totalBytesSent$1, totalMessagesSent$1, executor$1, allDone$1, rand$1){
            public static final long serialVersionUID;
            private final ProducerPerformance.ProducerPerfConfig config$1;
            private final AtomicLong totalBytesSent$1;
            private final AtomicLong totalMessagesSent$1;
            private final ExecutorService executor$1;
            private final CountDownLatch allDone$1;
            private final Random rand$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.executor$1.execute(new ProducerPerformance.ProducerThread(v1, this.config$1, this.totalBytesSent$1, this.totalMessagesSent$1, this.allDone$1, this.rand$1));
            }
            {
                this.config$1 = producerPerfConfig;
                this.totalBytesSent$1 = atomicLong;
                this.totalMessagesSent$1 = atomicLong2;
                this.executor$1 = executorService;
                this.allDone$1 = countDownLatch;
                this.rand$1 = random;
            }
        });
        allDone$1.await();
        long endMs = System.currentTimeMillis();
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        double totalMBSent = (double)totalBytesSent$1.get() * 1.0 / (double)0x100000;
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %s, %d, %d, %d, %.2f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config$1.dateFormat().format(BoxesRunTime.boxToLong((long)startMs)), config$1.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)config$1.compressionCodec().codec()), BoxesRunTime.boxToInteger((int)config$1.messageSize()), BoxesRunTime.boxToInteger((int)config$1.batchSize()), BoxesRunTime.boxToDouble((double)totalMBSent), BoxesRunTime.boxToDouble((double)(totalMBSent / elapsedSecs)), BoxesRunTime.boxToLong((long)totalMessagesSent$1.get()), BoxesRunTime.boxToDouble((double)((double)totalMessagesSent$1.get() / elapsedSecs))})));
        System.exit(0);
    }

    private ProducerPerformance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

