/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.ToolsUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class GetOffsetShell$
implements ScalaObject {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class);
        ArgumentAcceptingOptionSpec nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting consumer offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt, timeOpt}));
        String clientId$1 = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        String topic$1 = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionList = (String)options.valueOf((OptionSpec)partitionOpt);
        LongRef time$1 = new LongRef(((Long)options.valueOf((OptionSpec)timeOpt)).longValue());
        int nOffsets$1 = (Integer)options.valueOf((OptionSpec)nOffsetsOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        Seq<TopicMetadata> topicsMetadata$1 = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))), metadataTargetBrokers, clientId$1, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata$1.size() != 1 || !((TopicMetadata)topicsMetadata$1.apply(0)).topic().equals(topic$1)) {
            System.err.println(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1}))).append((Object)"kafka-list-topic.sh to verify").toString());
            System.exit(1);
        }
        String string = partitionList;
        String string2 = "";
        Seq partitions = !(string != null ? !string.equals(string2) : string2 != null) ? (Seq)((TopicMetadata)topicsMetadata$1.head()).partitionsMetadata().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(PartitionMetadata partitionMetadata) {
                return partitionMetadata.partitionId();
            }
        }, Seq$.MODULE$.canBuildFrom()) : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionList.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(String string) {
                return Predef$.MODULE$.augmentString(string).toInt();
            }
        }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()))).toSeq();
        partitions.foreach((Function1)new Serializable(clientId$1, topic$1, time$1, nOffsets$1, topicsMetadata$1){
            public static final long serialVersionUID;
            private final String clientId$1;
            private final String topic$1;
            private final LongRef time$1;
            private final int nOffsets$1;
            private final Seq topicsMetadata$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int v1$1) {
                Option option;
                block6: {
                    block4: {
                        block2: {
                            Option<Broker> option2;
                            block5: {
                                block3: {
                                    Broker broker;
                                    Option partitionMetadataOpt = ((TopicMetadata)this.topicsMetadata$1.head()).partitionsMetadata().find((Function1)new Serializable(this, v1$1){
                                        public static final long serialVersionUID;
                                        private final int v1$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(PartitionMetadata partitionMetadata) {
                                            return partitionMetadata.partitionId() == this.v1$1;
                                        }
                                        {
                                            this.v1$1 = n;
                                        }
                                    });
                                    option = partitionMetadataOpt;
                                    if (!(option instanceof Some)) break block2;
                                    Some some = (Some)option;
                                    PartitionMetadata partitionMetadata = (PartitionMetadata)some.x();
                                    PartitionMetadata metadata = partitionMetadata;
                                    option2 = metadata.leader();
                                    if (!(option2 instanceof Some)) break block3;
                                    Some some2 = (Some)option2;
                                    Broker leader = broker = (Broker)some2.x();
                                    SimpleConsumer consumer = new SimpleConsumer(leader.host(), leader.port(), 10000, 100000, this.clientId$1);
                                    TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, v1$1);
                                    OffsetRequest request = new OffsetRequest((Map<TopicAndPartition, PartitionOffsetRequestInfo>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition).$minus$greater((Object)new PartitionOffsetRequestInfo(this.time$1.elem, this.nOffsets$1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                                    Seq<Object> offsets = ((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
                                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s:%d:%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)v1$1), offsets.mkString(",")})));
                                    break block4;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<Broker> option3 = option2;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                                System.err.println(Predef$.MODULE$.augmentString("Error: partition %d does not have a leader. Skip getting offsets").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)v1$1)})));
                                break block4;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option option4 = option;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block6;
                        System.err.println(Predef$.MODULE$.augmentString("Error: partition %d does not exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)v1$1)})));
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.clientId$1 = string;
                this.topic$1 = string2;
                this.time$1 = longRef;
                this.nOffsets$1 = n;
                this.topicsMetadata$1 = seq;
            }
        });
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

