/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5q!B\u0001\u0003\u0011\u000b9\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA)a\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0004\u00131!\u0002CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u00067%!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAqAH\u0005C\u0002\u0013%q$\u0001\u0004m_\u001e<WM]\u000b\u0002AA\u0011\u0011\u0005K\u0007\u0002E)\u00111\u0005J\u0001\u0006Y><GG\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014x-\u0003\u0002*E\t1Aj\\4hKJDaaK\u0005!\u0002\u0013\u0001\u0013a\u00027pO\u001e,'\u000f\t\u0005\u0006[%!\tAL\u0001\u0005[\u0006Lg\u000e\u0006\u00020eA\u0011Q\u0003M\u0005\u0003cY\u0011A!\u00168ji\")1\u0007\fa\u0001i\u0005!\u0011M]4t!\r)RgN\u0005\u0003mY\u0011Q!\u0011:sCf\u0004\"\u0001O\u001e\u000f\u0005UI\u0014B\u0001\u001e\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i2b\u0001B \n\u0001\u0001\u0013!cQ8ogVlWM\u001d)fe\u001a\u001cuN\u001c4jON\u0019a(\u0011\u000b\u0011\u0005!\u0011\u0015BA\"\u0003\u0005)\u0001VM\u001d4D_:4\u0017n\u001a\u0005\tgy\u0012\t\u0011)A\u0005i!)1D\u0010C\u0001\rR\u0011q)\u0013\t\u0003\u0011zj\u0011!\u0003\u0005\u0006g\u0015\u0003\r\u0001\u000e\u0005\b\u0017z\u0012\r\u0011\"\u0001M\u00031Q8nQ8o]\u0016\u001cGo\u00149u+\u0005i\u0005c\u0001(Ro5\tqJC\u0001Q\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0003%>\u00131$\u0011:hk6,g\u000e^!dG\u0016\u0004H/\u001b8h\u001fB$\u0018n\u001c8Ta\u0016\u001c\u0007B\u0002+?A\u0003%Q*A\u0007{W\u000e{gN\\3di>\u0003H\u000f\t\u0005\b-z\u0012\r\u0011\"\u0001M\u0003!!x\u000e]5d\u001fB$\bB\u0002-?A\u0003%Q*A\u0005u_BL7m\u00149uA!9!L\u0010b\u0001\n\u0003a\u0015AC4s_V\u0004\u0018\nZ(qi\"1AL\u0010Q\u0001\n5\u000b1b\u001a:pkBLEm\u00149uA!9aL\u0010b\u0001\n\u0003y\u0016\u0001\u00044fi\u000eD7+\u001b>f\u001fB$X#\u00011\u0011\u00079\u000b\u0016\r\u0005\u0002\u000eE&\u00111M\u0004\u0002\b\u0013:$XmZ3s\u0011\u0019)g\b)A\u0005A\u0006ia-\u001a;dQNK'0Z(qi\u0002Bqa\u001a C\u0002\u0013\u0005\u0001.A\fsKN,GOQ3hS:t\u0017N\\4PM\u001a\u001cX\r^(qiV\t\u0011\u000e\u0005\u0002OU&\u00111n\u0014\u0002\u0012\u001fB$\u0018n\u001c8Ta\u0016\u001c')^5mI\u0016\u0014\bBB7?A\u0003%\u0011.\u0001\rsKN,GOQ3hS:t\u0017N\\4PM\u001a\u001cX\r^(qi\u0002Bqa\u001c C\u0002\u0013\u0005q,A\nt_\u000e\\W\r\u001e\"vM\u001a,'oU5{K>\u0003H\u000f\u0003\u0004r}\u0001\u0006I\u0001Y\u0001\u0015g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016|\u0005\u000f\u001e\u0011\t\u000fMt$\u0019!C\u0001?\u0006ia.^7UQJ,\u0017\rZ:PaRDa!\u001e !\u0002\u0013\u0001\u0017A\u00048v[RC'/Z1eg>\u0003H\u000f\t\u0005\boz\u0012\r\u0011\"\u0001`\u00039qW/\u001c$fi\u000eDWM]:PaRDa!\u001f !\u0002\u0013\u0001\u0017a\u00048v[\u001a+Go\u00195feN|\u0005\u000f\u001e\u0011\t\u000fmt$\u0019!C\u0001y\u00069q\u000e\u001d;j_:\u001cX#A?\u0011\u00059s\u0018BA@P\u0005%y\u0005\u000f^5p]N+G\u000fC\u0004\u0002\u0004y\u0002\u000b\u0011B?\u0002\u0011=\u0004H/[8og\u0002B\u0011\"a\u0002?\u0005\u0004%\t!!\u0003\u0002\u000bA\u0014x\u000e]:\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001#\u0001\u0003vi&d\u0017\u0002BA\u000b\u0003\u001f\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011!\tIB\u0010Q\u0001\n\u0005-\u0011A\u00029s_B\u001c\b\u0005C\u0005\u0002\u001ey\u0012\r\u0011\"\u0001\u0002 \u0005q1m\u001c8tk6,'oQ8oM&<WCAA\u0011!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\t\u0005A1m\u001c8tk6,'/\u0003\u0003\u0002,\u0005\u0015\"AD\"p]N,X.\u001a:D_:4\u0017n\u001a\u0005\t\u0003_q\u0004\u0015!\u0003\u0002\"\u0005y1m\u001c8tk6,'oQ8oM&<\u0007\u0005C\u0005\u00024y\u0012\r\u0011\"\u0001\u00026\u0005Qa.^7UQJ,\u0017\rZ:\u0016\u0005\u0005]\u0002cA\u000b\u0002:%\u0019\u00111\b\f\u0003\u0007%sG\u000f\u0003\u0005\u0002@y\u0002\u000b\u0011BA\u001c\u0003-qW/\u001c+ie\u0016\fGm\u001d\u0011\t\u0013\u0005\rcH1A\u0005\u0002\u0005\u0015\u0013!\u0002;pa&\u001cW#A\u001c\t\u000f\u0005%c\b)A\u0005o\u00051Ao\u001c9jG\u0002B\u0011\"!\u0014?\u0005\u0004%\t!a\u0014\u0002\u00179,X.T3tg\u0006<Wm]\u000b\u0003\u0003#\u00022!FA*\u0013\r\t)F\u0006\u0002\u0005\u0019>tw\r\u0003\u0005\u0002Zy\u0002\u000b\u0011BA)\u00031qW/\\'fgN\fw-Z:!\u0011%\tiF\u0010b\u0001\n\u0003\t)$A\tsKB|'\u000f^5oO&sG/\u001a:wC2D\u0001\"!\u0019?A\u0003%\u0011qG\u0001\u0013e\u0016\u0004xN\u001d;j]\u001eLe\u000e^3sm\u0006d\u0007\u0005C\u0005\u0002fy\u0012\r\u0011\"\u0001\u0002h\u0005\t2\u000f[8x\t\u0016$\u0018-\u001b7fIN#\u0018\r^:\u0016\u0005\u0005%\u0004cA\u000b\u0002l%\u0019\u0011Q\u000e\f\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\u000f !\u0002\u0013\tI'\u0001\ntQ><H)\u001a;bS2,Gm\u0015;biN\u0004\u0003\"CA;}\t\u0007I\u0011AA<\u0003)!\u0017\r^3G_Jl\u0017\r^\u000b\u0003\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f\u0002\u0012\u0001\u0002;fqRLA!a!\u0002~\t\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r\u001e\u0005\t\u0003\u000fs\u0004\u0015!\u0003\u0002z\u0005YA-\u0019;f\r>\u0014X.\u0019;!\u0011%\tYI\u0010b\u0001\n\u0003\t9'\u0001\u0006iS\u0012,\u0007*Z1eKJD\u0001\"a$?A\u0003%\u0011\u0011N\u0001\fQ&$W\rS3bI\u0016\u0014\bE\u0002\u0004\u0002\u0014&\u0001\u0011Q\u0013\u0002\u0013\u0007>t7/^7feB+'O\u001a+ie\u0016\fGmE\u0003\u0002\u0012\u0006]E\u0003E\u0002\u000e\u00033K1!a'\u000f\u0005\u0019!\u0006N]3bI\"Y\u0011qTAI\u0005\u0003\u0005\u000b\u0011BA\u001c\u0003!!\bN]3bI&#\u0007BCAR\u0003#\u0013\t\u0011)A\u0005o\u0005!a.Y7f\u0011-\t9+!%\u0003\u0002\u0003\u0006I!!+\u0002\rM$(/Z1n!!\t\u0019#a+\u00020\u0006=\u0016\u0002BAW\u0003K\u00111bS1gW\u0006\u001cFO]3b[B!Q#NAY!\r)\u00121W\u0005\u0004\u0003k3\"\u0001\u0002\"zi\u0016D!\"!/\u0002\u0012\n\u0005\t\u0015!\u0003H\u0003\u0019\u0019wN\u001c4jO\"Y\u0011QXAI\u0005\u0003\u0005\u000b\u0011BA`\u0003E!x\u000e^1m\u001b\u0016\u001c8/Y4fgJ+\u0017\r\u001a\t\u0005\u0003\u0003\fY-\u0004\u0002\u0002D*!\u0011QYAd\u0003\u0019\tGo\\7jG*!\u0011\u0011ZA\b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u001b\f\u0019M\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD1\"!5\u0002\u0012\n\u0005\t\u0015!\u0003\u0002@\u0006qAo\u001c;bY\nKH/Z:SK\u0006$\u0007bB\u000e\u0002\u0012\u0012\u0005\u0011Q\u001b\u000b\u000f\u0003/\fI.a7\u0002^\u0006}\u0017\u0011]Ar!\rA\u0015\u0011\u0013\u0005\t\u0003?\u000b\u0019\u000e1\u0001\u00028!9\u00111UAj\u0001\u00049\u0004\u0002CAT\u0003'\u0004\r!!+\t\u000f\u0005e\u00161\u001ba\u0001\u000f\"A\u0011QXAj\u0001\u0004\ty\f\u0003\u0005\u0002R\u0006M\u0007\u0019AA`\u0011!\t9/!%\u0005B\u0005%\u0018a\u0001:v]R\tq\u0006\u0003\u0005\u0002n\u0006EE\u0011BAx\u00031\u0001(/\u001b8u\u001b\u0016\u001c8/Y4f)=y\u0013\u0011_A{\u0003s\fiP!\u0001\u0003\u0006\t%\u0001\u0002CAz\u0003W\u0004\r!a\u000e\u0002\u0005%$\u0007\u0002CA|\u0003W\u0004\r!!\u0015\u0002\u0013\tLH/Z:SK\u0006$\u0007\u0002CA~\u0003W\u0004\r!!\u0015\u0002\u001b1\f7\u000f\u001e\"zi\u0016\u001c(+Z1e\u0011!\ty0a;A\u0002\u0005E\u0013\u0001D7fgN\fw-Z:SK\u0006$\u0007\u0002\u0003B\u0002\u0003W\u0004\r!!\u0015\u0002!1\f7\u000f^'fgN\fw-Z:SK\u0006$\u0007\u0002\u0003B\u0004\u0003W\u0004\r!!\u0015\u0002\u000fM$\u0018M\u001d;Ng\"A!1BAv\u0001\u0004\t\t&A\u0003f]\u0012l5\u000f")
public final class ConsumerPerformance {
    public static final void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsumerPerfConfig
    extends PerfConfig
    implements ScalaObject {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"perf-consumer-").append((Object)BoxesRunTime.boxToInteger((int)new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSet options;
        private final Properties props;
        private final ConsumerConfig consumerConfig;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public Properties props() {
            return this.props;
        }

        public ConsumerConfig consumerConfig() {
            return this.consumerConfig;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.zkConnectOpt()}));
            this.props = new Properties();
            this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
            this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
            this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
            this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
            this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
            this.props().put("consumer.timeout.ms", "5000");
            this.props().put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            this.consumerConfig = new ConsumerConfig(this.props());
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConsumerPerfThread
    extends Thread
    implements ScalaObject {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;

        @Override
        public void run() {
            long startMs;
            long bytesRead = 0L;
            long messagesRead = 0L;
            long lastReportTime = startMs = System.currentTimeMillis();
            long lastBytesRead = 0L;
            long lastMessagesRead = 0L;
            try {
                Iterator iter = this.stream.iterator();
                while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                    Object messageAndMetadata = iter.next();
                    bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                    if (++messagesRead % (long)this.config.reportingInterval() != 0L) continue;
                    if (this.config.showDetailedStats()) {
                        this.printMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, System.currentTimeMillis());
                    }
                    lastReportTime = System.currentTimeMillis();
                    lastMessagesRead = messagesRead;
                    lastBytesRead = bytesRead;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(messagesRead);
            this.totalBytesRead.addAndGet(bytesRead);
            if (this.config.showDetailedStats()) {
                this.printMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis());
            }
        }

        private void printMessage(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs) {
            long elapsedMs = endMs - startMs;
            double totalMBRead = (double)bytesRead * 1.0 / (double)0x100000;
            double mbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s, %d, %d, %.4f, %.4f, %d, %.4f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.config.dateFormat().format(BoxesRunTime.boxToLong((long)endMs)), BoxesRunTime.boxToInteger((int)id), BoxesRunTime.boxToInteger((int)this.config.consumerConfig().fetchMessageMaxBytes()), BoxesRunTime.boxToDouble((double)totalMBRead), BoxesRunTime.boxToDouble((double)(1000.0 * (mbRead / (double)elapsedMs))), BoxesRunTime.boxToLong((long)messagesRead), BoxesRunTime.boxToDouble((double)((double)((messagesRead - lastMessagesRead) / elapsedMs) * 1000.0))})));
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            super(name);
        }
    }
}

