/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.FetchRequest;
import kafka.api.FetchResponsePartitionData;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.PartitionFetchInfo;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.api.StopReplicaRequest;
import kafka.api.UpdateMetadataRequest;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ControllerMovedException;
import kafka.common.ErrorMapping$;
import kafka.common.NotAssignedReplicaException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.MessageSet$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerAndInitialOffset;
import kafka.server.BrokerTopicStats$;
import kafka.server.DelayedFetch;
import kafka.server.DelayedProduce;
import kafka.server.FetchDataInfo;
import kafka.server.FetchRequestPurgatory;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.OffsetCheckpoint;
import kafka.server.OffsetManager;
import kafka.server.PartitionDataAndOffset;
import kafka.server.ProducerRequestPurgatory;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r5x!B\u0001\u0003\u0011\u000b9\u0011A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148cA\u0005\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000e\n\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001dq\u0012B1A\u0005\u0002}\tQ\u0003S5hQ^\u000bG/\u001a:nCJ\\g)\u001b7f]\u0006lW-F\u0001!!\ti\u0011%\u0003\u0002#\u001d\t11\u000b\u001e:j]\u001eDa\u0001J\u0005!\u0002\u0013\u0001\u0013A\u0006%jO\"<\u0016\r^3s[\u0006\u00148NR5mK:\fW.\u001a\u0011\u0007\t)\u0011\u0001AJ\n\u0006K19S\u0006\u0006\t\u0003Q-j\u0011!\u000b\u0006\u0003U\u0011\tQ!\u001e;jYNL!\u0001L\u0015\u0003\u000f1{wmZ5oOB\u0011a&M\u0007\u0002_)\u0011\u0001\u0007B\u0001\b[\u0016$(/[2t\u0013\t\u0011tFA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001\u0002N\u0013\u0003\u0006\u0004%\t!N\u0001\u0007G>tg-[4\u0016\u0003Y\u0002\"\u0001C\u001c\n\u0005a\u0012!aC&bM.\f7i\u001c8gS\u001eD\u0001BO\u0013\u0003\u0002\u0003\u0006IAN\u0001\bG>tg-[4!\u0011!aTE!A!\u0002\u0013i\u0014\u0001\u0002;j[\u0016\u0004\"\u0001\u000b \n\u0005}J#\u0001\u0002+j[\u0016D\u0001\"Q\u0013\u0003\u0006\u0004%\tAQ\u0001\tu.\u001cE.[3oiV\t1\t\u0005\u0002E\u00176\tQI\u0003\u0002G\u000f\u0006A!p[2mS\u0016tGO\u0003\u0002I\u0013\u00061\u0011\nM%uK\u000eT\u0011AS\u0001\u0004_J<\u0017B\u0001'F\u0005!Q6n\u00117jK:$\b\u0002\u0003(&\u0005\u0003\u0005\u000b\u0011B\"\u0002\u0013i\\7\t\\5f]R\u0004\u0003\u0002\u0003)&\u0005\u0003\u0005\u000b\u0011B)\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001\u0015S\u0013\t\u0019\u0016FA\u0005TG\",G-\u001e7fe\"AQ+\nBC\u0002\u0013\u0005a+\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035\u0012\t1\u0001\\8h\u0013\ta\u0016L\u0001\u0006M_\u001el\u0015M\\1hKJD\u0001BX\u0013\u0003\u0002\u0003\u0006IaV\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005\u0003\u0005aK\t\u0015\r\u0011\"\u0001b\u00039I7o\u00155viRLgn\u001a#po:,\u0012A\u0019\t\u0003G*l\u0011\u0001\u001a\u0006\u0003K\u001a\fa!\u0019;p[&\u001c'BA4i\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003SB\tA!\u001e;jY&\u00111\u000e\u001a\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u00115,#\u0011!Q\u0001\n\t\fq\"[:TQV$H/\u001b8h\t><h\u000e\t\u0005\u00067\u0015\"\ta\u001c\u000b\baF\u00148\u000f^;w!\tAQ\u0005C\u00035]\u0002\u0007a\u0007C\u0003=]\u0002\u0007Q\bC\u0003B]\u0002\u00071\tC\u0003Q]\u0002\u0007\u0011\u000bC\u0003V]\u0002\u0007q\u000bC\u0003a]\u0002\u0007!\rC\u0004yK\u0001\u0007I\u0011A=\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\",\u0012A\u001f\t\u0003+mL!\u0001 \f\u0003\u0007%sG\u000fC\u0004\u007fK\u0001\u0007I\u0011A@\u0002'\r|g\u000e\u001e:pY2,'/\u00129pG\"|F%Z9\u0015\t\u0005\u0005\u0011q\u0001\t\u0004+\u0005\r\u0011bAA\u0003-\t!QK\\5u\u0011!\tI!`A\u0001\u0002\u0004Q\u0018a\u0001=%c!9\u0011QB\u0013!B\u0013Q\u0018\u0001E2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!Q\u0011\tY!!\u0005\u0011\u0007U\t\u0019\"C\u0002\u0002\u0016Y\u0011\u0001B^8mCRLG.\u001a\u0005\t\u00033)#\u0019!C\u0005s\u0006iAn\\2bY\n\u0013xn[3s\u0013\u0012Dq!!\b&A\u0003%!0\u0001\bm_\u000e\fGN\u0011:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0013\u0005\u0005RE1A\u0005\n\u0005\r\u0012!D1mYB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002&A9\u0001&a\n\u0002,\u0005\u001d\u0013bAA\u0015S\t!\u0001k\\8m!\u0019)\u0012QFA\u0019u&\u0019\u0011q\u0006\f\u0003\rQ+\b\u000f\\33!\u0011\t\u0019$a\u0011\u000f\t\u0005U\u0012q\b\b\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\u0004\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012bAA!-\u00051\u0001K]3eK\u001aL1AIA#\u0015\r\t\tE\u0006\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n\u0003\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011KA&\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002V\u0015\u0002\u000b\u0011BA\u0013\u00039\tG\u000e\u001c)beRLG/[8og\u0002B\u0011\"!\u0017&\u0005\u0004%I!a\u0017\u0002-I,\u0007\u000f\\5dCN#\u0018\r^3DQ\u0006tw-\u001a'pG.,\u0012\u0001\u0004\u0005\b\u0003?*\u0003\u0015!\u0003\r\u0003]\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f\u0007\"\fgnZ3M_\u000e\\\u0007\u0005C\u0005\u0002d\u0015\u0012\r\u0011\"\u0001\u0002f\u0005)\"/\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014XCAA4!\rA\u0011\u0011N\u0005\u0004\u0003W\u0012!!\u0006*fa2L7-\u0019$fi\u000eDWM]'b]\u0006<WM\u001d\u0005\t\u0003_*\u0003\u0015!\u0003\u0002h\u00051\"/\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005\u0003\u0005\u0002t\u0015\u0012\r\u0011\"\u0003b\u0003\u0011B\u0017n\u001a5XCR,'/\\1sW\u000eCWmY6Q_&tG\u000f\u00165sK\u0006$7\u000b^1si\u0016$\u0007bBA<K\u0001\u0006IAY\u0001&Q&<\u0007nV1uKJl\u0017M]6DQ\u0016\u001c7\u000eU8j]R$\u0006N]3bIN#\u0018M\u001d;fI\u0002B\u0011\"a\u001f&\u0005\u0004%\t!! \u00021!Lw\r[,bi\u0016\u0014X.\u0019:l\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002\u0000A9\u0011\u0011QAFA\u0005=UBAAB\u0015\u0011\t))a\"\u0002\u0013%lW.\u001e;bE2,'bAAE-\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00151\u0011\u0002\u0004\u001b\u0006\u0004\bc\u0001\u0005\u0002\u0012&\u0019\u00111\u0013\u0002\u0003!=3gm]3u\u0007\",7m\u001b9pS:$\b\u0002CALK\u0001\u0006I!a \u00023!Lw\r[,bi\u0016\u0014X.\u0019:l\u0007\",7m\u001b9pS:$8\u000f\t\u0005\n\u00037+\u0003\u0019!C\u0005\u0003;\u000b1\u0003[<UQJ,\u0017\rZ%oSRL\u0017\r\\5{K\u0012,\"!a(\u0011\u0007U\t\t+C\u0002\u0002$Z\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002(\u0016\u0002\r\u0011\"\u0003\u0002*\u00069\u0002n\u001e+ie\u0016\fG-\u00138ji&\fG.\u001b>fI~#S-\u001d\u000b\u0005\u0003\u0003\tY\u000b\u0003\u0006\u0002\n\u0005\u0015\u0016\u0011!a\u0001\u0003?C\u0001\"a,&A\u0003&\u0011qT\u0001\u0015Q^$\u0006N]3bI&s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u0013\u0005MVE1A\u0005\u0002\u0005U\u0016!E:uCR,7\t[1oO\u0016dunZ4feV\u0011\u0011q\u0017\t\u0005\u0003s\u000b)M\u0004\u0003\u0002<\u0006\u0005WBAA_\u0015\r\ty\fB\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002BAb\u0003{\u000bqbS1gW\u0006\u001cuN\u001c;s_2dWM]\u0005\u0005\u0003\u000f\fIMA\tTi\u0006$Xm\u00115b]\u001e,Gj\\4hKJTA!a1\u0002>\"A\u0011QZ\u0013!\u0002\u0013\t9,\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0003\"CAiK\u0001\u0007I\u0011AAj\u0003a\u0001(o\u001c3vG\u0016\u0014(+Z9vKN$\b+\u001e:hCR|'/_\u000b\u0003\u0003+\u00042\u0001CAl\u0013\r\tIN\u0001\u0002\u0019!J|G-^2feJ+\u0017/^3tiB+(oZ1u_JL\b\"CAoK\u0001\u0007I\u0011AAp\u0003q\u0001(o\u001c3vG\u0016\u0014(+Z9vKN$\b+\u001e:hCR|'/_0%KF$B!!\u0001\u0002b\"Q\u0011\u0011BAn\u0003\u0003\u0005\r!!6\t\u0011\u0005\u0015X\u0005)Q\u0005\u0003+\f\u0011\u0004\u001d:pIV\u001cWM\u001d*fcV,7\u000f\u001e)ve\u001e\fGo\u001c:zA!I\u0011\u0011^\u0013A\u0002\u0013\u0005\u00111^\u0001\u0016M\u0016$8\r\u001b*fcV,7\u000f\u001e)ve\u001e\fGo\u001c:z+\t\ti\u000fE\u0002\t\u0003_L1!!=\u0003\u0005U1U\r^2i%\u0016\fX/Z:u!V\u0014x-\u0019;pefD\u0011\"!>&\u0001\u0004%\t!a>\u00023\u0019,Go\u00195SKF,Xm\u001d;QkJ<\u0017\r^8ss~#S-\u001d\u000b\u0005\u0003\u0003\tI\u0010\u0003\u0006\u0002\n\u0005M\u0018\u0011!a\u0001\u0003[D\u0001\"!@&A\u0003&\u0011Q^\u0001\u0017M\u0016$8\r\u001b*fcV,7\u000f\u001e)ve\u001e\fGo\u001c:zA!I!\u0011A\u0013C\u0002\u0013\u0005!1A\u0001\u000eSN\u0014X\t\u001f9b]\u0012\u0014\u0016\r^3\u0016\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005/i!A!\u0003\u000b\t\t-!QB\u0001\u0005G>\u0014XMC\u00021\u0005\u001fQAA!\u0005\u0003\u0014\u00051\u00110Y7nKJT!A!\u0006\u0002\u0007\r|W.\u0003\u0003\u0003\u001a\t%!!B'fi\u0016\u0014\b\u0002\u0003B\u000fK\u0001\u0006IA!\u0002\u0002\u001d%\u001c(/\u0012=qC:$'+\u0019;fA!I!\u0011E\u0013C\u0002\u0013\u0005!1A\u0001\u000eSN\u00148\u000b\u001b:j].\u0014\u0016\r^3\t\u0011\t\u0015R\u0005)A\u0005\u0005\u000b\ta\"[:s'\"\u0014\u0018N\\6SCR,\u0007\u0005C\u0004\u0003*\u0015\"\tAa\u000b\u0002;UtG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]R$\u0012A\u001f\u0005\b\u0005_)C\u0011\u0001B\u0019\u0003\r\u001aH/\u0019:u\u0011&<\u0007nV1uKJl\u0015M]6t\u0007\",7m\u001b)pS:$H\u000b\u001b:fC\u0012$\"!!\u0001\t\u000f\tUR\u0005\"\u0001\u00038\u0005A\u0012N\\5u/&$\bNU3rk\u0016\u001cH\u000fU;sO\u0006$xN]=\u0015\r\u0005\u0005!\u0011\bB\u001e\u0011!\t\tNa\rA\u0002\u0005U\u0007\u0002CAu\u0005g\u0001\r!!<\t\u000f\t}R\u0005\"\u0001\u0003B\u0005iRO\u001c2m_\u000e\\G)\u001a7bs\u0016$\u0007K]8ek\u000e,'+Z9vKN$8\u000f\u0006\u0003\u0002\u0002\t\r\u0003\u0002\u0003B#\u0005{\u0001\rAa\u0012\u0002\u0007-,\u0017\u0010\u0005\u0003\u0003J\t=SB\u0001B&\u0015\r\u0011i\u0005B\u0001\u0007G>lWn\u001c8\n\t\tE#1\n\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007b\u0002B+K\u0011\u0005!qK\u0001\u001ck:\u0014Gn\\2l\t\u0016d\u0017-_3e\r\u0016$8\r\u001b*fcV,7\u000f^:\u0015\t\u0005\u0005!\u0011\f\u0005\t\u0005\u000b\u0012\u0019\u00061\u0001\u0003H!9!QL\u0013\u0005\u0002\tE\u0012aB:uCJ$X\u000f\u001d\u0005\b\u0005C*C\u0011\u0001B2\u0003-\u0019Ho\u001c9SKBd\u0017nY1\u0015\u0011\t\u0015$1\u000eB8\u0005g\u00022!\u0006B4\u0013\r\u0011IG\u0006\u0002\u0006'\"|'\u000f\u001e\u0005\t\u0005[\u0012y\u00061\u0001\u00022\u0005)Ao\u001c9jG\"9!\u0011\u000fB0\u0001\u0004Q\u0018a\u00039beRLG/[8o\u0013\u0012D\u0001B!\u001e\u0003`\u0001\u0007\u0011qT\u0001\u0010I\u0016dW\r^3QCJ$\u0018\u000e^5p]\"9!\u0011P\u0013\u0005\u0002\tm\u0014\u0001D:u_B\u0014V\r\u001d7jG\u0006\u001cH\u0003\u0002B?\u0005\u0013\u0003r!FA\u0017\u0005\u007f\u0012)\u0007\u0005\u0005\u0003\u0002\n\u001d%q\tB3\u001b\t\u0011\u0019I\u0003\u0003\u0003\u0006\u0006\u001d\u0015aB7vi\u0006\u0014G.Z\u0005\u0005\u0003\u001b\u0013\u0019\t\u0003\u0005\u0003\f\n]\u0004\u0019\u0001BG\u0003I\u0019Ho\u001c9SKBd\u0017nY1SKF,Xm\u001d;\u0011\t\t=%QS\u0007\u0003\u0005#S1Aa%\u0005\u0003\r\t\u0007/[\u0005\u0005\u0005/\u0013\tJ\u0001\nTi>\u0004(+\u001a9mS\u000e\f'+Z9vKN$\bb\u0002BNK\u0011\u0005!QT\u0001\u0015O\u0016$xJ]\"sK\u0006$X\rU1si&$\u0018n\u001c8\u0015\r\u0005\u001d#q\u0014BQ\u0011!\u0011iG!'A\u0002\u0005E\u0002b\u0002B9\u00053\u0003\rA\u001f\u0005\b\u0005K+C\u0011\u0001BT\u000319W\r\u001e)beRLG/[8o)\u0019\u0011IKa,\u00032B)QCa+\u0002H%\u0019!Q\u0016\f\u0003\r=\u0003H/[8o\u0011!\u0011iGa)A\u0002\u0005E\u0002b\u0002B9\u0005G\u0003\rA\u001f\u0005\b\u0005k+C\u0011\u0001B\\\u0003U9W\r\u001e*fa2L7-Y(s\u000bb\u001cW\r\u001d;j_:$bA!/\u0003@\n\u0005\u0007\u0003BA%\u0005wKAA!0\u0002L\t9!+\u001a9mS\u000e\f\u0007\u0002\u0003B7\u0005g\u0003\r!!\r\t\u000f\t\r'1\u0017a\u0001u\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0005\u000f,C\u0011\u0001Be\u0003]9W\r\u001e'fC\u0012,'OU3qY&\u001c\u0017-\u00134M_\u000e\fG\u000e\u0006\u0004\u0003:\n-'Q\u001a\u0005\t\u0005[\u0012)\r1\u0001\u00022!9!\u0011\u000fBc\u0001\u0004Q\bb\u0002BiK\u0011\u0005!1[\u0001\u000bO\u0016$(+\u001a9mS\u000e\fG\u0003\u0003Bk\u0005/\u0014INa7\u0011\u000bU\u0011YK!/\t\u0011\t5$q\u001aa\u0001\u0003cAqA!\u001d\u0003P\u0002\u0007!\u0010C\u0005\u0003^\n=\u0007\u0013!a\u0001u\u0006I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0005C,C\u0011\u0001Br\u0003=\u0011X-\u00193NKN\u001c\u0018mZ3TKR\u001cH\u0003\u0002Bs\u0005[\u0004\u0002\"!!\u0002\f\n\u001d#q\u001d\t\u0004\u0011\t%\u0018b\u0001Bv\u0005\t1\u0002+\u0019:uSRLwN\u001c#bi\u0006\fe\u000eZ(gMN,G\u000f\u0003\u0005\u0003p\n}\u0007\u0019\u0001By\u000311W\r^2i%\u0016\fX/Z:u!\u0011\u0011yIa=\n\t\tU(\u0011\u0013\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\b\u0005s,C\u0011\u0002B~\u00039\u0011X-\u00193NKN\u001c\u0018mZ3TKR$BB!@\u0004\f\r51qBB\n\u0007/\u0001r!FA\u0017\u0005\u007f\u001c)\u0001E\u0002\t\u0007\u0003I1aa\u0001\u0003\u000551U\r^2i\t\u0006$\u0018-\u00138g_B\u0019Qca\u0002\n\u0007\r%aC\u0001\u0003M_:<\u0007\u0002\u0003B7\u0005o\u0004\r!!\r\t\u000f\t\r'q\u001fa\u0001u\"A1\u0011\u0003B|\u0001\u0004\u0019)!\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0007+\u00119\u00101\u0001{\u0003\u001di\u0017\r_*ju\u0016Dqa!\u0007\u0003x\u0002\u0007!0A\u0007ge>l'+\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0007;)C\u0011AB\u0010\u0003ai\u0017-\u001f2f+B$\u0017\r^3NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u000b\u0007\u0003\u0003\u0019\tca\u000b\t\u0011\r\r21\u0004a\u0001\u0007K\tQ#\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0005\u0003\u0003\u0010\u000e\u001d\u0012\u0002BB\u0015\u0005#\u0013Q#\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0003\u0005\u0004.\rm\u0001\u0019AB\u0018\u00035iW\r^1eCR\f7)Y2iKB\u0019\u0001b!\r\n\u0007\rM\"AA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\b\u0007o)C\u0011AB\u001d\u0003Y\u0011WmY8nK2+\u0017\rZ3s\u001fJ4u\u000e\u001c7po\u0016\u0014HCBB\u001e\u0007\u0007\u001ai\u0005E\u0004\u0016\u0003[\u0019iD!\u001a\u0011\u0011\r}2\u0011IA\u0016\u0005Kj!!a\"\n\t\u00055\u0015q\u0011\u0005\t\u0007\u000b\u001a)\u00041\u0001\u0004H\u0005\u0019B.Z1eKJ\fe\u000eZ%T%J+\u0017/^3tiB!!qRB%\u0013\u0011\u0019YE!%\u0003'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\t\u0011\r=3Q\u0007a\u0001\u0007#\nQb\u001c4gg\u0016$X*\u00198bO\u0016\u0014\bc\u0001\u0005\u0004T%\u00191Q\u000b\u0002\u0003\u001b=3gm]3u\u001b\u0006t\u0017mZ3s\u0011\u001d\u0019I&\nC\u0005\u00077\n1\"\\1lK2+\u0017\rZ3sgRq\u0011\u0011AB/\u0007C\u001a)g!\u001d\u0004v\rm\u0004bBB0\u0007/\u0002\rA_\u0001\rG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0005\b\u0007G\u001a9\u00061\u0001{\u0003\u0015)\u0007o\\2i\u0011!\u00199ga\u0016A\u0002\r%\u0014A\u00049beRLG/[8o'R\fG/\u001a\t\t\u0007\u007f\u0019\t%a\u0012\u0004lA!!qRB7\u0013\u0011\u0019yG!%\u0003%A\u000b'\u000f^5uS>t7\u000b^1uK&sgm\u001c\u0005\b\u0007g\u001a9\u00061\u0001{\u00035\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\"A1qOB,\u0001\u0004\u0019I(A\u0006sKN\u0004xN\\:f\u001b\u0006\u0004\b\u0003\u0003BA\u0005\u000f\u000bYC!\u001a\t\u0011\r=3q\u000ba\u0001\u0007#Bqaa &\t\u0013\u0019\t)A\u0007nC.,gi\u001c7m_^,'o\u001d\u000b\u0011\u0003\u0003\u0019\u0019i!\"\u0004\b\u000e%5\u0011TBN\u0007;Cqaa\u0018\u0004~\u0001\u0007!\u0010C\u0004\u0004d\ru\u0004\u0019\u0001>\t\u0011\r\u001d4Q\u0010a\u0001\u0007SB\u0001ba#\u0004~\u0001\u00071QR\u0001\bY\u0016\fG-\u001a:t!\u0019\u0019yda$\u0004\u0014&!1\u0011SAD\u0005\r\u0019V\r\u001e\t\u0005\u0003\u0013\u001a)*\u0003\u0003\u0004\u0018\u0006-#A\u0002\"s_.,'\u000fC\u0004\u0004t\ru\u0004\u0019\u0001>\t\u0011\r]4Q\u0010a\u0001\u0007sB\u0001ba\u0014\u0004~\u0001\u00071\u0011\u000b\u0005\b\u0007C+C\u0011\u0002B\u0019\u00039i\u0017-\u001f2f'\"\u0014\u0018N\\6JgJDqa!*&\t\u0003\u00199+\u0001\u0010va\u0012\fG/\u001a*fa2L7-\u0019'F\u001f\u0006sG\rU1si&$\u0018n\u001c8I/RQ\u0011\u0011ABU\u0007W\u001bika,\t\u0011\t541\u0015a\u0001\u0003cAqA!\u001d\u0004$\u0002\u0007!\u0010C\u0004\u0003^\u000e\r\u0006\u0019\u0001>\t\u0011\rE11\u0015a\u0001\u0007c\u00032\u0001CBZ\u0013\r\u0019)L\u0001\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007bBB]K\u0011%11X\u0001\u0014O\u0016$H*Z1eKJ\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0007{\u0003baa0\u0004F\u0006\u001dc\u0002BA\u001b\u0007\u0003L1aa1\u0017\u0003\u001d\u0001\u0018mY6bO\u0016LAaa2\u0004J\n!A*[:u\u0015\r\u0019\u0019M\u0006\u0005\b\u0007\u001b,C\u0011\u0001B\u0019\u0003a\u0019\u0007.Z2la>Lg\u000e\u001e%jO\"<\u0016\r^3s[\u0006\u00148n\u001d\u0005\b\u0007#,C\u0011\u0001B\u0019\u0003!\u0019\b.\u001e;e_^t\u0007\"CBkKE\u0005I\u0011ABl\u0003Q9W\r\u001e*fa2L7-\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u001c\u0016\u0004u\u000em7FABo!\u0011\u0019yn!;\u000e\u0005\r\u0005(\u0002BBr\u0007K\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\u001dh#\u0001\u0006b]:|G/\u0019;j_:LAaa;\u0004b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ReplicaManager
implements Logging,
KafkaMetricsGroup,
ScalaObject {
    private final KafkaConfig config;
    private final Time time;
    private final ZkClient zkClient;
    private final Scheduler scheduler;
    private final LogManager logManager;
    private final AtomicBoolean isShuttingDown;
    private volatile int controllerEpoch;
    private final int kafka$server$ReplicaManager$$localBrokerId;
    private final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions;
    private final Object replicaStateChangeLock;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final AtomicBoolean highWatermarkCheckPointThreadStarted;
    private final scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints;
    private boolean hwThreadInitialized;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private ProducerRequestPurgatory producerRequestPurgatory;
    private FetchRequestPurgatory fetchRequestPurgatory;
    private final Meter isrExpandRate;
    private final Meter isrShrinkRate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final String HighWatermarkFilename() {
        return ReplicaManager$.MODULE$.HighWatermarkFilename();
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    public final int kafka$server$ReplicaManager$$localBrokerId() {
        return this.kafka$server$ReplicaManager$$localBrokerId;
    }

    public final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions() {
        return this.kafka$server$ReplicaManager$$allPartitions;
    }

    private Object replicaStateChangeLock() {
        return this.replicaStateChangeLock;
    }

    public ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private AtomicBoolean highWatermarkCheckPointThreadStarted() {
        return this.highWatermarkCheckPointThreadStarted;
    }

    public scala.collection.immutable.Map<String, OffsetCheckpoint> highWatermarkCheckpoints() {
        return this.highWatermarkCheckpoints;
    }

    private boolean hwThreadInitialized() {
        return this.hwThreadInitialized;
    }

    private void hwThreadInitialized_$eq(boolean bl) {
        this.hwThreadInitialized = bl;
    }

    public KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public ProducerRequestPurgatory producerRequestPurgatory() {
        return this.producerRequestPurgatory;
    }

    public void producerRequestPurgatory_$eq(ProducerRequestPurgatory producerRequestPurgatory) {
        this.producerRequestPurgatory = producerRequestPurgatory;
    }

    public FetchRequestPurgatory fetchRequestPurgatory() {
        return this.fetchRequestPurgatory;
    }

    public void fetchRequestPurgatory_$eq(FetchRequestPurgatory fetchRequestPurgatory) {
        this.fetchRequestPurgatory = fetchRequestPurgatory;
    }

    public Meter isrExpandRate() {
        return this.isrExpandRate;
    }

    public Meter isrShrinkRate() {
        return this.isrShrinkRate;
    }

    public int underReplicatedPartitionCount() {
        return this.kafka$server$ReplicaManager$$getLeaderPartitions().count((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Partition partition) {
                return partition.isUnderReplicated();
            }
        });
    }

    public void startHighWaterMarksCheckPointThread() {
        if (this.highWatermarkCheckPointThreadStarted().compareAndSet(false, true)) {
            String x$15 = "highwatermark-checkpoint";
            Serializable x$16 = new Serializable(this){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointHighWatermarks();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
            long x$17 = this.config().replicaHighWatermarkCheckpointIntervalMs();
            TimeUnit x$18 = TimeUnit.MILLISECONDS;
            long x$19 = this.scheduler.schedule$default$3();
            this.scheduler.schedule("highwatermark-checkpoint", (Function0<BoxedUnit>)x$16, x$19, x$17, TimeUnit.MILLISECONDS);
        }
    }

    public void initWithRequestPurgatory(ProducerRequestPurgatory producerRequestPurgatory, FetchRequestPurgatory fetchRequestPurgatory) {
        this.producerRequestPurgatory_$eq(producerRequestPurgatory);
        this.fetchRequestPurgatory_$eq(fetchRequestPurgatory);
    }

    public void unblockDelayedProduceRequests(TopicAndPartition key$2) {
        Seq satisfied$1 = this.producerRequestPurgatory().update(key$2);
        this.debug((Function0<String>)new Serializable(this, key$2, satisfied$1){
            public static final long serialVersionUID;
            private final TopicAndPartition key$2;
            private final Seq satisfied$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Request key %s unblocked %d producer requests.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$2, BoxesRunTime.boxToInteger((int)this.satisfied$1.size())}));
            }
            {
                this.key$2 = topicAndPartition;
                this.satisfied$1 = seq;
            }
        });
        satisfied$1.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(DelayedProduce delayedProduce) {
                this.$outer.producerRequestPurgatory().respond(delayedProduce);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void unblockDelayedFetchRequests(TopicAndPartition key$1) {
        Seq satisfied$2 = this.fetchRequestPurgatory().update(key$1);
        this.debug((Function0<String>)new Serializable(this, key$1, satisfied$2){
            public static final long serialVersionUID;
            private final TopicAndPartition key$1;
            private final Seq satisfied$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Request key %s unblocked %d fetch requests.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, BoxesRunTime.boxToInteger((int)this.satisfied$2.size())}));
            }
            {
                this.key$1 = topicAndPartition;
                this.satisfied$2 = seq;
            }
        });
        satisfied$2.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(DelayedFetch delayedFetch) {
                this.$outer.fetchRequestPurgatory().respond(delayedFetch);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void startup() {
        String x$20 = "isr-expiration";
        Serializable x$21 = new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicaManager$$maybeShrinkIsr();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
        long x$22 = this.config().replicaLagTimeMaxMs();
        TimeUnit x$23 = TimeUnit.MILLISECONDS;
        long x$24 = this.scheduler.schedule$default$3();
        this.scheduler.schedule("isr-expiration", (Function0<BoxedUnit>)x$21, x$24, x$22, TimeUnit.MILLISECONDS);
    }

    public short stopReplica(String topic$4, int partitionId$2, boolean deletePartition$1) {
        Option<Partition> option;
        block9: {
            short errorCode;
            block8: {
                block7: {
                    Partition removedPartition;
                    this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$4, partitionId$2, deletePartition$1){
                        public static final long serialVersionUID;
                        private final ReplicaManager $outer;
                        private final String topic$4;
                        private final int partitionId$2;
                        private final boolean deletePartition$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Broker %d handling stop replica (delete=%s) for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), ((Object)BoxesRunTime.boxToBoolean((boolean)this.deletePartition$1)).toString(), this.topic$4, BoxesRunTime.boxToInteger((int)this.partitionId$2)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$4 = string;
                            this.partitionId$2 = n;
                            this.deletePartition$1 = bl;
                        }
                    });
                    errorCode = ErrorMapping$.MODULE$.NoError();
                    option = this.getPartition(topic$4, partitionId$2);
                    if (!(option instanceof Some)) break block7;
                    if (deletePartition$1 && (removedPartition = this.kafka$server$ReplicaManager$$allPartitions().remove((Tuple2<String, Object>)new Tuple2((Object)topic$4, (Object)BoxesRunTime.boxToInteger((int)partitionId$2)))) != null) {
                        removedPartition.delete();
                    }
                    break block8;
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                if (deletePartition$1) {
                    TopicAndPartition topicAndPartition = new TopicAndPartition(topic$4, partitionId$2);
                    if (this.logManager().getLog(topicAndPartition).isDefined()) {
                        this.logManager().deleteLog(topicAndPartition);
                    }
                }
                this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$4, partitionId$2, deletePartition$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final String topic$4;
                    private final int partitionId$2;
                    private final boolean deletePartition$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Broker %d ignoring stop replica (delete=%s) for partition [%s,%d] as replica doesn't exist on broker").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)this.deletePartition$1), this.topic$4, BoxesRunTime.boxToInteger((int)this.partitionId$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$4 = string;
                        this.partitionId$2 = n;
                        this.deletePartition$1 = bl;
                    }
                });
            }
            this.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$4, partitionId$2, deletePartition$1){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;
                private final String topic$4;
                private final int partitionId$2;
                private final boolean deletePartition$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Broker %d finished handling stop replica (delete=%s) for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToBoolean((boolean)this.deletePartition$1), this.topic$4, BoxesRunTime.boxToInteger((int)this.partitionId$2)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topic$4 = string;
                    this.partitionId$2 = n;
                    this.deletePartition$1 = bl;
                }
            });
            return errorCode;
        }
        throw new MatchError(option);
    }

    public Tuple2<scala.collection.mutable.Map<TopicAndPartition, Object>, Object> stopReplicas(StopReplicaRequest stopReplicaRequest$1) {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap$1 = new HashMap();
            if (stopReplicaRequest$1.controllerEpoch() < this.controllerEpoch()) {
                this.stateChangeLogger().warn((Function0<String>)new Serializable(this, stopReplicaRequest$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Broker %d received stop replica request from an old controller epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.stopReplicaRequest$1.controllerEpoch())}))).append((Object)" Latest known controller epoch is %d ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.controllerEpoch())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$1, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                this.controllerEpoch_$eq(stopReplicaRequest$1.controllerEpoch());
                this.replicaFetcherManager().removeFetcherForPartitions((Set<TopicAndPartition>)((Set)stopReplicaRequest$1.partitions().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(TopicAndPartition r) {
                        return new TopicAndPartition(r.topic(), r.partition());
                    }
                }, Set$.MODULE$.canBuildFrom())));
                stopReplicaRequest$1.partitions().foreach((Function1)new Serializable(this, stopReplicaRequest$1, responseMap$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    private final StopReplicaRequest stopReplicaRequest$1;
                    private final HashMap responseMap$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<Object> apply(TopicAndPartition topicAndPartition) {
                        short errorCode = this.$outer.stopReplica(topicAndPartition.topic(), topicAndPartition.partition(), this.stopReplicaRequest$1.deletePartitions());
                        return this.responseMap$1.put((Object)topicAndPartition, (Object)BoxesRunTime.boxToShort((short)errorCode));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stopReplicaRequest$1 = stopReplicaRequest;
                        this.responseMap$1 = hashMap;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$1, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Partition getOrCreatePartition(String topic, int partitionId) {
        void var3_3;
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        if (partition == null) {
            this.kafka$server$ReplicaManager$$allPartitions().putIfNotExists((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)), new Partition(topic, partitionId, this.time, this));
            partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        }
        return var3_3;
    }

    public Option<Partition> getPartition(String topic, int partitionId) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitionId)));
        return partition == null ? None$.MODULE$ : new Some((Object)partition);
    }

    public Replica getReplicaOrException(String topic, int partition) {
        Option<Replica> replicaOpt = this.getReplica(topic, partition, this.getReplica$default$3());
        if (replicaOpt.isDefined()) {
            return (Replica)replicaOpt.get();
        }
        throw new ReplicaNotAvailableException(Predef$.MODULE$.augmentString("Replica %d is not available for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), topic, BoxesRunTime.boxToInteger((int)partition)})));
    }

    public Replica getLeaderReplicaIfLocal(String topic, int partitionId) {
        Option<Partition> partitionOpt;
        Option<Partition> option = partitionOpt = this.getPartition(topic, partitionId);
        None$ none$ = None$.MODULE$;
        Option<Partition> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new UnknownTopicOrPartitionException(Predef$.MODULE$.augmentString("Partition [%s,%d] doesn't exist on %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Partition partition = (Partition)some.x();
            Partition partition2 = partition;
            Option<Replica> option3 = partition2.leaderReplicaIfLocal();
            if (option3 instanceof Some) {
                return (Replica)((Some)option3).x();
            }
            None$ none$2 = None$.MODULE$;
            Option<Replica> option4 = option3;
            if (!(none$2 != null ? !none$2.equals(option4) : option4 != null)) {
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
            }
            throw new MatchError(option3);
        }
        throw new MatchError(option);
    }

    public Option<Replica> getReplica(String topic, int partitionId, int replicaId) {
        Option<Partition> option;
        block4: {
            Option<Replica> option2;
            block3: {
                block2: {
                    Option<Partition> partitionOpt;
                    option = partitionOpt = this.getPartition(topic, partitionId);
                    None$ none$ = None$.MODULE$;
                    Option<Partition> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                option2 = ((Partition)((Some)option).x()).getReplica(replicaId);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getReplica$default$3() {
        return this.config().brokerId();
    }

    public scala.collection.immutable.Map<TopicAndPartition, PartitionDataAndOffset> readMessageSets(FetchRequest fetchRequest$1) {
        boolean isFetchFromFollower$1 = fetchRequest$1.isFromFollower();
        return (scala.collection.immutable.Map)fetchRequest$1.requestInfo().map((Function1)new Serializable(this, fetchRequest$1, isFetchFromFollower$1){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            public final FetchRequest fetchRequest$1;
            public final boolean isFetchFromFollower$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<TopicAndPartition, PartitionDataAndOffset> apply(Tuple2<TopicAndPartition, PartitionFetchInfo> tuple2) {
                Tuple2<TopicAndPartition, PartitionFetchInfo> tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError(tuple22);
                TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                PartitionFetchInfo partitionFetchInfo = (PartitionFetchInfo)tuple22._2();
                if (topicAndPartition == null) throw new MatchError(tuple22);
                String string = topicAndPartition.topic();
                int n = topicAndPartition.partition();
                if (partitionFetchInfo == null) throw new MatchError(tuple22);
                long l = partitionFetchInfo.offset();
                int n2 = partitionFetchInfo.fetchSize();
                String topic$1 = string;
                int partition$1 = n;
                long offset$2 = l;
                int fetchSize = n2;
                PartitionDataAndOffset exceptionResult1 = null;
                try {
                    Tuple2<FetchDataInfo, Object> tuple23 = this.$outer.kafka$server$ReplicaManager$$readMessageSet(topic$1, partition$1, offset$2, fetchSize, this.fetchRequest$1.replicaId());
                    if (tuple23 == null) throw new MatchError(tuple23);
                    Tuple2 tuple24 = new Tuple2(tuple23._1(), tuple23._2());
                    FetchDataInfo fetchInfo = (FetchDataInfo)tuple24._1();
                    long highWatermark = tuple24._2$mcJ$sp();
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(topic$1).bytesOutRate().mark((long)fetchInfo.messageSet().sizeInBytes());
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().bytesOutRate().mark((long)fetchInfo.messageSet().sizeInBytes());
                    if (this.isFetchFromFollower$1) {
                        this.$outer.debug((Function0<String>)new Serializable(this, topic$1, partition$1){
                            public static final long serialVersionUID;
                            private final $anonfun$readMessageSets$1 $outer;
                            private final String topic$1;
                            private final int partition$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Partition [%s,%d] received fetch request from follower %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), BoxesRunTime.boxToInteger((int)this.$outer.fetchRequest$1.replicaId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topic$1 = string;
                                this.partition$1 = n;
                            }
                        });
                    }
                    exceptionResult1 = new PartitionDataAndOffset(new FetchResponsePartitionData(ErrorMapping$.MODULE$.NoError(), highWatermark, fetchInfo.messageSet()), fetchInfo.fetchOffset());
                }
                catch (Throwable throwable) {
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(topic$1).failedFetchRequestRate().mark();
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().failedFetchRequestRate().mark();
                    this.$outer.error((Function0<String>)new Serializable(this, topic$1, partition$1, offset$2, throwable){
                        public static final long serialVersionUID;
                        private final $anonfun$readMessageSets$1 $outer;
                        private final String topic$1;
                        private final int partition$1;
                        private final long offset$2;
                        private final Throwable t$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Error when processing fetch request for partition [%s,%d] offset %d from %s with correlation id %d. Possible cause: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), BoxesRunTime.boxToLong((long)this.offset$2), this.$outer.isFetchFromFollower$1 ? "follower" : "consumer", BoxesRunTime.boxToInteger((int)this.$outer.fetchRequest$1.correlationId()), this.t$1.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$1 = string;
                            this.partition$1 = n;
                            this.offset$2 = l;
                            this.t$1 = throwable;
                        }
                    });
                    exceptionResult1 = new PartitionDataAndOffset(new FetchResponsePartitionData(ErrorMapping$.MODULE$.codeFor(throwable.getClass()), -1L, MessageSet$.MODULE$.Empty()), LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
                }
                catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                    this.$outer.warn((Function0<String>)new Serializable(this, topic$1, partition$1, notLeaderForPartitionException){
                        public static final long serialVersionUID;
                        private final $anonfun$readMessageSets$1 $outer;
                        private final String topic$1;
                        private final int partition$1;
                        private final NotLeaderForPartitionException nle$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Fetch request with correlation id %d from client %s on partition [%s,%d] failed due to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.fetchRequest$1.correlationId()), this.$outer.fetchRequest$1.clientId(), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.nle$1.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$1 = string;
                            this.partition$1 = n;
                            this.nle$1 = notLeaderForPartitionException;
                        }
                    });
                    exceptionResult1 = new PartitionDataAndOffset(new FetchResponsePartitionData(ErrorMapping$.MODULE$.codeFor(notLeaderForPartitionException.getClass()), -1L, MessageSet$.MODULE$.Empty()), LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    this.$outer.warn((Function0<String>)new Serializable(this, topic$1, partition$1, unknownTopicOrPartitionException){
                        public static final long serialVersionUID;
                        private final $anonfun$readMessageSets$1 $outer;
                        private final String topic$1;
                        private final int partition$1;
                        private final UnknownTopicOrPartitionException utpe$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Fetch request with correlation id %d from client %s on partition [%s,%d] failed due to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.fetchRequest$1.correlationId()), this.$outer.fetchRequest$1.clientId(), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.utpe$1.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$1 = string;
                            this.partition$1 = n;
                            this.utpe$1 = unknownTopicOrPartitionException;
                        }
                    });
                    exceptionResult1 = new PartitionDataAndOffset(new FetchResponsePartitionData(ErrorMapping$.MODULE$.codeFor(unknownTopicOrPartitionException.getClass()), -1L, MessageSet$.MODULE$.Empty()), LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata());
                }
                PartitionDataAndOffset partitionDataAndOffsetInfo = exceptionResult1;
                return new Tuple2((Object)new TopicAndPartition(topic$1, partition$1), (Object)partitionDataAndOffsetInfo);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fetchRequest$1 = fetchRequest;
                this.isFetchFromFollower$1 = bl;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public final Tuple2<FetchDataInfo, Object> kafka$server$ReplicaManager$$readMessageSet(String topic$2, int partition$2, long offset$3, int maxSize$1, int fromReplicaId) {
        Option<Log> option;
        block4: {
            FetchDataInfo fetchDataInfo;
            Replica localReplica;
            block3: {
                block2: {
                    localReplica = fromReplicaId == Request$.MODULE$.DebuggingConsumerId() ? this.getReplicaOrException(topic$2, partition$2) : this.getLeaderReplicaIfLocal(topic$2, partition$2);
                    this.trace((Function0<String>)new Serializable(this, topic$2, partition$2, offset$3, maxSize$1){
                        public static final long serialVersionUID;
                        private final String topic$2;
                        private final int partition$2;
                        private final long offset$3;
                        private final int maxSize$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Fetching log segment for topic, partition, offset, size = ").append((Object)new Tuple4((Object)this.topic$2, (Object)BoxesRunTime.boxToInteger((int)this.partition$2), (Object)BoxesRunTime.boxToLong((long)this.offset$3), (Object)BoxesRunTime.boxToInteger((int)this.maxSize$1))).toString();
                        }
                        {
                            this.topic$2 = string;
                            this.partition$2 = n;
                            this.offset$3 = l;
                            this.maxSize$1 = n2;
                        }
                    });
                    None$ maxOffsetOpt = Request$.MODULE$.isValidBrokerId(fromReplicaId) ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)localReplica.highWatermark().messageOffset()));
                    option = localReplica.log();
                    if (!(option instanceof Some)) break block2;
                    fetchDataInfo = ((Log)((Some)option).x()).read(offset$3, maxSize$1, (Option<Object>)maxOffsetOpt);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.error((Function0<String>)new Serializable(this, topic$2, partition$2){
                    public static final long serialVersionUID;
                    private final String topic$2;
                    private final int partition$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Leader for partition [%s,%d] does not have a local log").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, BoxesRunTime.boxToInteger((int)this.partition$2)}));
                    }
                    {
                        this.topic$2 = string;
                        this.partition$2 = n;
                    }
                });
                fetchDataInfo = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), MessageSet$.MODULE$.Empty());
            }
            FetchDataInfo fetchInfo = fetchDataInfo;
            return new Tuple2((Object)fetchInfo, (Object)BoxesRunTime.boxToLong((long)localReplica.highWatermark().messageOffset()));
        }
        throw new MatchError(option);
    }

    public void maybeUpdateMetadataCache(UpdateMetadataRequest updateMetadataRequest, MetadataCache metadataCache) {
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            if (updateMetadataRequest.controllerEpoch() < this.controllerEpoch()) {
                String stateControllerEpochErrorMessage$1 = Predef$.MODULE$.augmentString("Broker %d received update metadata request with correlation id %d from an old controller %d with epoch %d. Latest known controller epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)updateMetadataRequest.correlationId()), BoxesRunTime.boxToInteger((int)updateMetadataRequest.controllerId()), BoxesRunTime.boxToInteger((int)updateMetadataRequest.controllerEpoch()), BoxesRunTime.boxToInteger((int)this.controllerEpoch())}));
                this.stateChangeLogger().warn((Function0<String>)new Serializable(this, stateControllerEpochErrorMessage$1){
                    public static final long serialVersionUID;
                    private final String stateControllerEpochErrorMessage$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return this.stateControllerEpochErrorMessage$1;
                    }
                    {
                        this.stateControllerEpochErrorMessage$1 = string;
                    }
                });
                throw new ControllerMovedException(stateControllerEpochErrorMessage$1);
            }
            metadataCache.updateCache(updateMetadataRequest, this.kafka$server$ReplicaManager$$localBrokerId(), this.stateChangeLogger());
            this.controllerEpoch_$eq(updateMetadataRequest.controllerEpoch());
            return;
        }
    }

    public Tuple2<Map<Tuple2<String, Object>, Object>, Object> becomeLeaderOrFollower(LeaderAndIsrRequest leaderAndISRRequest$1, OffsetManager offsetManager) {
        leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            public final LeaderAndIsrRequest leaderAndISRRequest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                if (tuple22 != null) {
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple22._2();
                    if (tuple23 != null) {
                        String string = (String)tuple23._1();
                        int n = BoxesRunTime.unboxToInt((Object)tuple23._2());
                        String topic$5 = string;
                        int partition$3 = n;
                        PartitionStateInfo stateInfo$1 = partitionStateInfo;
                        this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, topic$5, partition$3, stateInfo$1){
                            public static final long serialVersionUID;
                            private final $anonfun$becomeLeaderOrFollower$1 $outer;
                            private final String topic$5;
                            private final int partition$3;
                            private final PartitionStateInfo stateInfo$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request %s correlation id %d from controller %d epoch %d for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), this.stateInfo$1, BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), this.topic$5, BoxesRunTime.boxToInteger((int)this.partition$3)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.topic$5 = string;
                                this.partition$3 = n;
                                this.stateInfo$1 = partitionStateInfo;
                            }
                        });
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple22);
            }

            public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.leaderAndISRRequest$1 = leaderAndIsrRequest;
            }
        });
        Object object = this.replicaStateChangeLock();
        synchronized (object) {
            Tuple2 tuple2;
            HashMap responseMap$2 = new HashMap();
            if (leaderAndISRRequest$1.controllerEpoch() < this.controllerEpoch()) {
                leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final LeaderAndIsrRequest leaderAndISRRequest$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null && tuple22._1() != null) {
                            this.$outer.stateChangeLogger().warn((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anonfun$becomeLeaderOrFollower$2 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Broker %d ignoring LeaderAndIsr request from controller %d with correlation id %d since its controller epoch %d is old. Latest known controller epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().controllerEpoch())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                    }
                });
                tuple2 = new Tuple2((Object)responseMap$2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
            } else {
                int controllerId$1 = leaderAndISRRequest$1.controllerId();
                int correlationId$1 = leaderAndISRRequest$1.correlationId();
                this.controllerEpoch_$eq(leaderAndISRRequest$1.controllerEpoch());
                HashMap partitionState$1 = new HashMap();
                leaderAndISRRequest$1.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndISRRequest$1, responseMap$2, controllerId$1, correlationId$1, partitionState$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final LeaderAndIsrRequest leaderAndISRRequest$1;
                    private final HashMap responseMap$2;
                    public final int controllerId$1;
                    public final int correlationId$1;
                    private final HashMap partitionState$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                        Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null) {
                            Tuple2 tuple23 = (Tuple2)tuple22._1();
                            PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple22._2();
                            if (tuple23 != null) {
                                Option option;
                                String string = (String)tuple23._1();
                                int n = BoxesRunTime.unboxToInt((Object)tuple23._2());
                                String topic$6 = string;
                                int partitionId = n;
                                PartitionStateInfo partitionStateInfo$1 = partitionStateInfo;
                                Partition partition$4 = this.$outer.getOrCreatePartition(topic$6, partitionId);
                                int partitionLeaderEpoch$1 = partition$4.getLeaderEpoch();
                                if (partitionLeaderEpoch$1 < partitionStateInfo$1.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()) {
                                    if (partitionStateInfo$1.allReplicas().contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.config().brokerId()))) {
                                        option = this.partitionState$1.put((Object)partition$4, (Object)partitionStateInfo$1);
                                    } else {
                                        this.$outer.stateChangeLogger().warn((Function0<String>)new Serializable(this, topic$6, partitionStateInfo$1, partition$4){
                                            public static final long serialVersionUID;
                                            private final $anonfun$becomeLeaderOrFollower$3 $outer;
                                            private final String topic$6;
                                            private final PartitionStateInfo partitionStateInfo$1;
                                            private final Partition partition$4;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return Predef$.MODULE$.augmentString("Broker %d ignoring LeaderAndIsr request from controller %d with correlation id %d epoch %d for partition [%s,%d] as itself is not in assigned replica list %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$1), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), this.topic$6, BoxesRunTime.boxToInteger((int)this.partition$4.partitionId()), this.partitionStateInfo$1.allReplicas().mkString(",")}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.topic$6 = string;
                                                this.partitionStateInfo$1 = partitionStateInfo;
                                                this.partition$4 = partition;
                                            }
                                        });
                                        option = BoxedUnit.UNIT;
                                    }
                                } else {
                                    this.$outer.stateChangeLogger().warn((Function0<String>)new Serializable(this, topic$6, partitionStateInfo$1, partition$4, partitionLeaderEpoch$1){
                                        public static final long serialVersionUID;
                                        private final $anonfun$becomeLeaderOrFollower$3 $outer;
                                        private final String topic$6;
                                        private final PartitionStateInfo partitionStateInfo$1;
                                        private final Partition partition$4;
                                        private final int partitionLeaderEpoch$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Broker %d ignoring LeaderAndIsr request from controller %d with correlation id %d epoch %d for partition [%s,%d] since its associated leader epoch %d is old. Current leader epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$1), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$1), BoxesRunTime.boxToInteger((int)this.$outer.leaderAndISRRequest$1.controllerEpoch()), this.topic$6, BoxesRunTime.boxToInteger((int)this.partition$4.partitionId()), BoxesRunTime.boxToInteger((int)this.partitionStateInfo$1.leaderIsrAndControllerEpoch().leaderAndIsr().leaderEpoch()), BoxesRunTime.boxToInteger((int)this.partitionLeaderEpoch$1)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.topic$6 = string;
                                            this.partitionStateInfo$1 = partitionStateInfo;
                                            this.partition$4 = partition;
                                            this.partitionLeaderEpoch$1 = n;
                                        }
                                    });
                                    option = this.responseMap$2.put((Object)new Tuple2((Object)topic$6, (Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleLeaderEpochCode()));
                                }
                                return option;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple22);
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                        this.responseMap$2 = hashMap;
                        this.controllerId$1 = n;
                        this.correlationId$1 = n2;
                        this.partitionState$1 = hashMap2;
                    }
                });
                HashMap partitionsTobeLeader = (HashMap)partitionState$1.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<Partition, PartitionStateInfo> tuple2) {
                        Tuple2<Partition, PartitionStateInfo> tuple22 = tuple2;
                        if (tuple22 != null) {
                            return ((PartitionStateInfo)tuple22._2()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == this.$outer.config().brokerId();
                        }
                        throw new MatchError(tuple22);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                HashMap partitionsToBeFollower = (HashMap)partitionState$1.$minus$minus((GenTraversableOnce)partitionsTobeLeader.keys());
                if (!partitionsTobeLeader.isEmpty()) {
                    this.makeLeaders(controllerId$1, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsTobeLeader, leaderAndISRRequest$1.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap$2, offsetManager);
                }
                if (!partitionsToBeFollower.isEmpty()) {
                    this.makeFollowers(controllerId$1, this.controllerEpoch(), (Map<Partition, PartitionStateInfo>)partitionsToBeFollower, leaderAndISRRequest$1.leaders(), leaderAndISRRequest$1.correlationId(), (scala.collection.mutable.Map<Tuple2<String, Object>, Object>)responseMap$2, offsetManager);
                }
                if (!this.hwThreadInitialized()) {
                    this.startHighWaterMarksCheckPointThread();
                    this.hwThreadInitialized_$eq(true);
                }
                this.replicaFetcherManager().shutdownIdleFetcherThreads();
                tuple2 = new Tuple2((Object)responseMap$2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            Tuple2 tuple22 = tuple2;
            return tuple22;
        }
    }

    private void makeLeaders(int controllerId$2, int epoch$1, Map<Partition, PartitionStateInfo> partitionState, int correlationId$2, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap$3, OffsetManager offsetManager$1) {
        partitionState.foreach((Function1)new Serializable(this, controllerId$2, epoch$1, correlationId$2){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            public final int controllerId$2;
            public final int epoch$1;
            public final int correlationId$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Partition, PartitionStateInfo> state$1) {
                this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, state$1){
                    public static final long serialVersionUID;
                    private final $anonfun$makeLeaders$1 $outer;
                    private final Tuple2 state$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Broker %d handling LeaderAndIsr request correlationId %d from controller %d epoch %d starting the become-leader transition for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$2), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$2), BoxesRunTime.boxToInteger((int)this.$outer.epoch$1), new TopicAndPartition(((Partition)this.state$1._1()).topic(), ((Partition)this.state$1._1()).partitionId())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.state$1 = tuple2;
                    }
                });
            }

            public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.controllerId$2 = n;
                this.epoch$1 = n2;
                this.correlationId$2 = n3;
            }
        });
        partitionState.keys().foreach((Function1)new Serializable(this, responseMap$3){
            public static final long serialVersionUID;
            private final scala.collection.mutable.Map responseMap$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Object> apply(Partition partition) {
                return this.responseMap$3.put((Object)new Tuple2((Object)partition.topic(), (Object)BoxesRunTime.boxToInteger((int)partition.partitionId())), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
            }
            {
                this.responseMap$3 = map;
            }
        });
        try {
            this.replicaFetcherManager().removeFetcherForPartitions((Set<TopicAndPartition>)((Set)partitionState.keySet().map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final TopicAndPartition apply(Partition partition) {
                    return new TopicAndPartition(partition);
                }
            }, Set$.MODULE$.canBuildFrom())));
            partitionState.foreach((Function1)new Serializable(this, controllerId$2, epoch$1, correlationId$2){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;
                public final int controllerId$2;
                public final int epoch$1;
                public final int correlationId$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<Partition, PartitionStateInfo> state$2) {
                    this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, state$2){
                        public static final long serialVersionUID;
                        private final $anonfun$makeLeaders$4 $outer;
                        private final Tuple2 state$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Broker %d stopped fetchers as part of become-leader request from controller %d epoch %d with correlation id %d for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$2), BoxesRunTime.boxToInteger((int)this.$outer.epoch$1), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$2), new TopicAndPartition(((Partition)this.state$2._1()).topic(), ((Partition)this.state$2._1()).partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.state$2 = tuple2;
                        }
                    });
                }

                public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.controllerId$2 = n;
                    this.epoch$1 = n2;
                    this.correlationId$2 = n3;
                }
            });
            partitionState.foreach((Function1)new Serializable(this, controllerId$2, correlationId$2, offsetManager$1){
                public static final long serialVersionUID;
                private final int controllerId$2;
                private final int correlationId$2;
                private final OffsetManager offsetManager$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<Partition, PartitionStateInfo> tuple2) {
                    Tuple2<Partition, PartitionStateInfo> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return ((Partition)tuple22._1()).makeLeader(this.controllerId$2, (PartitionStateInfo)tuple22._2(), this.correlationId$2, this.offsetManager$1);
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.controllerId$2 = n;
                    this.correlationId$2 = n2;
                    this.offsetManager$1 = offsetManager;
                }
            });
        }
        catch (Throwable throwable) {
            partitionState.foreach((Function1)new Serializable(this, controllerId$2, epoch$1, correlationId$2, throwable){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;
                private final int controllerId$2;
                private final int epoch$1;
                private final int correlationId$2;
                public final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<Partition, PartitionStateInfo> state) {
                    String errorMsg$1 = Predef$.MODULE$.augmentString("Error on broker %d while processing LeaderAndIsr request correlationId %d received from controller %d epoch %d for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.correlationId$2), BoxesRunTime.boxToInteger((int)this.controllerId$2), BoxesRunTime.boxToInteger((int)this.epoch$1), new TopicAndPartition(((Partition)state._1()).topic(), ((Partition)state._1()).partitionId())}));
                    this.$outer.stateChangeLogger().error((Function0<String>)new Serializable(this, errorMsg$1){
                        public static final long serialVersionUID;
                        private final String errorMsg$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return this.errorMsg$1;
                        }
                        {
                            this.errorMsg$1 = string;
                        }
                    }, (Function0<Throwable>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$makeLeaders$6 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Throwable apply() {
                            return this.$outer.e$1;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.controllerId$2 = n;
                    this.epoch$1 = n2;
                    this.correlationId$2 = n3;
                    this.e$1 = throwable;
                }
            });
            throw throwable;
        }
        partitionState.foreach((Function1)new Serializable(this, controllerId$2, epoch$1, correlationId$2){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            public final int controllerId$2;
            public final int epoch$1;
            public final int correlationId$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Partition, PartitionStateInfo> state$3) {
                this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, state$3){
                    public static final long serialVersionUID;
                    private final $anonfun$makeLeaders$7 $outer;
                    private final Tuple2 state$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Broker %d completed LeaderAndIsr request correlationId %d from controller %d epoch %d for the become-leader transition for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$2), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$2), BoxesRunTime.boxToInteger((int)this.$outer.epoch$1), new TopicAndPartition(((Partition)this.state$3._1()).topic(), ((Partition)this.state$3._1()).partitionId())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.state$3 = tuple2;
                    }
                });
            }

            public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.controllerId$2 = n;
                this.epoch$1 = n2;
                this.correlationId$2 = n3;
            }
        });
    }

    private void makeFollowers(int controllerId$3, int epoch$2, Map<Partition, PartitionStateInfo> partitionState, Set<Broker> leaders$1, int correlationId$3, scala.collection.mutable.Map<Tuple2<String, Object>, Object> responseMap$4, OffsetManager offsetManager$2) {
        block3: {
            partitionState.foreach((Function1)new Serializable(this, controllerId$3, epoch$2, correlationId$3){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;
                public final int controllerId$3;
                public final int epoch$2;
                public final int correlationId$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<Partition, PartitionStateInfo> state$4) {
                    this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, state$4){
                        public static final long serialVersionUID;
                        private final $anonfun$makeFollowers$1 $outer;
                        private final Tuple2 state$4;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Broker %d handling LeaderAndIsr request correlationId %d from controller %d epoch %d starting the become-follower transition for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.$outer.epoch$2), new TopicAndPartition(((Partition)this.state$4._1()).topic(), ((Partition)this.state$4._1()).partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.state$4 = tuple2;
                        }
                    });
                }

                public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.controllerId$3 = n;
                    this.epoch$2 = n2;
                    this.correlationId$3 = n3;
                }
            });
            partitionState.keys().foreach((Function1)new Serializable(this, responseMap$4){
                public static final long serialVersionUID;
                private final scala.collection.mutable.Map responseMap$4;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Option<Object> apply(Partition partition) {
                    return this.responseMap$4.put((Object)new Tuple2((Object)partition.topic(), (Object)BoxesRunTime.boxToInteger((int)partition.partitionId())), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
                }
                {
                    this.responseMap$4 = map;
                }
            });
            try {
                ObjectRef partitionsToMakeFollower$1 = new ObjectRef((Object)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
                partitionState.foreach((Function1)new Serializable(this, controllerId$3, leaders$1, correlationId$3, offsetManager$2, partitionsToMakeFollower$1){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final int controllerId$3;
                    private final Set leaders$1;
                    public final int correlationId$3;
                    private final OffsetManager offsetManager$2;
                    private final ObjectRef partitionsToMakeFollower$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(Tuple2<Partition, PartitionStateInfo> tuple2) {
                        Tuple2<Partition, PartitionStateInfo> tuple22;
                        block5: {
                            Option option;
                            block8: {
                                Object object;
                                block7: {
                                    int newLeaderBrokerId$1;
                                    LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;
                                    Partition partition$5;
                                    block6: {
                                        tuple22 = tuple2;
                                        if (tuple22 == null) break block5;
                                        Partition partition = (Partition)tuple22._1();
                                        PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple22._2();
                                        partition$5 = partition;
                                        PartitionStateInfo partitionStateInfo2 = partitionStateInfo;
                                        leaderIsrAndControllerEpoch$1 = partitionStateInfo2.leaderIsrAndControllerEpoch();
                                        newLeaderBrokerId$1 = leaderIsrAndControllerEpoch$1.leaderAndIsr().leader();
                                        option = this.leaders$1.find((Function1)new Serializable(this, newLeaderBrokerId$1){
                                            public static final long serialVersionUID;
                                            private final int newLeaderBrokerId$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final boolean apply(Broker broker) {
                                                return broker.id() == this.newLeaderBrokerId$1;
                                            }
                                            {
                                                this.newLeaderBrokerId$1 = n;
                                            }
                                        });
                                        if (!(option instanceof Some)) break block6;
                                        if (partition$5.makeFollower(this.controllerId$3, partitionStateInfo2, this.correlationId$3, this.offsetManager$2)) {
                                            this.partitionsToMakeFollower$1.elem = ((Set)this.partitionsToMakeFollower$1.elem).$plus((Object)partition$5);
                                            object = BoxedUnit.UNIT;
                                        } else {
                                            this.$outer.stateChangeLogger().info((Function0<String>)new Serializable(this, partition$5, leaderIsrAndControllerEpoch$1, newLeaderBrokerId$1){
                                                public static final long serialVersionUID;
                                                private final $anonfun$makeFollowers$3 $outer;
                                                private final Partition partition$5;
                                                private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;
                                                private final int newLeaderBrokerId$1;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return Predef$.MODULE$.augmentString("Broker %d skipped the become-follower state change after marking its partition as follower with correlation id %d from controller %d epoch %d for partition [%s,%d] since the new leader %d is the same as the old leader").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.leaderIsrAndControllerEpoch$1.controllerEpoch()), this.partition$5.topic(), BoxesRunTime.boxToInteger((int)this.partition$5.partitionId()), BoxesRunTime.boxToInteger((int)this.newLeaderBrokerId$1)}));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw new NullPointerException();
                                                    }
                                                    this.$outer = $outer;
                                                    this.partition$5 = partition;
                                                    this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch;
                                                    this.newLeaderBrokerId$1 = n;
                                                }
                                            });
                                            object = BoxedUnit.UNIT;
                                        }
                                        break block7;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option option2 = option;
                                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                                    this.$outer.stateChangeLogger().error((Function0<String>)new Serializable(this, partition$5, leaderIsrAndControllerEpoch$1, newLeaderBrokerId$1){
                                        public static final long serialVersionUID;
                                        private final $anonfun$makeFollowers$3 $outer;
                                        private final Partition partition$5;
                                        private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;
                                        private final int newLeaderBrokerId$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsrRequest with correlation id %d from controller %d epoch %d for partition [%s,%d] but cannot become follower since the new leader %d is unavailable.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.leaderIsrAndControllerEpoch$1.controllerEpoch()), this.partition$5.topic(), BoxesRunTime.boxToInteger((int)this.partition$5.partitionId()), BoxesRunTime.boxToInteger((int)this.newLeaderBrokerId$1)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.partition$5 = partition;
                                            this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch;
                                            this.newLeaderBrokerId$1 = n;
                                        }
                                    });
                                    object = partition$5.getOrCreateReplica(partition$5.getOrCreateReplica$default$1());
                                }
                                return object;
                            }
                            throw new MatchError((Object)option);
                        }
                        throw new MatchError(tuple22);
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.controllerId$3 = n;
                        this.leaders$1 = set;
                        this.correlationId$3 = n2;
                        this.offsetManager$2 = offsetManager;
                        this.partitionsToMakeFollower$1 = objectRef;
                    }
                });
                this.replicaFetcherManager().removeFetcherForPartitions((Set<TopicAndPartition>)((Set)((Set)partitionsToMakeFollower$1.elem).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(Partition partition) {
                        return new TopicAndPartition(partition);
                    }
                }, Set$.MODULE$.canBuildFrom())));
                ((Set)partitionsToMakeFollower$1.elem).foreach((Function1)new Serializable(this, controllerId$3, epoch$2, correlationId$3){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final int controllerId$3;
                    public final int epoch$2;
                    public final int correlationId$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Partition partition$6) {
                        this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, partition$6){
                            public static final long serialVersionUID;
                            private final $anonfun$makeFollowers$5 $outer;
                            private final Partition partition$6;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Broker %d stopped fetchers as part of become-follower request from controller %d epoch %d with correlation id %d for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.$outer.epoch$2), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), new TopicAndPartition(this.partition$6.topic(), this.partition$6.partitionId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.partition$6 = partition;
                            }
                        });
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.controllerId$3 = n;
                        this.epoch$2 = n2;
                        this.correlationId$3 = n3;
                    }
                });
                this.logManager().truncateTo((Map<TopicAndPartition, Object>)((TraversableOnce)((Set)partitionsToMakeFollower$1.elem).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, Object> apply(Partition partition) {
                        return new Tuple2((Object)new TopicAndPartition(partition), (Object)BoxesRunTime.boxToLong((long)partition.getOrCreateReplica(partition.getOrCreateReplica$default$1()).highWatermark().messageOffset()));
                    }
                }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()));
                ((Set)partitionsToMakeFollower$1.elem).foreach((Function1)new Serializable(this, controllerId$3, epoch$2, correlationId$3){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final int controllerId$3;
                    public final int epoch$2;
                    public final int correlationId$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Partition partition$7) {
                        this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, partition$7){
                            public static final long serialVersionUID;
                            private final $anonfun$makeFollowers$7 $outer;
                            private final Partition partition$7;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Broker %d truncated logs and checkpointed recovery boundaries for partition [%s,%d] as part of become-follower request with correlation id %d from controller %d epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), this.partition$7.topic(), BoxesRunTime.boxToInteger((int)this.partition$7.partitionId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.$outer.epoch$2)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.partition$7 = partition;
                            }
                        });
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.controllerId$3 = n;
                        this.epoch$2 = n2;
                        this.correlationId$3 = n3;
                    }
                });
                if (this.isShuttingDown().get()) {
                    ((Set)partitionsToMakeFollower$1.elem).foreach((Function1)new Serializable(this, controllerId$3, epoch$2, correlationId$3){
                        public static final long serialVersionUID;
                        private final ReplicaManager $outer;
                        public final int controllerId$3;
                        public final int epoch$2;
                        public final int correlationId$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Partition partition$8) {
                            this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, partition$8){
                                public static final long serialVersionUID;
                                private final $anonfun$makeFollowers$8 $outer;
                                private final Partition partition$8;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Broker %d skipped the adding-fetcher step of the become-follower state change with correlation id %d from controller %d epoch %d for partition [%s,%d] since it is shutting down").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.$outer.epoch$2), this.partition$8.topic(), BoxesRunTime.boxToInteger((int)this.partition$8.partitionId())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.partition$8 = partition;
                                }
                            });
                        }

                        public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.controllerId$3 = n;
                            this.epoch$2 = n2;
                            this.correlationId$3 = n3;
                        }
                    });
                    break block3;
                }
                scala.collection.immutable.Map partitionsToMakeFollowerWithLeaderAndOffset = ((TraversableOnce)((Set)partitionsToMakeFollower$1.elem).map((Function1)new Serializable(this, leaders$1){
                    public static final long serialVersionUID;
                    private final Set leaders$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, BrokerAndInitialOffset> apply(Partition partition$9) {
                        return Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(partition$9)).$minus$greater((Object)new BrokerAndInitialOffset((Broker)this.leaders$1.find((Function1)new Serializable(this, partition$9){
                            public static final long serialVersionUID;
                            private final Partition partition$9;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(Broker broker) {
                                return broker.id() == BoxesRunTime.unboxToInt((Object)this.partition$9.leaderReplicaIdOpt().get());
                            }
                            {
                                this.partition$9 = partition;
                            }
                        }).get(), ((Replica)partition$9.getReplica(partition$9.getReplica$default$1()).get()).logEndOffset().messageOffset()));
                    }
                    {
                        this.leaders$1 = set;
                    }
                }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                this.replicaFetcherManager().addFetcherForPartitions((Map<TopicAndPartition, BrokerAndInitialOffset>)partitionsToMakeFollowerWithLeaderAndOffset);
                ((Set)partitionsToMakeFollower$1.elem).foreach((Function1)new Serializable(this, controllerId$3, epoch$2, correlationId$3){
                    public static final long serialVersionUID;
                    private final ReplicaManager $outer;
                    public final int controllerId$3;
                    public final int epoch$2;
                    public final int correlationId$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Partition partition$10) {
                        this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, partition$10){
                            public static final long serialVersionUID;
                            private final $anonfun$makeFollowers$9 $outer;
                            private final Partition partition$10;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Broker %d started fetcher to new leader as part of become-follower request from controller %d epoch %d with correlation id %d for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.$outer.epoch$2), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), this.partition$10.topic(), BoxesRunTime.boxToInteger((int)this.partition$10.partitionId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.partition$10 = partition;
                            }
                        });
                    }

                    public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.controllerId$3 = n;
                        this.epoch$2 = n2;
                        this.correlationId$3 = n3;
                    }
                });
            }
            catch (Throwable throwable) {
                String errorMsg$2 = Predef$.MODULE$.augmentString("Error on broker %d while processing LeaderAndIsr request with correlationId %d received from controller %d epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)correlationId$3), BoxesRunTime.boxToInteger((int)controllerId$3), BoxesRunTime.boxToInteger((int)epoch$2)}));
                this.stateChangeLogger().error((Function0<String>)new Serializable(this, errorMsg$2){
                    public static final long serialVersionUID;
                    private final String errorMsg$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return this.errorMsg$2;
                    }
                    {
                        this.errorMsg$2 = string;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID;
                    private final Throwable e$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e$2;
                    }
                    {
                        this.e$2 = throwable;
                    }
                });
                throw throwable;
            }
        }
        partitionState.foreach((Function1)new Serializable(this, controllerId$3, epoch$2, correlationId$3){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            public final int controllerId$3;
            public final int epoch$2;
            public final int correlationId$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Partition, PartitionStateInfo> state$5) {
                this.$outer.stateChangeLogger().trace((Function0<String>)new Serializable(this, state$5){
                    public static final long serialVersionUID;
                    private final $anonfun$makeFollowers$12 $outer;
                    private final Tuple2 state$5;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Broker %d completed LeaderAndIsr request correlationId %d from controller %d epoch %d for the become-follower transition for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$anonfun$$$outer().kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.$outer.correlationId$3), BoxesRunTime.boxToInteger((int)this.$outer.controllerId$3), BoxesRunTime.boxToInteger((int)this.$outer.epoch$2), new TopicAndPartition(((Partition)this.state$5._1()).topic(), ((Partition)this.state$5._1()).partitionId())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.state$5 = tuple2;
                    }
                });
            }

            public ReplicaManager kafka$server$ReplicaManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.controllerId$3 = n;
                this.epoch$2 = n2;
                this.correlationId$3 = n3;
            }
        });
    }

    public final void kafka$server$ReplicaManager$$maybeShrinkIsr() {
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Evaluating ISR list of partitions to see which replicas can be removed from the ISR";
            }
        });
        this.kafka$server$ReplicaManager$$allPartitions().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Partition partition) {
                partition.maybeShrinkIsr(this.$outer.config().replicaLagTimeMaxMs(), this.$outer.config().replicaLagMaxMessages());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void updateReplicaLEOAndPartitionHW(String topic$3, int partitionId$1, int replicaId$1, LogOffsetMetadata offset$4) {
        Option<Partition> option;
        block7: {
            block6: {
                block4: {
                    Option<Replica> option2;
                    Partition partition;
                    block5: {
                        option = this.getPartition(topic$3, partitionId$1);
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        Partition partition2 = (Partition)some.x();
                        partition = partition2;
                        option2 = partition.getReplica(replicaId$1);
                        if (!(option2 instanceof Some)) break block5;
                        ((Replica)((Some)option2).x()).logEndOffset_$eq(offset$4);
                        partition.updateLeaderHWAndMaybeExpandIsr(replicaId$1);
                        this.debug((Function0<String>)new Serializable(this, topic$3, partitionId$1, replicaId$1, offset$4){
                            public static final long serialVersionUID;
                            private final String topic$3;
                            private final int partitionId$1;
                            private final int replicaId$1;
                            private final LogOffsetMetadata offset$4;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Recorded follower %d position %d for partition [%s,%d].").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), BoxesRunTime.boxToLong((long)this.offset$4.messageOffset()), this.topic$3, BoxesRunTime.boxToInteger((int)this.partitionId$1)}));
                            }
                            {
                                this.topic$3 = string;
                                this.partitionId$1 = n;
                                this.replicaId$1 = n2;
                                this.offset$4 = logOffsetMetadata;
                            }
                        });
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option3 = option2;
                    if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                        throw new NotAssignedReplicaException(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d since the replica is not recognized to be one of the assigned replicas %s for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)replicaId$1), BoxesRunTime.boxToLong((long)offset$4.messageOffset()), ((TraversableOnce)partition.assignedReplicas().map((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final int apply(Replica replica) {
                                return replica.brokerId();
                            }
                        }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).mkString(","), topic$3, BoxesRunTime.boxToInteger((int)partitionId$1)})));
                    }
                    throw new MatchError(option2);
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option4 = option;
                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                this.warn((Function0<String>)new Serializable(this, topic$3, partitionId$1){
                    public static final long serialVersionUID;
                    private final String topic$3;
                    private final int partitionId$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("While recording the follower position, the partition [%s,%d] hasn't been created, skip updating leader HW").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3, BoxesRunTime.boxToInteger((int)this.partitionId$1)}));
                    }
                    {
                        this.topic$3 = string;
                        this.partitionId$1 = n;
                    }
                });
            }
            return;
        }
        throw new MatchError(option);
    }

    public final List<Partition> kafka$server$ReplicaManager$$getLeaderPartitions() {
        return ((TraversableOnce)this.kafka$server$ReplicaManager$$allPartitions().values().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Partition partition) {
                return partition.leaderReplicaIfLocal().isDefined();
            }
        })).toList();
    }

    public void checkpointHighWatermarks() {
        Iterable replicas = (Iterable)((TraversableLike)this.kafka$server$ReplicaManager$$allPartitions().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Replica> apply(Partition partition) {
                return partition.getReplica(this.$outer.config().brokerId());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).collect(new PartialFunction(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Replica apply(Option<Replica> option) {
                Option<Replica> option2 = option;
                if (option2 instanceof Some) {
                    return (Replica)((Some)option2).x();
                }
                throw new MatchError(option2);
            }

            public final boolean isDefinedAt(Option<Replica> option) {
                Option<Replica> option2 = option;
                return option2 instanceof Some;
            }
            {
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map replicasByDir = ((TraversableLike)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica replica) {
                return replica.log().isDefined();
            }
        })).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Replica replica) {
                return ((Log)replica.log().get()).dir().getParentFile().getAbsolutePath();
            }
        });
        ((IterableLike)replicasByDir.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Iterable iterable;
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                if (tuple22 == null) throw new MatchError(tuple22);
                Iterable reps = iterable = (Iterable)tuple22._2();
                scala.collection.immutable.Map hwms = ((TraversableOnce)reps.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, Object> apply(Replica r) {
                        return Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(r)).$minus$greater((Object)BoxesRunTime.boxToLong((long)r.highWatermark().messageOffset()));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                try {
                    ((OffsetCheckpoint)this.$outer.highWatermarkCheckpoints().apply(tuple22._1())).write((Map<TopicAndPartition, Object>)hwms);
                    return;
                }
                catch (IOException iOException) {
                    this.$outer.fatal((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Error writing to highwatermark file: ";
                        }
                    }, (Function0<Throwable>)new Serializable(this, iOException){
                        public static final long serialVersionUID;
                        private final IOException e$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final IOException apply() {
                            return this.e$3;
                        }
                        {
                            this.e$3 = iOException;
                        }
                    });
                    Runtime.getRuntime().halt(1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shut down";
            }
        });
        this.replicaFetcherManager().shutdown();
        this.checkpointHighWatermarks();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shut down completely";
            }
        });
    }

    public ReplicaManager(KafkaConfig config, Time time, ZkClient zkClient, Scheduler scheduler, LogManager logManager, AtomicBoolean isShuttingDown) {
        this.config = config;
        this.time = time;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.logManager = logManager;
        this.isShuttingDown = isShuttingDown;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.kafka$server$ReplicaManager$$localBrokerId = config.brokerId();
        this.kafka$server$ReplicaManager$$allPartitions = new Pool(Pool$.MODULE$.init$default$1());
        this.replicaStateChangeLock = new Object();
        this.replicaFetcherManager = new ReplicaFetcherManager(config, this);
        this.highWatermarkCheckPointThreadStarted = new AtomicBoolean(false);
        this.highWatermarkCheckpoints = ((TraversableOnce)config.logDirs().map((Function1)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.hwThreadInitialized = false;
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.producerRequestPurgatory = null;
        this.fetchRequestPurgatory = null;
        this.newGauge("LeaderCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$getLeaderPartitions().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.newGauge$default$3());
        this.newGauge("PartitionCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$allPartitions().size();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.newGauge$default$3());
        this.newGauge("UnderReplicatedPartitions", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.underReplicatedPartitionCount();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.newGauge$default$3());
        this.isrExpandRate = this.newMeter("IsrExpandsPerSec", "expands", TimeUnit.SECONDS, (Map<String, String>)this.newMeter$default$4());
        this.isrShrinkRate = this.newMeter("IsrShrinksPerSec", "shrinks", TimeUnit.SECONDS, (Map<String, String>)this.newMeter$default$4());
    }
}

