/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionLeaderSelector;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u000f\t9\u0003K]3gKJ\u0014X\r\u001a*fa2L7-\u0019)beRLG/[8o\u0019\u0016\fG-\u001a:TK2,7\r^8s\u0015\t\u0019A!\u0001\u0006d_:$(o\u001c7mKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\u000b\u001b!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005]\u0001\u0016M\u001d;ji&|g\u000eT3bI\u0016\u00148+\u001a7fGR|'\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)Q\u000f^5mg&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\t\t2%\u0003\u0002%\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002\u0012\u0001!)\u0011%\na\u0001E!)1\u0006\u0001C\u0001Y\u0005a1/\u001a7fGRdU-\u00193feR\u0019Q&R'\u0011\tmq\u0003GN\u0005\u0003_q\u0011a\u0001V;qY\u0016\u0014\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0005\u0003\r\t\u0007/[\u0005\u0003kI\u0012A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJ\u00042aN C\u001d\tATH\u0004\u0002:y5\t!H\u0003\u0002<\r\u00051AH]8pizJ\u0011!H\u0005\u0003}q\tq\u0001]1dW\u0006<W-\u0003\u0002A\u0003\n\u00191+Z9\u000b\u0005yb\u0002CA\u000eD\u0013\t!EDA\u0002J]RDQA\u0012\u0016A\u0002\u001d\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o!\tA5*D\u0001J\u0015\tQE!\u0001\u0004d_6lwN\\\u0005\u0003\u0019&\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u0015q%\u00061\u00011\u0003M\u0019WO\u001d:f]RdU-\u00193fe\u0006sG-S:s\u0001")
public class PreferredReplicaPartitionLeaderSelector
implements PartitionLeaderSelector,
Logging,
ScalaObject {
    private final ControllerContext controllerContext;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public Tuple2<LeaderAndIsr, Seq<Object>> selectLeader(TopicAndPartition topicAndPartition$2, LeaderAndIsr currentLeaderAndIsr) {
        Seq assignedReplicas = (Seq)this.controllerContext.partitionReplicaAssignment().apply((Object)topicAndPartition$2);
        int preferredReplica = BoxesRunTime.unboxToInt((Object)assignedReplicas.head());
        int currentLeader$1 = ((LeaderIsrAndControllerEpoch)this.controllerContext.partitionLeadershipInfo().apply((Object)topicAndPartition$2)).leaderAndIsr().leader();
        if (currentLeader$1 == preferredReplica) {
            throw new LeaderElectionNotNeededException(Predef$.MODULE$.augmentString("Preferred replica %d is already the current leader for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)preferredReplica), topicAndPartition$2})));
        }
        this.info((Function0<String>)new Serializable(this, topicAndPartition$2, currentLeader$1){
            public static final long serialVersionUID;
            private final TopicAndPartition topicAndPartition$2;
            private final int currentLeader$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Current leader %d for partition %s is not the preferred replica.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentLeader$1), this.topicAndPartition$2}))).append((Object)" Trigerring preferred replica leader election").toString();
            }
            {
                this.topicAndPartition$2 = topicAndPartition;
                this.currentLeader$1 = n;
            }
        });
        if (this.controllerContext.liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)preferredReplica)) && currentLeaderAndIsr.isr().contains((Object)BoxesRunTime.boxToInteger((int)preferredReplica))) {
            return new Tuple2((Object)new LeaderAndIsr(preferredReplica, currentLeaderAndIsr.leaderEpoch() + 1, currentLeaderAndIsr.isr(), currentLeaderAndIsr.zkVersion() + 1), (Object)assignedReplicas);
        }
        throw new StateChangeFailedException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Preferred replica %d for partition ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)preferredReplica)}))).append((Object)Predef$.MODULE$.augmentString("%s is either not alive or not in the isr. Current leader and ISR: [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition$2, currentLeaderAndIsr}))).toString());
    }

    public PreferredReplicaPartitionLeaderSelector(ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
        Logging$class.$init$(this);
        this.logIdent_$eq("[PreferredReplicaPartitionLeaderSelector]: ");
    }
}

